/*     */ package com.arjuna.ats.txoj;
/*     */ 
/*     */ public class LockList
/*     */ {
/*     */   protected Lock head;
/*     */   private int count;
/*     */ 
/*     */   public LockList()
/*     */   {
/*  39 */     this.count = 0;
/*  40 */     this.head = null;
/*     */   }
/*     */ 
/*     */   public void finalize()
/*     */   {
/*  45 */     Lock temp = null;
/*     */ 
/*  47 */     while ((temp = pop()) != null)
/*  48 */       temp = null;
/*     */   }
/*     */ 
/*     */   public final boolean insert(Lock newlock)
/*     */   {
/*  59 */     LockListIterator next = new LockListIterator(this);
/*  60 */     Lock current = null;
/*     */ 
/*  62 */     while ((current = next.iterate()) != null)
/*     */     {
/*  64 */       if (current.equals(newlock))
/*     */       {
/*  66 */         return false;
/*     */       }
/*     */     }
/*     */ 
/*  70 */     push(newlock);
/*     */ 
/*  72 */     return true;
/*     */   }
/*     */ 
/*     */   public final Lock pop()
/*     */   {
/*  83 */     if (this.count == 0) {
/*  84 */       return null;
/*     */     }
/*  86 */     Lock current = this.head;
/*  87 */     this.count -= 1;
/*  88 */     this.head = this.head.getLink();
/*  89 */     current.setLink(null);
/*     */ 
/*  91 */     return current;
/*     */   }
/*     */ 
/*     */   public final void push(Lock newLock)
/*     */   {
/* 101 */     newLock.setLink(this.head);
/* 102 */     this.head = newLock;
/* 103 */     this.count += 1;
/*     */   }
/*     */ 
/*     */   public final void forgetNext(Lock current)
/*     */   {
/* 115 */     if (this.count > 0)
/*     */     {
/* 117 */       if (current == null) {
/* 118 */         this.head = this.head.getLink();
/*     */       }
/*     */       else {
/* 121 */         Lock nextOne = current.getLink();
/*     */ 
/* 125 */         if (nextOne != null) {
/* 126 */           current.setLink(nextOne.getLink());
/*     */         }
/*     */         else
/*     */         {
/* 133 */           this.count += 1;
/* 134 */           current.setLink(null);
/*     */         }
/*     */       }
/*     */ 
/* 138 */       this.count -= 1;
/*     */     }
/*     */   }
/*     */ 
/*     */   public final int entryCount()
/*     */   {
/* 144 */     return this.count;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.txoj.LockList
 * JD-Core Version:    0.6.0
 */