/*     */ package com.arjuna.ats.tsmx.common;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.util.Properties;
/*     */ 
/*     */ public class Configuration
/*     */ {
/*     */   private static final Properties PROPS;
/*     */   private static String _propFile;
/*     */ 
/*     */   public static final synchronized String propertiesFile()
/*     */   {
/*  38 */     return _propFile;
/*     */   }
/*     */ 
/*     */   public static final synchronized void setPropertiesFile(String file)
/*     */   {
/*  47 */     _propFile = file;
/*     */   }
/*     */ 
/*     */   public static final String version()
/*     */   {
/*  56 */     return getBuildTimeProperty("TSMX_VERSION");
/*     */   }
/*     */ 
/*     */   public static String getBuildTimeProperty(String name)
/*     */   {
/*  66 */     if (PROPS == null)
/*     */     {
/*  68 */       return "";
/*     */     }
/*     */ 
/*  72 */     return PROPS.getProperty(name, "");
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  80 */     InputStream is = Configuration.class.getResourceAsStream("/tsmx.properties");
/*  81 */     if (is != null)
/*     */     {
/*  83 */       Properties props = new Properties();
/*     */       try
/*     */       {
/*  86 */         props.load(is);
/*     */       }
/*     */       catch (IOException ioe)
/*     */       {
/*  90 */         props = null;
/*     */       }
/*  92 */       PROPS = props;
/*     */     }
/*     */     else
/*     */     {
/*  96 */       PROPS = null;
/*     */     }
/*     */ 
/* 100 */     _propFile = getBuildTimeProperty("PROPERTIES_FILE");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.tsmx.common.Configuration
 * JD-Core Version:    0.6.0
 */