/*     */ package com.arjuna.ats.tsmx;
/*     */ 
/*     */ import com.arjuna.ats.tsmx.agent.AgentInterface;
/*     */ import com.arjuna.ats.tsmx.agent.exceptions.AgentNotFoundException;
/*     */ import com.arjuna.ats.tsmx.common.Configuration;
/*     */ import com.arjuna.ats.tsmx.logging.tsmxLogger;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import java.io.InputStream;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Enumeration;
/*     */ import java.util.HashSet;
/*     */ import java.util.Properties;
/*     */ import javax.management.InstanceAlreadyExistsException;
/*     */ import javax.management.MBeanException;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ 
/*     */ public class TransactionServiceMX
/*     */ {
/*     */   public static final String AGENT_IMPLEMENTATION_PROPERTY = "com.arjuna.ats.tsmx.agentimpl";
/*     */   private static final String DEFAULT_AGENT_IMPLEMENTATION = "com.arjuna.ats.internal.tsmx.agent.implementations.ri.RefAgentImpl";
/*     */   private static final String MBEAN_PROPERTY_PREFIX = "com.arjuna.ats.tsmx.mbean.";
/*     */   private static final String MBEAN_CLASSNAME_SUFFIX = ".classname";
/*     */   private static final String MBEAN_OBJECTNAME_SUFFIX = ".objectname";
/*  56 */   private static TransactionServiceMX _tsmx = null;
/*     */ 
/*  68 */   private MBeanServer _mbeanServer = null;
/*  69 */   private ArrayList _beans = null;
/*  70 */   private AgentInterface _agent = null;
/*  71 */   private Properties _tsmxProps = null;
/*     */ 
/*     */   public static final TransactionServiceMX getTransactionServiceMX()
/*     */   {
/*  60 */     if (_tsmx == null)
/*     */     {
/*  62 */       _tsmx = new TransactionServiceMX();
/*     */     }
/*     */ 
/*  65 */     return _tsmx;
/*     */   }
/*     */ 
/*     */   protected TransactionServiceMX()
/*     */   {
/*  75 */     if (tsmxLogger.logger.debugAllowed())
/*     */     {
/*  77 */       tsmxLogger.logger.debug(2L, 4L, 1L, "TransactionService Management Extentions initialising");
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/*  83 */       loadProperties();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  87 */       throw new Error("An error occurred while trying to load the tsmx properties: " + e);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/*  92 */       this._mbeanServer = this._agent.getAgent();
/*     */     }
/*     */     catch (AgentNotFoundException e)
/*     */     {
/*  96 */       throw new Error("Failed to find agent: " + e);
/*     */     }
/*     */ 
/*  99 */     this._beans = new ArrayList();
/*     */ 
/* 101 */     registerMBeans();
/*     */   }
/*     */ 
/*     */   protected void loadProperties() throws Exception
/*     */   {
/* 106 */     if (this._agent == null)
/*     */     {
/* 108 */       this._tsmxProps = System.getProperties();
/*     */ 
/* 111 */       InputStream inStr = Thread.currentThread().getContextClassLoader().getResourceAsStream(Configuration.propertiesFile());
/* 112 */       if (inStr != null)
/*     */       {
/* 114 */         this._tsmxProps.load(inStr);
/*     */       }
/*     */ 
/* 118 */       String agentImpl = this._tsmxProps.getProperty("com.arjuna.ats.tsmx.agentimpl", "com.arjuna.ats.internal.tsmx.agent.implementations.ri.RefAgentImpl");
/*     */ 
/* 120 */       if (tsmxLogger.logger.isInfoEnabled())
/*     */       {
/* 122 */         tsmxLogger.logger.info("Initialising JMX agent " + agentImpl);
/*     */       }
/*     */ 
/* 126 */       this._agent = ((AgentInterface)Thread.currentThread().getContextClassLoader().loadClass(agentImpl).newInstance());
/*     */     }
/*     */   }
/*     */ 
/*     */   private final String stripNameFromProperty(String propertyName)
/*     */   {
/* 138 */     String name = null;
/*     */ 
/* 140 */     if (propertyName.startsWith("com.arjuna.ats.tsmx.mbean."))
/*     */     {
/* 142 */       if (propertyName.endsWith(".classname"))
/*     */       {
/* 144 */         name = propertyName.substring("com.arjuna.ats.tsmx.mbean.".length());
/* 145 */         name = name.substring(0, name.indexOf(".classname"));
/*     */       }
/* 147 */       else if (propertyName.endsWith(".objectname"))
/*     */       {
/* 149 */         name = propertyName.substring("com.arjuna.ats.tsmx.mbean.".length());
/* 150 */         name = name.substring(0, name.indexOf(".objectname"));
/*     */       }
/*     */     }
/*     */ 
/* 154 */     return name;
/*     */   }
/*     */ 
/*     */   private static final String getClassPropertyName(String mbeanName)
/*     */   {
/* 159 */     return "com.arjuna.ats.tsmx.mbean." + mbeanName + ".classname";
/*     */   }
/*     */ 
/*     */   private static final String getObjectPropertyName(String mbeanName)
/*     */   {
/* 164 */     return "com.arjuna.ats.tsmx.mbean." + mbeanName + ".objectname";
/*     */   }
/*     */ 
/*     */   public final String getObjectName(String mbeanName)
/*     */   {
/* 169 */     return this._tsmxProps.getProperty(getObjectPropertyName(mbeanName));
/*     */   }
/*     */ 
/*     */   public final Properties getProperties()
/*     */   {
/* 174 */     return this._tsmxProps;
/*     */   }
/*     */ 
/*     */   public final AgentInterface getAgentInterface()
/*     */   {
/* 179 */     return this._agent;
/*     */   }
/*     */ 
/*     */   private boolean registerMBeans()
/*     */   {
/* 191 */     boolean success = true;
/* 192 */     Properties props = getProperties();
/* 193 */     Enumeration propNames = props.propertyNames();
/* 194 */     HashSet foundProperties = new HashSet();
/*     */ 
/* 196 */     if (tsmxLogger.logger.debugAllowed())
/*     */     {
/* 198 */       tsmxLogger.logger.debug(2L, 4L, 1L, "Registering transaction service mbeans");
/*     */     }
/*     */ 
/* 203 */     while (propNames.hasMoreElements())
/*     */     {
/* 205 */       String propertyName = (String)propNames.nextElement();
/*     */ 
/* 207 */       if (propertyName.startsWith("com.arjuna.ats.tsmx.mbean."))
/*     */       {
/* 209 */         String mbeanName = stripNameFromProperty(propertyName);
/* 210 */         if (!foundProperties.contains(mbeanName))
/*     */         {
/* 212 */           String mbeanClassname = props.getProperty(getClassPropertyName(mbeanName));
/* 213 */           String mbeanObjectName = props.getProperty(getObjectPropertyName(mbeanName));
/*     */           try
/*     */           {
/* 216 */             if (tsmxLogger.logger.debugAllowed())
/*     */             {
/* 218 */               tsmxLogger.logger.debug(2L, 4L, 1L, "Registering mbean '" + mbeanClassname + "' against '" + mbeanObjectName + "'");
/*     */             }
/*     */ 
/* 222 */             this._mbeanServer.createMBean(mbeanClassname, new ObjectName(mbeanObjectName));
/* 223 */             this._beans.add(mbeanObjectName);
/*     */ 
/* 225 */             foundProperties.add(mbeanName);
/*     */           }
/*     */           catch (InstanceAlreadyExistsException e)
/*     */           {
/* 229 */             if (tsmxLogger.logger.isWarnEnabled())
/*     */             {
/* 231 */               tsmxLogger.loggerI18N.warn("com.arjuna.ats.tsmx.TransactionServiceMX.mbeanalreadyregistered", new Object[] { mbeanObjectName });
/*     */             }
/*     */           }
/*     */           catch (MBeanException e)
/*     */           {
/* 236 */             if (tsmxLogger.logger.isErrorEnabled())
/*     */             {
/* 238 */               tsmxLogger.loggerI18N.error("com.arjuna.ats.tsmx.TransactionServiceMX.failedtoregistermbean", new Object[] { mbeanObjectName, e.getTargetException().toString() });
/*     */             }
/* 240 */             success = false;
/*     */           }
/*     */           catch (Exception e)
/*     */           {
/* 244 */             if (tsmxLogger.logger.isErrorEnabled())
/*     */             {
/* 246 */               tsmxLogger.loggerI18N.error("com.arjuna.ats.tsmx.TransactionServiceMX.failedtoregistermbean", new Object[] { mbeanObjectName, e.toString() });
/*     */             }
/* 248 */             success = false;
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 255 */     return success;
/*     */   }
/*     */ 
/*     */   public boolean unregisterMBeans()
/*     */   {
/* 267 */     boolean success = true;
/*     */ 
/* 269 */     for (int count = 0; count < this._beans.size(); count++)
/*     */     {
/* 271 */       String name = (String)this._beans.get(count);
/*     */       try
/*     */       {
/* 274 */         this._mbeanServer.unregisterMBean(new ObjectName(name));
/*     */ 
/* 276 */         this._beans.remove(count);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 280 */         if (tsmxLogger.logger.isErrorEnabled())
/*     */         {
/* 282 */           tsmxLogger.loggerI18N.error("com.arjuna.ats.tsmx.TransactionServiceMX.failedtounregistermbean", new Object[] { name, e.toString() });
/*     */         }
/* 284 */         success = false;
/*     */       }
/*     */     }
/*     */ 
/* 288 */     return success;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.tsmx.TransactionServiceMX
 * JD-Core Version:    0.6.0
 */