/*     */ package com.arjuna.ats.jta.xa;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.AtomicAction;
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.state.InputObjectState;
/*     */ import com.arjuna.ats.arjuna.state.OutputObjectState;
/*     */ import com.arjuna.ats.arjuna.xa.XID;
/*     */ import com.arjuna.ats.internal.arjuna.utils.XATxConverter;
/*     */ import com.arjuna.ats.jta.logging.jtaLogger;
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.util.ResourceBundle;
/*     */ import javax.transaction.xa.Xid;
/*     */ 
/*     */ public class XidImple
/*     */   implements Xid, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = -8922505475867377266L;
/*     */   private XID _theXid;
/*     */   private int hashCode;
/*     */ 
/*     */   public XidImple()
/*     */   {
/*  63 */     this._theXid = null;
/*  64 */     this.hashCode = getHash(this._theXid);
/*     */   }
/*     */ 
/*     */   public XidImple(Xid xid)
/*     */   {
/*  69 */     this._theXid = null;
/*     */ 
/*  71 */     copy(xid);
/*  72 */     this.hashCode = getHash(this._theXid);
/*     */   }
/*     */ 
/*     */   public XidImple(AtomicAction c)
/*     */   {
/*  77 */     this(c.get_uid(), false);
/*     */   }
/*     */ 
/*     */   public XidImple(AtomicAction c, boolean branch)
/*     */   {
/*  82 */     this(c.get_uid(), branch);
/*     */   }
/*     */ 
/*     */   public XidImple(Uid id)
/*     */   {
/*  87 */     this(id, false);
/*     */   }
/*     */ 
/*     */   public XidImple(Uid id, boolean branch)
/*     */   {
/*     */     try
/*     */     {
/*  94 */       this._theXid = XATxConverter.getXid(id, branch);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  98 */       this._theXid = null;
/*     */     }
/*     */ 
/* 102 */     this.hashCode = getHash(this._theXid);
/*     */   }
/*     */ 
/*     */   public XidImple(Uid id, Uid branch, int formatId)
/*     */   {
/*     */     try
/*     */     {
/* 109 */       this._theXid = XATxConverter.getXid(id, branch, formatId);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 113 */       this._theXid = null;
/*     */     }
/*     */ 
/* 117 */     this.hashCode = getHash(this._theXid);
/*     */   }
/*     */ 
/*     */   public XidImple(XID x)
/*     */   {
/* 122 */     this._theXid = x;
/* 123 */     this.hashCode = getHash(this._theXid);
/*     */   }
/*     */ 
/*     */   public final boolean isSameTransaction(Xid xid)
/*     */   {
/* 128 */     if (xid == null) {
/* 129 */       return false;
/*     */     }
/* 131 */     if ((xid instanceof XidImple))
/*     */     {
/* 133 */       return this._theXid.isSameTransaction(((XidImple)xid)._theXid);
/*     */     }
/*     */ 
/* 136 */     if (getFormatId() == xid.getFormatId())
/*     */     {
/* 138 */       byte[] gtx = xid.getGlobalTransactionId();
/*     */ 
/* 140 */       if (this._theXid.gtrid_length == gtx.length)
/*     */       {
/* 142 */         if (equals(xid)) {
/* 143 */           return true;
/*     */         }
/*     */ 
/* 146 */         for (int i = 0; i < this._theXid.gtrid_length; i++)
/*     */         {
/* 148 */           if (this._theXid.data[i] != gtx[i]) {
/* 149 */             return false;
/*     */           }
/*     */         }
/* 152 */         return true;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 157 */     return false;
/*     */   }
/*     */ 
/*     */   public int getFormatId()
/*     */   {
/* 162 */     if (this._theXid != null)
/*     */     {
/* 164 */       return this._theXid.formatID;
/*     */     }
/*     */ 
/* 167 */     return -1;
/*     */   }
/*     */ 
/*     */   public byte[] getGlobalTransactionId()
/*     */   {
/* 177 */     if (this._theXid != null)
/*     */     {
/* 179 */       byte[] b = new byte[this._theXid.gtrid_length];
/*     */ 
/* 181 */       System.arraycopy(this._theXid.data, 0, b, 0, b.length);
/*     */ 
/* 183 */       return b;
/*     */     }
/*     */ 
/* 186 */     return null;
/*     */   }
/*     */ 
/*     */   public byte[] getBranchQualifier()
/*     */   {
/* 191 */     if (this._theXid != null)
/*     */     {
/* 193 */       byte[] b = new byte[this._theXid.bqual_length];
/*     */ 
/* 195 */       System.arraycopy(this._theXid.data, this._theXid.gtrid_length, b, 0, b.length);
/*     */ 
/* 197 */       return b;
/*     */     }
/*     */ 
/* 200 */     return null;
/*     */   }
/*     */ 
/*     */   public final XID getXID()
/*     */   {
/* 205 */     return this._theXid;
/*     */   }
/*     */ 
/*     */   public final void copy(Xid xid)
/*     */   {
/* 210 */     this._theXid = new XID();
/*     */ 
/* 212 */     if (xid != null)
/*     */     {
/* 214 */       if ((xid instanceof XidImple)) {
/* 215 */         this._theXid.copy(((XidImple)xid)._theXid);
/*     */       }
/*     */       else {
/* 218 */         this._theXid.formatID = xid.getFormatId();
/*     */ 
/* 220 */         byte[] gtx = xid.getGlobalTransactionId();
/* 221 */         byte[] bql = xid.getBranchQualifier();
/* 222 */         int bqlength = bql == null ? 0 : bql.length;
/*     */ 
/* 224 */         this._theXid.gtrid_length = gtx.length;
/* 225 */         this._theXid.bqual_length = bqlength;
/*     */ 
/* 227 */         System.arraycopy(gtx, 0, this._theXid.data, 0, gtx.length);
/* 228 */         if (bqlength > 0)
/*     */         {
/* 230 */           System.arraycopy(bql, 0, this._theXid.data, gtx.length, bql.length);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean equals(Xid xid)
/*     */   {
/* 238 */     if (xid == null) {
/* 239 */       return false;
/*     */     }
/* 241 */     if (xid == this) {
/* 242 */       return true;
/*     */     }
/*     */ 
/* 245 */     if ((xid instanceof XidImple)) {
/* 246 */       return ((XidImple)xid)._theXid.equals(this._theXid);
/*     */     }
/*     */ 
/* 249 */     if (xid.getFormatId() == this._theXid.formatID)
/*     */     {
/* 251 */       byte[] gtx = xid.getGlobalTransactionId();
/* 252 */       byte[] bql = xid.getBranchQualifier();
/* 253 */       int bqlength = bql == null ? 0 : bql.length;
/*     */ 
/* 255 */       if ((this._theXid.gtrid_length == gtx.length) && (this._theXid.bqual_length == bqlength))
/*     */       {
/* 260 */         for (int i = 0; i < this._theXid.gtrid_length; i++)
/*     */         {
/* 262 */           if (this._theXid.data[i] != gtx[i]) {
/* 263 */             return false;
/*     */           }
/*     */         }
/* 266 */         i = this._theXid.gtrid_length;
/* 267 */         for (; i < this._theXid.gtrid_length + this._theXid.bqual_length; i++)
/*     */         {
/* 269 */           if (this._theXid.data[i] != bql[i]) {
/* 270 */             return false;
/*     */           }
/*     */         }
/* 273 */         return true;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 279 */     return false;
/*     */   }
/*     */ 
/*     */   public final boolean packInto(OutputObjectState os)
/*     */   {
/* 284 */     boolean result = false;
/*     */     try
/*     */     {
/* 288 */       os.packInt(this._theXid.formatID);
/* 289 */       os.packInt(this._theXid.gtrid_length);
/* 290 */       os.packInt(this._theXid.bqual_length);
/* 291 */       os.packBytes(this._theXid.data);
/*     */ 
/* 293 */       result = true;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 297 */       e.printStackTrace();
/*     */ 
/* 299 */       result = false;
/*     */     }
/*     */ 
/* 302 */     return result;
/*     */   }
/*     */ 
/*     */   public final boolean unpackFrom(InputObjectState os)
/*     */   {
/* 307 */     boolean result = false;
/*     */     try
/*     */     {
/* 311 */       if (this._theXid == null) {
/* 312 */         this._theXid = new XID();
/*     */       }
/* 314 */       this._theXid.formatID = os.unpackInt();
/* 315 */       this._theXid.gtrid_length = os.unpackInt();
/* 316 */       this._theXid.bqual_length = os.unpackInt();
/* 317 */       this._theXid.data = os.unpackBytes();
/*     */ 
/* 319 */       this.hashCode = getHash(this._theXid);
/*     */ 
/* 321 */       result = true;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 325 */       result = false;
/*     */     }
/*     */ 
/* 328 */     return result;
/*     */   }
/*     */ 
/*     */   public static final void pack(OutputObjectState os, Xid xid)
/*     */     throws IOException
/*     */   {
/* 338 */     if ((xid instanceof XidImple))
/*     */     {
/* 340 */       XidImple x = (XidImple)xid;
/*     */ 
/* 342 */       os.packBoolean(true);
/*     */ 
/* 344 */       if (!x.packInto(os)) {
/* 345 */         throw new IOException(jtaLogger.logMesg.getString("com.arjuna.ats.jta.xid.packerror"));
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 350 */       os.packBoolean(false);
/*     */ 
/* 352 */       ByteArrayOutputStream s = new ByteArrayOutputStream();
/* 353 */       ObjectOutputStream o = new ObjectOutputStream(s);
/*     */ 
/* 355 */       o.writeObject(xid);
/* 356 */       o.close();
/*     */ 
/* 358 */       os.packBytes(s.toByteArray());
/*     */     }
/*     */   }
/*     */ 
/*     */   public static final Xid unpack(InputObjectState os) throws IOException
/*     */   {
/* 364 */     if (os.unpackBoolean())
/*     */     {
/* 366 */       XidImple x = new XidImple();
/*     */ 
/* 368 */       x.unpackFrom(os);
/*     */ 
/* 370 */       return x;
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 376 */       byte[] b = os.unpackBytes();
/*     */ 
/* 378 */       ByteArrayInputStream s = new ByteArrayInputStream(b);
/* 379 */       ObjectInputStream o = new ObjectInputStream(s);
/*     */ 
/* 381 */       Xid x = (Serializable)o.readObject();
/*     */ 
/* 383 */       return x;
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 387 */     throw new IOException(e.toString());
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 398 */     if (this._theXid != null) {
/* 399 */       return this._theXid.toString();
/*     */     }
/* 401 */     return jtaLogger.logMesg.getString("com.arjuna.ats.jta.xa.xidunset");
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 411 */     if ((obj instanceof Serializable))
/*     */     {
/* 413 */       return equals((Serializable)obj);
/*     */     }
/* 415 */     return false;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 424 */     return this.hashCode;
/*     */   }
/*     */ 
/*     */   private static int getHash(XID xid)
/*     */   {
/* 434 */     if (xid == null)
/*     */     {
/* 436 */       return 0;
/*     */     }
/* 438 */     int hash = generateHash(xid.formatID, xid.data, 0, xid.gtrid_length);
/* 439 */     return generateHash(hash, xid.data, xid.gtrid_length, xid.bqual_length);
/*     */   }
/*     */ 
/*     */   private static int generateHash(int hash, byte[] bytes, int start, int length)
/*     */   {
/* 450 */     for (int count = start; count < length; count++)
/*     */     {
/* 452 */       hash = 31 * hash + bytes[count];
/*     */     }
/* 454 */     return hash;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.jta.xa.XidImple
 * JD-Core Version:    0.6.0
 */