/*     */ package com.arjuna.ats.jta;
/*     */ 
/*     */ import com.arjuna.ats.jta.logging.jtaLogger;
/*     */ import com.arjuna.ats.jta.utils.JNDIManager;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import javax.naming.InitialContext;
/*     */ 
/*     */ public class TransactionManager
/*     */ {
/* 111 */   private static javax.transaction.TransactionManager _transactionManager = null;
/*     */ 
/*     */   public static javax.transaction.TransactionManager transactionManager(InitialContext ctx)
/*     */   {
/*  52 */     javax.transaction.TransactionManager transactionManager = null;
/*     */     try
/*     */     {
/*  56 */       transactionManager = (javax.transaction.TransactionManager)ctx.lookup(JNDIManager.getTransactionManagerJNDIName());
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  60 */       if (jtaLogger.loggerI18N.isWarnEnabled())
/*     */       {
/*  62 */         jtaLogger.loggerI18N.warn("com.arjuna.ats.jta.TransactionManager.jndifailure", e);
/*     */       }
/*     */     }
/*     */ 
/*  66 */     return transactionManager;
/*     */   }
/*     */ 
/*     */   public static synchronized javax.transaction.TransactionManager transactionManager()
/*     */   {
/*  76 */     return transactionManager(false);
/*     */   }
/*     */ 
/*     */   public static synchronized javax.transaction.TransactionManager transactionManager(boolean reset)
/*     */   {
/*  89 */     if ((_transactionManager == null) || (reset))
/*     */     {
/*     */       try
/*     */       {
/*  93 */         _transactionManager = (javax.transaction.TransactionManager)Thread.currentThread().getContextClassLoader().loadClass(JNDIManager.getTransactionManagerImplementationClassname()).newInstance();
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/*  97 */         if (jtaLogger.loggerI18N.isErrorEnabled())
/*     */         {
/*  99 */           jtaLogger.loggerI18N.error("com.arjuna.ats.jta.TransactionManager.generalfailure", e);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 104 */     return _transactionManager;
/*     */   }
/*     */ 
/*     */   public static final void initialise(String[] args)
/*     */   {
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.jta.TransactionManager
 * JD-Core Version:    0.6.0
 */