/*     */ package com.arjuna.ats.jbossatx.jta;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.common.arjPropertyManager;
/*     */ import com.arjuna.ats.arjuna.coordinator.TransactionReaper;
/*     */ import com.arjuna.ats.arjuna.coordinator.TxControl;
/*     */ import com.arjuna.ats.arjuna.coordinator.TxStats;
/*     */ import com.arjuna.ats.arjuna.recovery.RecoveryManager;
/*     */ import com.arjuna.ats.internal.jbossatx.agent.LocalJBossAgentImpl;
/*     */ import com.arjuna.ats.internal.jbossatx.jta.PropagationContextManager;
/*     */ import com.arjuna.ats.internal.jbossatx.jta.jca.XATerminator;
/*     */ import com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionSynchronizationRegistryImple;
/*     */ import com.arjuna.ats.internal.jta.transaction.arjunacore.UserTransactionImple;
/*     */ import com.arjuna.ats.internal.tsmx.mbeans.PropertyServiceJMXPlugin;
/*     */ import com.arjuna.ats.jta.common.jtaPropertyManager;
/*     */ import com.arjuna.ats.jta.utils.JNDIManager;
/*     */ import com.arjuna.common.util.propertyservice.PropertyManager;
/*     */ import com.arjuna.common.util.propertyservice.PropertyManagerFactory;
/*     */ import java.io.BufferedReader;
/*     */ import java.io.InputStreamReader;
/*     */ import java.io.PrintStream;
/*     */ import java.net.InetAddress;
/*     */ import java.net.Socket;
/*     */ import javax.management.InstanceNotFoundException;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.Notification;
/*     */ import javax.management.NotificationFilterSupport;
/*     */ import javax.management.NotificationListener;
/*     */ import javax.management.ObjectName;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.Reference;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.util.ObjectNameFactory;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ import org.jboss.tm.JBossXATerminator;
/*     */ import org.jboss.tm.LastResource;
/*     */ import org.jboss.tm.XAExceptionFormatter;
/*     */ 
/*     */ public class TransactionManagerService extends ServiceMBeanSupport
/*     */   implements TransactionManagerServiceMBean, NotificationListener
/*     */ {
/*     */   public static final String PROPAGATE_FULL_CONTEXT_PROPERTY = "com.arjuna.ats.jbossatx.jta.propagatefullcontext";
/*     */   private static final String SERVICE_NAME = "TransactionManagerService";
/*     */   private static final String PROPAGATION_CONTEXT_IMPORTER_JNDI_REFERENCE = "java:/TransactionPropagationContextImporter";
/*     */   private static final String PROPAGATION_CONTEXT_EXPORTER_JNDI_REFERENCE = "java:/TransactionPropagationContextExporter";
/*     */   private static final JBossXATerminator TERMINATOR;
/*     */   private RecoveryManager _recoveryManager;
/*  99 */   private boolean _runRM = true;
/*     */   private int timeout;
/*     */   private boolean started;
/* 102 */   private byte[] startedLock = new byte[0];
/*     */ 
/*     */   public String getName()
/*     */   {
/* 109 */     return "TransactionManagerService";
/*     */   }
/*     */ 
/*     */   protected void startService()
/*     */     throws Exception
/*     */   {
/* 122 */     synchronized (this.startedLock)
/*     */     {
/* 124 */       this.started = true;
/*     */     }
/*     */ 
/* 127 */     getLog().info("JBossTS Transaction Service (JTA version) - JBoss Inc.");
/*     */ 
/* 129 */     getLog().info("Setting up property manager MBean and JMX layer");
/*     */ 
/* 132 */     LocalJBossAgentImpl.setLocalAgent(getServer());
/* 133 */     System.setProperty("com.arjuna.ats.tsmx.agentimpl", LocalJBossAgentImpl.class.getName());
/*     */ 
/* 135 */     System.setProperty("com.arjuna.ats.jta.lastResourceOptimisationInterface", LastResource.class.getName());
/*     */ 
/* 137 */     if (this.timeout != 0)
/*     */     {
/* 139 */       TxControl.setDefaultTimeout(this.timeout);
/*     */     }
/*     */ 
/* 143 */     arjPropertyManager.propertyManager.addManagementPlugin(new PropertyServiceJMXPlugin());
/*     */ 
/* 146 */     TransactionReaper.create();
/*     */     try
/*     */     {
/* 152 */       bindRef("java:/TransactionPropagationContextImporter", PropagationContextManager.class.getName());
/* 153 */       bindRef("java:/TransactionPropagationContextExporter", PropagationContextManager.class.getName());
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 157 */       getLog().fatal("Failed to create and register Propagation Context Manager", e);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 163 */       if (this._runRM)
/*     */       {
/* 165 */         registerNotification();
/*     */ 
/* 167 */         getLog().info("Starting recovery manager");
/*     */ 
/* 169 */         RecoveryManager.delayRecoveryManagerThread();
/* 170 */         this._recoveryManager = RecoveryManager.manager();
/*     */ 
/* 172 */         getLog().info("Recovery manager started");
/*     */       }
/* 176 */       else if (isRecoveryManagerRunning())
/*     */       {
/* 178 */         getLog().info("Using external recovery manager");
/*     */       }
/*     */       else
/*     */       {
/* 182 */         getLog().fatal("Recovery manager not found - please refer to the JBossTS documentation for details");
/*     */ 
/* 184 */         throw new Exception("Recovery manager not found - please refer to the JBossTS documentation for details");
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 190 */       getLog().fatal("Failed to start recovery manager", e);
/* 191 */       throw e;
/*     */     }
/*     */ 
/* 195 */     getLog().info("Binding TransactionManager JNDI Reference");
/*     */ 
/* 197 */     jtaPropertyManager.propertyManager.setProperty("com.arjuna.ats.jta.jtaTMImplementation", TransactionManagerDelegate.class.getName());
/* 198 */     jtaPropertyManager.propertyManager.setProperty("com.arjuna.ats.jta.jtaUTImplementation", UserTransactionImple.class.getName());
/*     */ 
/* 200 */     jtaPropertyManager.propertyManager.setProperty("com.arjuna.ats.jta.jtaTSRImplementation", TransactionSynchronizationRegistryImple.class.getName());
/*     */ 
/* 203 */     jtaPropertyManager.propertyManager.setProperty("com.arjuna.ats.jta.utils.TSRJNDIContext", "java:/TransactionSynchronizationRegistry");
/*     */ 
/* 205 */     JNDIManager.bindJTATransactionManagerImplementation();
/* 206 */     JNDIManager.bindJTATransactionSynchronizationRegistryImplementation();
/*     */   }
/*     */ 
/*     */   public void handleNotification(Notification notification, Object param)
/*     */   {
/* 216 */     this._recoveryManager.startRecoveryManagerThread();
/*     */   }
/*     */ 
/*     */   private boolean isRecoveryManagerRunning() throws Exception
/*     */   {
/* 221 */     boolean active = false;
/* 222 */     int port = 0;
/* 223 */     PropertyManager pm = PropertyManagerFactory.getPropertyManager("com.arjuna.ats.propertymanager", "recoverymanager");
/*     */ 
/* 225 */     if (pm != null)
/*     */     {
/* 227 */       String portStr = pm.getProperty("com.arjuna.ats.internal.arjuna.recovery.recoveryPort");
/*     */ 
/* 229 */       if (portStr != null)
/*     */       {
/*     */         try
/*     */         {
/* 233 */           port = Integer.parseInt(portStr);
/*     */         }
/*     */         catch (Exception ex)
/*     */         {
/* 237 */           port = -1;
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 242 */         throw new Exception("The transaction status manager port is not set - please refer to the JBossTS documentation");
/*     */       }
/*     */ 
/* 246 */       BufferedReader in = null;
/* 247 */       PrintStream out = null;
/*     */       try
/*     */       {
/* 251 */         getLog().info("Connecting to recovery manager on port " + port);
/*     */ 
/* 253 */         Socket sckt = new Socket(InetAddress.getLocalHost(), port);
/*     */ 
/* 255 */         in = new BufferedReader(new InputStreamReader(sckt.getInputStream()));
/* 256 */         out = new PrintStream(sckt.getOutputStream());
/*     */ 
/* 259 */         out.println("PING");
/*     */ 
/* 262 */         String inMessage = in.readLine();
/*     */ 
/* 264 */         active = inMessage != null ? inMessage.equals("PONG") : false;
/*     */       }
/*     */       catch (Exception ex)
/*     */       {
/* 268 */         getLog().error("Failed to connect to recovery manager", ex);
/* 269 */         active = false;
/*     */       }
/*     */       finally
/*     */       {
/* 273 */         if (in != null)
/*     */         {
/* 275 */           in.close();
/*     */         }
/*     */ 
/* 278 */         if (out != null)
/*     */         {
/* 280 */           out.close();
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 285 */     return active;
/*     */   }
/*     */ 
/*     */   protected void destroyService()
/*     */     throws Exception
/*     */   {
/* 298 */     if (this._runRM)
/*     */     {
/* 300 */       getLog().info("Stopping recovery manager");
/*     */ 
/* 302 */       this._recoveryManager.stop();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setTransactionTimeout(int timeout)
/*     */     throws IllegalStateException
/*     */   {
/* 316 */     synchronized (this.startedLock)
/*     */     {
/* 318 */       if (this.started)
/*     */       {
/* 320 */         if (this.timeout != timeout)
/*     */         {
/* 322 */           throw new IllegalStateException("Cannot set transaction timeout once MBean has started");
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 327 */         this.timeout = timeout;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public int getTransactionTimeout()
/*     */   {
/* 340 */     synchronized (this.startedLock)
/*     */     {
/* 342 */       return this.started ? this.timeout : TxControl.getDefaultTimeout();
/*     */     }
/*     */   }
/*     */ 
/*     */   public javax.transaction.TransactionManager getTransactionManager()
/*     */   {
/* 353 */     return com.arjuna.ats.jta.TransactionManager.transactionManager();
/*     */   }
/*     */ 
/*     */   public JBossXATerminator getXATerminator()
/*     */   {
/* 363 */     return TERMINATOR;
/*     */   }
/*     */ 
/*     */   public javax.transaction.UserTransaction getUserTransaction()
/*     */   {
/* 373 */     return com.arjuna.ats.jta.UserTransaction.userTransaction();
/*     */   }
/*     */ 
/*     */   public void setPropagateFullContext(boolean propagateFullContext)
/*     */   {
/*     */   }
/*     */ 
/*     */   public boolean getPropagateFullContext()
/*     */   {
/* 392 */     return false;
/*     */   }
/*     */ 
/*     */   public void setStatisticsEnabled(boolean enabled)
/*     */   {
/* 402 */     System.setProperty("com.arjuna.ats.arjuna.coordinator.enableStatistics", enabled ? "YES" : "NO");
/*     */   }
/*     */ 
/*     */   public boolean getStatisticsEnabled()
/*     */   {
/* 411 */     boolean enabled = System.getProperty("com.arjuna.ats.arjuna.coordinator.enableStatistics", "NO").equals("YES");
/*     */ 
/* 413 */     return enabled;
/*     */   }
/*     */ 
/*     */   public void registerXAExceptionFormatter(Class c, XAExceptionFormatter f)
/*     */   {
/* 422 */     getLog().warn("XAExceptionFormatters are not supported by the JBossTS Transaction Service - this warning can safely be ignored");
/*     */   }
/*     */ 
/*     */   public void unregisterXAExceptionFormatter(Class c)
/*     */   {
/*     */   }
/*     */ 
/*     */   public long getTransactionCount()
/*     */   {
/* 440 */     return TxStats.numberOfTransactions();
/*     */   }
/*     */ 
/*     */   public long getCommitCount()
/*     */   {
/* 449 */     return TxStats.numberOfCommittedTransactions();
/*     */   }
/*     */ 
/*     */   public long getRollbackCount()
/*     */   {
/* 458 */     return TxStats.numberOfAbortedTransactions();
/*     */   }
/*     */ 
/*     */   public void setRunInVMRecoveryManager(boolean runRM)
/*     */     throws IllegalStateException
/*     */   {
/* 472 */     synchronized (this.startedLock)
/*     */     {
/* 474 */       if (this.started)
/*     */       {
/* 476 */         if (this._runRM != runRM)
/*     */         {
/* 478 */           throw new IllegalStateException("Cannot set run in VM recovery manager once MBean has started");
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 483 */         this._runRM = runRM;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean getRunInVMRecoveryManager()
/*     */   {
/* 497 */     synchronized (this.startedLock)
/*     */     {
/* 499 */       return this._runRM;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setObjectStoreDir(String objectStoreDir)
/*     */     throws IllegalStateException
/*     */   {
/* 512 */     synchronized (this.startedLock)
/*     */     {
/* 514 */       if (this.started)
/*     */       {
/* 516 */         String currentDir = getObjectStoreDir();
/* 517 */         boolean equal = currentDir == null ? false : objectStoreDir == null ? true : currentDir.equals(objectStoreDir);
/* 518 */         if (!equal)
/*     */         {
/* 520 */           throw new IllegalStateException("Cannot set object store dir once MBean has started");
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 525 */         System.setProperty("com.arjuna.ats.arjuna.objectstore.objectStoreDir", objectStoreDir);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getObjectStoreDir()
/*     */   {
/* 536 */     return System.getProperty("com.arjuna.ats.arjuna.objectstore.objectStoreDir");
/*     */   }
/*     */ 
/*     */   private void registerNotification()
/*     */     throws InstanceNotFoundException
/*     */   {
/* 542 */     NotificationFilterSupport notificationFilter = new NotificationFilterSupport();
/* 543 */     notificationFilter.enableType("org.jboss.system.server.started");
/*     */ 
/* 545 */     ObjectName serverName = ObjectNameFactory.create("jboss.system:type=Server");
/*     */ 
/* 547 */     getServer().addNotificationListener(serverName, this, notificationFilter, null);
/*     */   }
/*     */ 
/*     */   private void bindRef(String jndiName, String className)
/*     */     throws Exception
/*     */   {
/* 553 */     Reference ref = new Reference(className, className, null);
/* 554 */     new InitialContext().bind(jndiName, ref);
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  87 */     arjPropertyManager.propertyManager.setProperty("com.arjuna.common.util.logger", "log4j_releveler");
/*     */ 
/*  96 */     TERMINATOR = new XATerminator();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.jbossatx.jta.TransactionManagerService
 * JD-Core Version:    0.6.0
 */