/*     */ package com.arjuna.ats.jbossatx.jta;
/*     */ 
/*     */ import com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionImple;
/*     */ import com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionManagerImple;
/*     */ import com.arjuna.ats.jbossatx.BaseTransactionManagerDelegate;
/*     */ import com.arjuna.ats.jbossatx.logging.jbossatxLogger;
/*     */ import java.util.HashMap;
/*     */ import java.util.Hashtable;
/*     */ import java.util.Map;
/*     */ import java.util.ResourceBundle;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.Name;
/*     */ import javax.naming.spi.ObjectFactory;
/*     */ import javax.transaction.RollbackException;
/*     */ import javax.transaction.SystemException;
/*     */ import javax.transaction.Transaction;
/*     */ import org.jboss.tm.TransactionLocal;
/*     */ 
/*     */ public class TransactionManagerDelegate extends BaseTransactionManagerDelegate
/*     */   implements ObjectFactory
/*     */ {
/*  47 */   private static final TransactionManagerImple TRANSACTION_MANAGER = new TransactionManagerImple();
/*     */ 
/* 223 */   private final String LOCKS_MAP = "__LOCKS_MAP";
/*     */ 
/*     */   public TransactionManagerDelegate()
/*     */   {
/*  54 */     super(getTransactionManager());
/*     */   }
/*     */ 
/*     */   public int getTransactionTimeout()
/*     */     throws SystemException
/*     */   {
/*  66 */     return getTransactionManager().getTimeout();
/*     */   }
/*     */ 
/*     */   public long getTimeLeftBeforeTransactionTimeout(boolean errorRollback)
/*     */     throws RollbackException
/*     */   {
/*     */     try
/*     */     {
/*  88 */       if (getStatus() == 1)
/*     */       {
/*  90 */         throw new RollbackException(jbossatxLogger.logMesg.getString("com.arjuna.ats.jbossatx.jta.TransactionManagerDelegate.getTimeLeftBeforeTransactionTimeout_1"));
/*     */       }
/*     */     }
/*     */     catch (SystemException se)
/*     */     {
/*  95 */       throw new RollbackException(jbossatxLogger.logMesg.getString("com.arjuna.ats.jbossatx.jta.TransactionManagerDelegate.getTimeLeftBeforeTransactionTimeout_2"));
/*     */     }
/*  97 */     return -1L;
/*     */   }
/*     */ 
/*     */   public Object getObjectInstance(Object initObj, Name relativeName, Context namingContext, Hashtable env)
/*     */     throws Exception
/*     */   {
/* 112 */     return this;
/*     */   }
/*     */ 
/*     */   private static TransactionManagerImple getTransactionManager()
/*     */   {
/* 121 */     return TRANSACTION_MANAGER;
/*     */   }
/*     */ 
/*     */   public boolean containsValue(TransactionLocal transactionLocal, Transaction transaction)
/*     */   {
/* 145 */     TransactionImple transactionImple = (TransactionImple)transaction;
/* 146 */     if (transactionImple.isAlive()) {
/* 147 */       return transactionImple.getTxLocalResource(transactionLocal) != null;
/*     */     }
/* 149 */     return false;
/*     */   }
/*     */ 
/*     */   public Object getValue(TransactionLocal transactionLocal, Transaction transaction)
/*     */   {
/* 161 */     TransactionImple transactionImple = (TransactionImple)transaction;
/* 162 */     if (transactionImple.isAlive()) {
/* 163 */       return transactionImple.getTxLocalResource(transactionLocal);
/*     */     }
/* 165 */     return null;
/*     */   }
/*     */ 
/*     */   public void storeValue(TransactionLocal transactionLocal, Transaction transaction, Object value)
/*     */   {
/* 178 */     TransactionImple transactionImple = (TransactionImple)transaction;
/* 179 */     if (transactionImple.isAlive())
/* 180 */       transactionImple.putTxLocalResource(transactionLocal, value);
/*     */     else
/* 182 */       throw new IllegalStateException("Can't store value in a TransactionLocal after the Transaction has ended");
/*     */   }
/*     */ 
/*     */   public void lock(TransactionLocal local, Transaction transaction)
/*     */     throws InterruptedException
/*     */   {
/* 194 */     TransactionImple transactionImple = (TransactionImple)transaction;
/* 195 */     if (transactionImple.isAlive())
/*     */     {
/* 199 */       TransactionLocalLock lock = findLock(local, transaction);
/* 200 */       if (lock.lock(transactionImple)) {
/* 201 */         return;
/*     */       }
/*     */     }
/*     */ 
/* 205 */     throw new IllegalStateException("Can't lock a TransactionLocal after the Transaction has ended");
/*     */   }
/*     */ 
/*     */   public void unlock(TransactionLocal local, Transaction transaction)
/*     */   {
/* 212 */     TransactionLocalLock lock = findLock(local, transaction);
/* 213 */     lock.unlock();
/*     */   }
/*     */ 
/*     */   private TransactionLocalLock findLock(TransactionLocal local, Transaction transaction)
/*     */   {
/* 229 */     TransactionImple transactionImple = (TransactionImple)transaction;
/*     */     Map locks;
/* 233 */     synchronized ("__LOCKS_MAP")
/*     */     {
/* 235 */       locks = (Map)transactionImple.getTxLocalResource("__LOCKS_MAP");
/* 236 */       if (locks == null) {
/* 237 */         locks = new HashMap();
/* 238 */         transactionImple.putTxLocalResource("__LOCKS_MAP", locks);
/*     */       }
/*     */     }
/*     */     TransactionLocalLock transactionLocalLock;
/* 243 */     synchronized (locks)
/*     */     {
/* 245 */       transactionLocalLock = (TransactionLocalLock)locks.get(local);
/* 246 */       if (transactionLocalLock == null) {
/* 247 */         transactionLocalLock = new TransactionLocalLock(null);
/* 248 */         locks.put(local, transactionLocalLock);
/*     */       }
/*     */     }
/*     */ 
/* 252 */     return (TransactionLocalLock)transactionLocalLock;
/*     */   }
/*     */ 
/*     */   private class TransactionLocalLock
/*     */   {
/*     */     private Thread lockingThread;
/*     */     private int lockCount;
/* 270 */     private byte[] lock = new byte[0];
/*     */ 
/*     */     private TransactionLocalLock()
/*     */     {
/*     */     }
/*     */ 
/*     */     public boolean lock(TransactionImple tx)
/*     */     {
/* 279 */       synchronized (this.lock)
/*     */       {
/* 281 */         Thread currentThread = Thread.currentThread();
/* 282 */         if (currentThread == this.lockingThread)
/*     */         {
/* 284 */           this.lockCount += 1;
/* 285 */           return true;
/*     */         }
/*     */ 
/* 288 */         while (this.lockingThread != null)
/*     */         {
/*     */           try
/*     */           {
/* 298 */             long timeout = 0L;
/*     */             try {
/* 300 */               timeout = TransactionManagerDelegate.this.getTransactionTimeout();
/*     */             } catch (SystemException e) {
/*     */             }
/* 303 */             this.lock.wait(timeout + 1000L);
/* 304 */             if (!tx.isAlive())
/*     */             {
/* 306 */               this.lockingThread = null;
/* 307 */               this.lockCount = 0;
/* 308 */               return false;
/*     */             }
/*     */           }
/*     */           catch (InterruptedException ie) {
/*     */           }
/*     */         }
/* 314 */         this.lockingThread = currentThread;
/* 315 */         this.lockCount += 1;
/* 316 */         return true;
/*     */       }
/*     */     }
/*     */ 
/*     */     public void unlock()
/*     */     {
/* 325 */       synchronized (this.lock)
/*     */       {
/* 327 */         if ((this.lockCount == 0) && (this.lockingThread == null))
/*     */         {
/* 330 */           return;
/*     */         }
/*     */ 
/* 333 */         Thread currentThread = Thread.currentThread();
/* 334 */         if (currentThread != this.lockingThread)
/*     */         {
/* 336 */           throw new IllegalStateException("Unlock called from wrong thread.  Locking thread: " + this.lockingThread + ", current thread: " + currentThread);
/*     */         }
/*     */ 
/* 340 */         if (--this.lockCount == 0)
/*     */         {
/* 342 */           this.lockingThread = null;
/* 343 */           this.lock.notify();
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.jbossatx.jta.TransactionManagerDelegate
 * JD-Core Version:    0.6.0
 */