/*     */ package com.arjuna.ats.internal.txoj.recovery;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.StateManager;
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.coordinator.ActionStatus;
/*     */ import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
/*     */ import com.arjuna.ats.arjuna.objectstore.ObjectStore;
/*     */ import com.arjuna.ats.arjuna.recovery.TransactionStatusConnectionManager;
/*     */ import com.arjuna.ats.arjuna.state.InputObjectState;
/*     */ import com.arjuna.ats.txoj.logging.txojLogger;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ 
/*     */ public class RecoveredTransactionalObject extends StateManager
/*     */ {
/*     */   private Uid _ourUid;
/*     */   private Uid _owningTransactionUid;
/*     */   private Uid _originalProcessUid;
/*     */   private ObjectStore _objectStore;
/*     */   private String _type;
/*     */   private TransactionStatusConnectionManager _transactionStatusConnectionMgr;
/*     */ 
/*     */   RecoveredTransactionalObject(Uid objectUid, String originalType, ObjectStore objectStore)
/*     */   {
/*  94 */     this._ourUid = objectUid;
/*  95 */     this._type = originalType;
/*  96 */     this._objectStore = objectStore;
/*  97 */     this._transactionStatusConnectionMgr = new TransactionStatusConnectionManager();
/*     */ 
/*  99 */     if (txojLogger.aitLoggerI18N.isDebugEnabled())
/*     */     {
/* 101 */       txojLogger.aitLoggerI18N.debug(1L, 8L, 2048L, "com.arjuna.ats.internal.txoj.recovery.RecoveredTransactionalObject_1", new Object[] { this._ourUid });
/*     */     }
/*     */   }
/*     */ 
/*     */   final void replayPhase2()
/*     */   {
/* 110 */     if (findHoldingTransaction())
/*     */     {
/* 120 */       if (txojLogger.aitLoggerI18N.isDebugEnabled())
/*     */       {
/* 122 */         txojLogger.aitLoggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.internal.txoj.recovery.RecoveredTransactionalObject_2", new Object[] { this._owningTransactionUid });
/*     */       }
/*     */ 
/* 128 */       int tranStatus = this._transactionStatusConnectionMgr.getTransactionStatus(this._owningTransactionUid);
/*     */ 
/* 130 */       if (txojLogger.aitLoggerI18N.isDebugEnabled())
/*     */       {
/* 132 */         txojLogger.aitLoggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.internal.txoj.recovery.RecoveredTransactionalObject_3", new Object[] { ActionStatus.stringForm(tranStatus) });
/*     */       }
/*     */ 
/* 138 */       boolean inactive = false;
/*     */ 
/* 140 */       if (tranStatus == 9)
/*     */       {
/* 142 */         if (txojLogger.aitLoggerI18N.isDebugEnabled())
/*     */         {
/* 144 */           if (inactive) {
/* 145 */             txojLogger.aitLoggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.internal.txoj.recovery.RecoveredTransactionalObject_4", new Object[] { Integer.toString(tranStatus), "true" });
/*     */           }
/*     */           else
/*     */           {
/* 149 */             txojLogger.aitLoggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.internal.txoj.recovery.RecoveredTransactionalObject_4", new Object[] { Integer.toString(tranStatus), "false" });
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/* 154 */         inactive = true;
/*     */       }
/*     */ 
/* 164 */       if ((tranStatus == 4) || (inactive))
/*     */       {
/* 166 */         rollback();
/*     */       }
/*     */ 
/*     */     }
/* 171 */     else if (txojLogger.aitLoggerI18N.isDebugEnabled())
/*     */     {
/* 173 */       txojLogger.aitLoggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.internal.txoj.recovery.RecoveredTransactionalObject_5");
/*     */     }
/*     */   }
/*     */ 
/*     */   private final boolean findHoldingTransaction()
/*     */   {
/* 187 */     InputObjectState uncommittedState = null;
/*     */ 
/* 189 */     this._originalProcessUid = new Uid(Uid.nullUid());
/*     */     try
/*     */     {
/* 193 */       uncommittedState = this._objectStore.read_uncommitted(this._ourUid, this._type);
/*     */     }
/*     */     catch (ObjectStoreException e)
/*     */     {
/* 197 */       if (txojLogger.aitLoggerI18N.isDebugEnabled())
/*     */       {
/* 199 */         txojLogger.aitLoggerI18N.debug(16L, 8L, 2048L, "com.arjuna.ats.internal.txoj.recovery.RecoveredTransactionalObject_6", new Object[] { e });
/*     */       }
/*     */ 
/* 205 */       return false;
/*     */     }
/*     */ 
/* 213 */     this._originalProcessUid = new Uid(Uid.nullUid());
/* 214 */     this._owningTransactionUid = new Uid(Uid.nullUid());
/*     */     try
/*     */     {
/* 219 */       unpackHeader(uncommittedState, this._owningTransactionUid, this._originalProcessUid);
/*     */ 
/* 221 */       if (txojLogger.aitLoggerI18N.isDebugEnabled())
/*     */       {
/* 223 */         txojLogger.aitLoggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.internal.txoj.recovery.RecoveredTransactionalObject_7", new Object[] { this._owningTransactionUid });
/*     */       }
/*     */ 
/* 229 */       return this._owningTransactionUid.notEquals(Uid.nullUid());
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 233 */       if (txojLogger.aitLoggerI18N.isDebugEnabled()) {
/* 234 */         txojLogger.aitLoggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.internal.txoj.recovery.RecoveredTransactionalObject_8", new Object[] { e });
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 241 */     return false;
/*     */   }
/*     */ 
/*     */   private final void rollback()
/*     */   {
/*     */     try
/*     */     {
/* 248 */       this._objectStore.remove_uncommitted(this._ourUid, this._type);
/*     */     }
/*     */     catch (ObjectStoreException e)
/*     */     {
/* 252 */       if (txojLogger.aitLoggerI18N.isWarnEnabled())
/* 253 */         txojLogger.aitLoggerI18N.warn("com.arjuna.ats.internal.txoj.recovery.RecoveredTransactionalObject_9", new Object[] { this._ourUid, e });
/*     */     }
/*     */   }
/*     */ 
/*     */   private final void commit()
/*     */   {
/*     */     try
/*     */     {
/* 263 */       this._objectStore.commit_state(this._ourUid, this._type);
/*     */     }
/*     */     catch (ObjectStoreException e)
/*     */     {
/* 267 */       if (txojLogger.aitLoggerI18N.isWarnEnabled())
/* 268 */         txojLogger.aitLoggerI18N.warn("com.arjuna.ats.internal.txoj.recovery.RecoveredTransactionalObject_10", new Object[] { this._ourUid, e });
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.txoj.recovery.RecoveredTransactionalObject
 * JD-Core Version:    0.6.0
 */