/*     */ package com.arjuna.ats.internal.txoj.lockstore;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.state.InputObjectState;
/*     */ import com.arjuna.ats.arjuna.state.OutputObjectState;
/*     */ import com.arjuna.ats.txoj.exceptions.LockStoreException;
/*     */ 
/*     */ class LockStoreList
/*     */ {
/*     */   private LockStoreList _next;
/*     */   private String _name;
/*     */   private LockStateStore headOfList;
/*     */ 
/*     */   public LockStoreList(String tName)
/*     */   {
/* 255 */     this._name = tName;
/* 256 */     this._next = null;
/*     */   }
/*     */ 
/*     */   public String name()
/*     */   {
/* 261 */     return this._name;
/*     */   }
/*     */ 
/*     */   public void setNext(LockStoreList n)
/*     */   {
/* 266 */     this._next = n;
/*     */   }
/*     */ 
/*     */   public LockStoreList getNext()
/*     */   {
/* 271 */     return this._next;
/*     */   }
/*     */ 
/*     */   public boolean add(Uid u, OutputObjectState state)
/*     */   {
/* 276 */     LockStateStore ptr = find(u);
/*     */ 
/* 278 */     if (ptr == null)
/*     */     {
/* 280 */       ptr = new LockStateStore(u, state);
/* 281 */       ptr._next = this.headOfList;
/* 282 */       this.headOfList = ptr;
/*     */     }
/*     */     else {
/* 285 */       ptr._state = state;
/*     */     }
/* 287 */     return true;
/*     */   }
/*     */ 
/*     */   public InputObjectState get(Uid u) throws LockStoreException
/*     */   {
/* 292 */     LockStateStore ptr = find(u);
/*     */ 
/* 294 */     if (ptr == null) {
/* 295 */       return null;
/*     */     }
/* 297 */     return new InputObjectState(ptr._state);
/*     */   }
/*     */ 
/*     */   public boolean remove(Uid u)
/*     */   {
/* 302 */     boolean found = false;
/* 303 */     LockStateStore ptr = this.headOfList;
/* 304 */     LockStateStore trail = null;
/*     */ 
/* 306 */     while ((!found) && (ptr != null))
/*     */     {
/* 308 */       if (ptr._id.equals(u)) {
/* 309 */         found = true; continue;
/*     */       }
/*     */ 
/* 312 */       trail = ptr;
/* 313 */       ptr = ptr._next;
/*     */     }
/*     */ 
/* 317 */     if (!found) {
/* 318 */       return false;
/*     */     }
/*     */ 
/* 321 */     if (trail == null)
/* 322 */       this.headOfList = ptr._next;
/*     */     else {
/* 324 */       trail._next = ptr._next;
/*     */     }
/*     */ 
/* 327 */     return true;
/*     */   }
/*     */ 
/*     */   private LockStateStore find(Uid u)
/*     */   {
/* 332 */     boolean found = false;
/* 333 */     LockStateStore ptr = this.headOfList;
/*     */ 
/* 335 */     while ((!found) && (ptr != null))
/*     */     {
/* 337 */       if (ptr._id.equals(u)) {
/* 338 */         found = true; continue;
/*     */       }
/* 340 */       ptr = ptr._next;
/*     */     }
/*     */ 
/* 343 */     return ptr;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.txoj.lockstore.LockStoreList
 * JD-Core Version:    0.6.0
 */