/*     */ package com.arjuna.ats.internal.txoj.lockstore;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.ArjunaNames;
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
/*     */ import com.arjuna.ats.arjuna.gandiva.ClassName;
/*     */ import com.arjuna.ats.arjuna.objectstore.ObjectStore;
/*     */ import com.arjuna.ats.arjuna.state.InputObjectState;
/*     */ import com.arjuna.ats.arjuna.state.OutputObjectState;
/*     */ import com.arjuna.ats.txoj.TxOJNames;
/*     */ import com.arjuna.ats.txoj.common.Configuration;
/*     */ import com.arjuna.ats.txoj.common.txojPropertyManager;
/*     */ import com.arjuna.ats.txoj.exceptions.LockStoreException;
/*     */ import com.arjuna.ats.txoj.lockstore.LockStoreImple;
/*     */ import com.arjuna.ats.txoj.logging.txojLogger;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import com.arjuna.common.util.propertyservice.PropertyManager;
/*     */ 
/*     */ public class BasicPersistentLockStore extends LockStoreImple
/*     */ {
/*     */   private String _key;
/*     */   private ObjectStore _lockStore;
/* 176 */   private static String lockStoreLocation = null;
/*     */ 
/*     */   public BasicPersistentLockStore(String key)
/*     */   {
/*  74 */     if (txojLogger.aitLogger.debugAllowed())
/*     */     {
/*  76 */       txojLogger.aitLogger.debug(1L, 4L, 65536L, "BasicPersistentLockStore.BasicPersistentLockStore(" + key + ")");
/*     */     }
/*     */ 
/*  80 */     if (lockStoreLocation == null) {
/*  81 */       lockStoreLocation = txojPropertyManager.propertyManager.getProperty("com.arjuna.ats.txoj.lockstore.lockStoreDir");
/*  82 */       if ((lockStoreLocation == null) || (lockStoreLocation.length() == 0))
/*  83 */         lockStoreLocation = Configuration.lockStoreRoot();
/*  84 */       Configuration.setLockStoreRoot(lockStoreLocation);
/*     */     }
/*     */ 
/*  87 */     this._key = lockStoreLocation;
/*     */ 
/*  95 */     this._lockStore = new ObjectStore(ArjunaNames.Implementation_ObjectStore_ShadowingStore(), this._key);
/*     */   }
/*     */ 
/*     */   public InputObjectState read_state(Uid u, String tName) throws LockStoreException
/*     */   {
/* 100 */     if (txojLogger.aitLogger.debugAllowed())
/*     */     {
/* 102 */       txojLogger.aitLogger.debug(16L, 4L, 65536L, "BasicPersistentLockStore.read_state(" + u + ", " + tName + ")");
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 108 */       return this._lockStore.read_committed(u, tName);
/*     */     }
/*     */     catch (ObjectStoreException e) {
/*     */     }
/* 112 */     throw new LockStoreException("Persistent store error.");
/*     */   }
/*     */ 
/*     */   public boolean remove_state(Uid u, String tName)
/*     */   {
/* 118 */     if (txojLogger.aitLogger.debugAllowed())
/*     */     {
/* 120 */       txojLogger.aitLogger.debug(16L, 4L, 65536L, "BasicPersistentLockStore.remove_state(" + u + ", " + tName + ")");
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 126 */       return this._lockStore.remove_committed(u, tName);
/*     */     }
/*     */     catch (ObjectStoreException e) {
/*     */     }
/* 130 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean write_committed(Uid u, String tName, OutputObjectState state)
/*     */   {
/* 136 */     if (txojLogger.aitLogger.debugAllowed())
/*     */     {
/* 138 */       txojLogger.aitLogger.debug(16L, 4L, 65536L, "BasicPersistentLockStore.write_committed(" + u + ", " + tName + ", " + state + ")");
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 145 */       return this._lockStore.write_committed(u, tName, state);
/*     */     }
/*     */     catch (ObjectStoreException e) {
/*     */     }
/* 149 */     return false;
/*     */   }
/*     */ 
/*     */   public ClassName className()
/*     */   {
/* 155 */     return TxOJNames.Implementation_LockStore_BasicPersistentLockStore();
/*     */   }
/*     */ 
/*     */   public static ClassName name()
/*     */   {
/* 160 */     return TxOJNames.Implementation_LockStore_BasicPersistentLockStore();
/*     */   }
/*     */ 
/*     */   public static final BasicPersistentLockStore create(Object[] param)
/*     */   {
/* 165 */     if (param == null) {
/* 166 */       return null;
/*     */     }
/* 168 */     String key = (String)param[0];
/*     */ 
/* 170 */     return new BasicPersistentLockStore(key);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.txoj.lockstore.BasicPersistentLockStore
 * JD-Core Version:    0.6.0
 */