/*     */ package com.arjuna.ats.internal.txoj.lockstore;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.gandiva.ClassName;
/*     */ import com.arjuna.ats.arjuna.state.InputObjectState;
/*     */ import com.arjuna.ats.arjuna.state.OutputObjectState;
/*     */ import com.arjuna.ats.txoj.TxOJNames;
/*     */ import com.arjuna.ats.txoj.exceptions.LockStoreException;
/*     */ import com.arjuna.ats.txoj.lockstore.LockStoreImple;
/*     */ import com.arjuna.ats.txoj.logging.txojLogger;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ 
/*     */ public class BasicLockStore extends LockStoreImple
/*     */ {
/* 128 */   private static LockStoreSegment segmentStore = new LockStoreSegment();
/*     */ 
/*     */   public BasicLockStore(String key)
/*     */   {
/*  67 */     if (txojLogger.aitLogger.isDebugEnabled())
/*     */     {
/*  69 */       txojLogger.aitLogger.debug(1L, 4L, 65536L, "BasicLockStore.BasicLockStore(" + key + ")");
/*     */     }
/*     */   }
/*     */ 
/*     */   public InputObjectState read_state(Uid u, String tName)
/*     */     throws LockStoreException
/*     */   {
/*  76 */     if (txojLogger.aitLogger.isDebugEnabled())
/*     */     {
/*  78 */       txojLogger.aitLogger.debug(16L, 4L, 65536L, "BasicLockStore.read_state(" + u + ", " + tName + ")");
/*     */     }
/*     */ 
/*  82 */     return segmentStore.read_state(u, tName);
/*     */   }
/*     */ 
/*     */   public boolean remove_state(Uid u, String tName)
/*     */   {
/*  87 */     if (txojLogger.aitLogger.isDebugEnabled())
/*     */     {
/*  89 */       txojLogger.aitLogger.debug(16L, 4L, 65536L, "BasicLockStore.remove_state(" + u + ", " + tName + ")");
/*     */     }
/*     */ 
/*  93 */     return segmentStore.remove_state(u, tName);
/*     */   }
/*     */ 
/*     */   public boolean write_committed(Uid u, String tName, OutputObjectState state)
/*     */   {
/*  98 */     if (txojLogger.aitLogger.isDebugEnabled())
/*     */     {
/* 100 */       txojLogger.aitLogger.debug(16L, 4L, 65536L, "BasicLockStore.write_committed(" + u + ", " + tName + ", " + state + ")");
/*     */     }
/*     */ 
/* 105 */     return segmentStore.write_committed(u, tName, state);
/*     */   }
/*     */ 
/*     */   public ClassName className()
/*     */   {
/* 110 */     return TxOJNames.Implementation_LockStore_BasicLockStore();
/*     */   }
/*     */ 
/*     */   public static ClassName name()
/*     */   {
/* 115 */     return TxOJNames.Implementation_LockStore_BasicLockStore();
/*     */   }
/*     */ 
/*     */   public static final BasicLockStore create(Object[] param)
/*     */   {
/* 120 */     if (param == null) {
/* 121 */       return null;
/*     */     }
/* 123 */     String key = (String)param[0];
/*     */ 
/* 125 */     return new BasicLockStore(key);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.txoj.lockstore.BasicLockStore
 * JD-Core Version:    0.6.0
 */