/*    */ package com.arjuna.ats.internal.jta.utils;
/*    */ 
/*    */ import javax.transaction.xa.XAResource;
/*    */ import javax.transaction.xa.Xid;
/*    */ 
/*    */ public class XAUtils
/*    */ {
/*    */   private static final String ORACLE = "oracle";
/*    */ 
/*    */   public static final boolean mustEndSuspendedRMs(XAResource res)
/*    */   {
/* 49 */     boolean end = false;
/*    */ 
/* 51 */     if (res != null)
/*    */     {
/* 53 */       String name = res.getClass().getName().toLowerCase();
/*    */ 
/* 55 */       if (name.indexOf("oracle") != -1) {
/* 56 */         end = true;
/*    */       }
/*    */     }
/* 59 */     return end;
/*    */   }
/*    */ 
/*    */   public static final boolean canOptimizeDelist(XAResource res)
/*    */   {
/* 64 */     boolean optimize = true;
/*    */ 
/* 66 */     if (res != null)
/*    */     {
/* 68 */       String name = res.getClass().getName().toLowerCase();
/*    */ 
/* 70 */       if (name.indexOf("oracle") != -1) {
/* 71 */         optimize = false;
/*    */       }
/*    */     }
/* 74 */     return optimize;
/*    */   }
/*    */ 
/*    */   public static final String getXANodeName(Xid xid)
/*    */   {
/* 79 */     byte[] gid = xid.getGlobalTransactionId();
/* 80 */     int nodeIndex = -1;
/*    */ 
/* 82 */     for (int i = 0; i < gid.length; i++)
/*    */     {
/* 84 */       if (gid[i] != 45)
/*    */         continue;
/* 86 */       nodeIndex = i;
/* 87 */       break;
/*    */     }
/*    */ 
/* 91 */     if (nodeIndex != -1) {
/* 92 */       return new String(gid, 0, nodeIndex);
/*    */     }
/* 94 */     return null;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.jta.utils.XAUtils
 * JD-Core Version:    0.6.0
 */