/*     */ package com.arjuna.ats.internal.jta.transaction.arjunacore.jca;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.coordinator.TxControl;
/*     */ import com.arjuna.ats.arjuna.objectstore.ObjectStore;
/*     */ import com.arjuna.ats.arjuna.state.InputObjectState;
/*     */ import com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.jca.SubordinateAtomicAction;
/*     */ import java.io.IOException;
/*     */ import java.util.Stack;
/*     */ import javax.resource.spi.XATerminator;
/*     */ import javax.transaction.HeuristicCommitException;
/*     */ import javax.transaction.HeuristicMixedException;
/*     */ import javax.transaction.HeuristicRollbackException;
/*     */ import javax.transaction.SystemException;
/*     */ import javax.transaction.xa.XAException;
/*     */ import javax.transaction.xa.Xid;
/*     */ 
/*     */ public class XATerminatorImple
/*     */   implements XATerminator
/*     */ {
/* 341 */   private boolean _recoveryStarted = false;
/*     */ 
/*     */   public void commit(Xid xid, boolean onePhase)
/*     */     throws XAException
/*     */   {
/*     */     try
/*     */     {
/*  79 */       com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.TransactionImple tx = TxImporter.getImportedTransaction(xid);
/*     */ 
/*  81 */       if (tx == null) {
/*  82 */         throw new XAException(-5);
/*     */       }
/*  84 */       if (onePhase)
/*  85 */         tx.doOnePhaseCommit();
/*     */       else {
/*  87 */         tx.doCommit();
/*     */       }
/*  89 */       TxImporter.removeImportedTransaction(xid);
/*     */     }
/*     */     catch (XAException ex)
/*     */     {
/*  93 */       TxImporter.removeImportedTransaction(xid);
/*     */ 
/*  95 */       throw ex;
/*     */     }
/*     */     catch (HeuristicRollbackException ex)
/*     */     {
/*  99 */       throw new XAException(6);
/*     */     }
/*     */     catch (HeuristicMixedException ex)
/*     */     {
/* 103 */       throw new XAException(5);
/*     */     }
/*     */     catch (SystemException ex)
/*     */     {
/* 107 */       TxImporter.removeImportedTransaction(xid);
/*     */ 
/* 109 */       throw new XAException(-3);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void forget(Xid xid)
/*     */     throws XAException
/*     */   {
/*     */     try
/*     */     {
/* 127 */       com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.TransactionImple tx = TxImporter.getImportedTransaction(xid);
/*     */ 
/* 129 */       if (tx == null) {
/* 130 */         throw new XAException(-5);
/*     */       }
/* 132 */       tx.doForget();
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 136 */       throw new XAException(-3);
/*     */     }
/*     */     finally
/*     */     {
/* 140 */       TxImporter.removeImportedTransaction(xid);
/*     */     }
/*     */   }
/*     */ 
/*     */   public int prepare(Xid xid)
/*     */     throws XAException
/*     */   {
/*     */     try
/*     */     {
/* 161 */       com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.TransactionImple tx = TxImporter.getImportedTransaction(xid);
/*     */ 
/* 163 */       if (tx == null) {
/* 164 */         throw new XAException(-5);
/*     */       }
/* 166 */       switch (tx.doPrepare())
/*     */       {
/*     */       case 2:
/* 169 */         TxImporter.removeImportedTransaction(xid);
/*     */ 
/* 171 */         return 3;
/*     */       case 1:
/* 173 */         TxImporter.removeImportedTransaction(xid);
/*     */ 
/* 175 */         throw new XAException(100);
/*     */       case 0:
/* 177 */         return 0;
/*     */       }
/* 179 */       throw new XAException(104);
/*     */     }
/*     */     catch (XAException ex)
/*     */     {
/*     */     }
/* 184 */     throw ex;
/*     */   }
/*     */ 
/*     */   public Xid[] recover(int flag)
/*     */     throws XAException
/*     */   {
/* 210 */     switch (flag)
/*     */     {
/*     */     case 16777216:
/* 213 */       if (this._recoveryStarted) {
/* 214 */         throw new XAException(-6);
/*     */       }
/* 216 */       this._recoveryStarted = true;
/* 217 */       break;
/*     */     case 8388608:
/* 219 */       if (this._recoveryStarted)
/* 220 */         this._recoveryStarted = false;
/*     */       else
/* 222 */         throw new XAException(-6);
/* 223 */       return null;
/*     */     case 0:
/* 225 */       if (this._recoveryStarted)
/*     */         break;
/*     */     default:
/* 228 */       throw new XAException(-6);
/*     */     }
/*     */ 
/* 233 */     Xid[] indoubt = null;
/*     */     try
/*     */     {
/* 237 */       ObjectStore objStore = new ObjectStore(TxControl.getActionStoreType());
/* 238 */       InputObjectState states = new InputObjectState();
/*     */ 
/* 242 */       if ((objStore.allObjUids(SubordinateAtomicAction.getType(), states)) && (states.notempty()))
/*     */       {
/* 244 */         Stack values = new Stack();
/* 245 */         boolean finished = false;
/*     */         do
/*     */         {
/* 249 */           Uid uid = new Uid(Uid.nullUid());
/*     */           try
/*     */           {
/* 253 */             uid.unpack(states);
/*     */           }
/*     */           catch (IOException ex)
/*     */           {
/* 257 */             ex.printStackTrace();
/*     */ 
/* 259 */             finished = true;
/*     */           }
/*     */ 
/* 262 */           if (uid.notEquals(Uid.nullUid()))
/*     */           {
/* 264 */             com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.TransactionImple tx = TxImporter.recoverTransaction(uid);
/*     */ 
/* 266 */             if (tx != null)
/* 267 */               values.push(tx);
/*     */           }
/*     */           else {
/* 270 */             finished = true;
/*     */           }
/*     */         }
/* 272 */         while (!finished);
/*     */ 
/* 274 */         if (values.size() > 0)
/*     */         {
/* 276 */           int index = 0;
/*     */ 
/* 278 */           indoubt = new Xid[values.size()];
/*     */ 
/* 280 */           while (!values.empty())
/*     */           {
/* 282 */             com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.jca.TransactionImple tx = (com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.jca.TransactionImple)values.pop();
/*     */ 
/* 284 */             indoubt[index] = tx.baseXid();
/* 285 */             index++;
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 292 */       ex.printStackTrace();
/*     */     }
/*     */ 
/* 295 */     return indoubt;
/*     */   }
/*     */ 
/*     */   public void rollback(Xid xid)
/*     */     throws XAException
/*     */   {
/*     */     try
/*     */     {
/* 310 */       com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.TransactionImple tx = TxImporter.getImportedTransaction(xid);
/*     */ 
/* 312 */       if (tx == null) {
/* 313 */         throw new XAException(-5);
/*     */       }
/* 315 */       tx.doRollback();
/*     */ 
/* 317 */       TxImporter.removeImportedTransaction(xid);
/*     */     }
/*     */     catch (XAException ex)
/*     */     {
/* 321 */       TxImporter.removeImportedTransaction(xid);
/*     */ 
/* 323 */       throw ex;
/*     */     }
/*     */     catch (HeuristicCommitException ex)
/*     */     {
/* 327 */       throw new XAException(7);
/*     */     }
/*     */     catch (HeuristicMixedException ex)
/*     */     {
/* 331 */       throw new XAException(5);
/*     */     }
/*     */     catch (SystemException ex)
/*     */     {
/* 335 */       TxImporter.removeImportedTransaction(xid);
/*     */ 
/* 337 */       throw new XAException(-3);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.jta.transaction.arjunacore.jca.XATerminatorImple
 * JD-Core Version:    0.6.0
 */