/*     */ package com.arjuna.ats.internal.jta.transaction.arjunacore.jca;
/*     */ 
/*     */ import com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.jca.TransactionImple;
/*     */ import com.arjuna.ats.jta.logging.jtaLogger;
/*     */ import java.util.HashMap;
/*     */ import java.util.ResourceBundle;
/*     */ import java.util.Stack;
/*     */ import javax.resource.spi.work.Work;
/*     */ import javax.resource.spi.work.WorkCompletedException;
/*     */ 
/*     */ public class TxWorkManager
/*     */ {
/* 178 */   private static HashMap _transactions = new HashMap();
/*     */ 
/*     */   public static void addWork(Work work, TransactionImple tx)
/*     */     throws WorkCompletedException
/*     */   {
/*     */     Stack workers;
/*  71 */     synchronized (_transactions)
/*     */     {
/*  73 */       workers = (Stack)_transactions.get(tx);
/*     */ 
/*  75 */       if (workers == null)
/*     */       {
/*  77 */         workers = new Stack();
/*     */ 
/*  79 */         _transactions.put(tx, workers);
/*     */       }
/*     */       else {
/*  82 */         throw new WorkCompletedException(jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.jca.busy"), "2");
/*     */       }
/*     */     }
/*  85 */     synchronized (workers)
/*     */     {
/*  87 */       workers.push(work);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void removeWork(Work work, TransactionImple tx)
/*     */   {
/*     */     Stack workers;
/* 102 */     synchronized (_transactions)
/*     */     {
/* 104 */       workers = (Stack)_transactions.get(tx);
/*     */     }
/*     */ 
/* 107 */     if (workers != null)
/*     */     {
/* 109 */       synchronized (workers)
/*     */       {
/* 113 */         workers.remove(work);
/*     */ 
/* 115 */         if (workers.empty())
/*     */         {
/* 117 */           synchronized (_transactions)
/*     */           {
/* 119 */             _transactions.remove(tx);
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static boolean hasWork(TransactionImple tx)
/*     */   {
/* 141 */     synchronized (_transactions)
/*     */     {
/* 143 */       Stack workers = (Stack)_transactions.get(tx);
/*     */ 
/* 145 */       return workers != null;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static Work getWork(TransactionImple tx)
/*     */   {
/*     */     Stack workers;
/* 161 */     synchronized (_transactions)
/*     */     {
/* 163 */       workers = (Stack)_transactions.get(tx);
/*     */     }
/*     */ 
/* 166 */     if (workers != null)
/*     */     {
/* 168 */       synchronized (workers)
/*     */       {
/* 170 */         if (!workers.empty()) {
/* 171 */           return (Work)workers.peek();
/*     */         }
/*     */       }
/*     */     }
/* 175 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.jta.transaction.arjunacore.jca.TxWorkManager
 * JD-Core Version:    0.6.0
 */