/*     */ package com.arjuna.ats.internal.jta.transaction.arjunacore.jca;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.jca.TransactionImple;
/*     */ import com.arjuna.ats.jta.xa.XidImple;
/*     */ import java.util.HashMap;
/*     */ import javax.transaction.xa.XAException;
/*     */ import javax.transaction.xa.Xid;
/*     */ 
/*     */ public class TxImporter
/*     */ {
/* 167 */   private static HashMap _transactions = new HashMap();
/*     */ 
/*     */   public static TransactionImple importTransaction(Xid xid)
/*     */     throws XAException
/*     */   {
/*  59 */     return importTransaction(xid, 0);
/*     */   }
/*     */ 
/*     */   public static TransactionImple importTransaction(Xid xid, int timeout)
/*     */     throws XAException
/*     */   {
/*  76 */     if (xid == null) {
/*  77 */       throw new IllegalArgumentException();
/*     */     }
/*     */ 
/*  83 */     TransactionImple imported = getImportedTransaction(xid);
/*     */ 
/*  85 */     if (imported == null)
/*     */     {
/*  87 */       imported = new TransactionImple(timeout, xid);
/*     */ 
/*  89 */       _transactions.put(new XidImple(xid), imported);
/*     */     }
/*     */ 
/*  92 */     return imported;
/*     */   }
/*     */ 
/*     */   public static TransactionImple recoverTransaction(Uid actId)
/*     */     throws XAException
/*     */   {
/* 105 */     if (actId == null) {
/* 106 */       throw new IllegalArgumentException();
/*     */     }
/* 108 */     TransactionImple recovered = new TransactionImple(actId);
/*     */ 
/* 117 */     TransactionImple tx = (TransactionImple)_transactions.get(recovered.baseXid());
/*     */ 
/* 119 */     if (tx == null)
/*     */     {
/* 121 */       _transactions.put(recovered.baseXid(), recovered);
/*     */ 
/* 123 */       recovered.recordTransaction();
/*     */ 
/* 125 */       return recovered;
/*     */     }
/*     */ 
/* 128 */     return tx;
/*     */   }
/*     */ 
/*     */   public static TransactionImple getImportedTransaction(Xid xid)
/*     */     throws XAException
/*     */   {
/* 145 */     if (xid == null) {
/* 146 */       throw new IllegalArgumentException();
/*     */     }
/* 148 */     return (TransactionImple)_transactions.get(new XidImple(xid));
/*     */   }
/*     */ 
/*     */   public static void removeImportedTransaction(Xid xid)
/*     */     throws XAException
/*     */   {
/* 161 */     if (xid == null) {
/* 162 */       throw new IllegalArgumentException();
/*     */     }
/* 164 */     _transactions.remove(new XidImple(xid));
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.jta.transaction.arjunacore.jca.TxImporter
 * JD-Core Version:    0.6.0
 */