/*     */ package com.arjuna.ats.internal.jta.transaction.arjunacore;
/*     */ 
/*     */ import com.arjuna.ats.internal.jta.resources.arjunacore.SynchronizationImple;
/*     */ import com.arjuna.ats.jta.logging.jtaLogger;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import java.io.Serializable;
/*     */ import java.util.ResourceBundle;
/*     */ import javax.transaction.RollbackException;
/*     */ import javax.transaction.Synchronization;
/*     */ import javax.transaction.SystemException;
/*     */ import javax.transaction.Transaction;
/*     */ import javax.transaction.TransactionSynchronizationRegistry;
/*     */ 
/*     */ public class TransactionSynchronizationRegistryImple
/*     */   implements TransactionSynchronizationRegistry, Serializable
/*     */ {
/*     */   public Object getTransactionKey()
/*     */   {
/*  55 */     if (jtaLogger.logger.isDebugEnabled())
/*     */     {
/*  57 */       jtaLogger.logger.debug(16L, 4L, 1L, "TransactionSynchronizationRegistryImple.getTransactionKey");
/*     */     }
/*     */ 
/*  63 */     javax.transaction.TransactionManager tm = com.arjuna.ats.jta.TransactionManager.transactionManager();
/*  64 */     TransactionImple transactionImple = null;
/*     */     try
/*     */     {
/*  67 */       transactionImple = (TransactionImple)tm.getTransaction();
/*     */     }
/*     */     catch (SystemException e)
/*     */     {
/*  71 */       throw new RuntimeException(jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.systemexception"), e);
/*     */     }
/*     */ 
/*  74 */     if (transactionImple == null) {
/*  75 */       return null;
/*     */     }
/*  77 */     return transactionImple.get_uid();
/*     */   }
/*     */ 
/*     */   public void putResource(Object key, Object value)
/*     */   {
/*  84 */     if (jtaLogger.logger.isDebugEnabled())
/*     */     {
/*  86 */       jtaLogger.logger.debug(16L, 4L, 1L, "TransactionSynchronizationRegistryImple.putResource");
/*     */     }
/*     */ 
/*  92 */     if (key == null)
/*     */     {
/*  94 */       throw new NullPointerException();
/*     */     }
/*     */ 
/*  97 */     TransactionImple transactionImple = getTransactionImple();
/*  98 */     transactionImple.putTxLocalResource(key, value);
/*     */   }
/*     */ 
/*     */   public Object getResource(Object key)
/*     */   {
/* 104 */     if (jtaLogger.logger.isDebugEnabled())
/*     */     {
/* 106 */       jtaLogger.logger.debug(16L, 4L, 1L, "TransactionSynchronizationRegistryImple.getResource");
/*     */     }
/*     */ 
/* 112 */     if (key == null)
/*     */     {
/* 114 */       throw new NullPointerException();
/*     */     }
/*     */ 
/* 117 */     TransactionImple transactionImple = getTransactionImple();
/* 118 */     return transactionImple.getTxLocalResource(key);
/*     */   }
/*     */ 
/*     */   public void registerInterposedSynchronization(Synchronization synchronization)
/*     */   {
/* 129 */     if (jtaLogger.logger.isDebugEnabled())
/*     */     {
/* 131 */       jtaLogger.logger.debug(16L, 4L, 1L, "TransactionSynchronizationRegistryImple.registerInterposedSynchronization");
/*     */     }
/*     */ 
/* 137 */     TransactionImple transactionImple = getTransactionImple();
/*     */     try
/*     */     {
/* 141 */       transactionImple.registerSynchronizationImple(new SynchronizationImple(synchronization, true));
/*     */     }
/*     */     catch (RollbackException e)
/*     */     {
/* 145 */       throw new RuntimeException(jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.syncrollbackmexception"), e);
/*     */     }
/*     */     catch (SystemException e)
/*     */     {
/* 149 */       throw new RuntimeException(jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.systemexception"), e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public int getTransactionStatus()
/*     */   {
/* 156 */     if (jtaLogger.logger.isDebugEnabled())
/*     */     {
/* 158 */       jtaLogger.logger.debug(16L, 4L, 1L, "TransactionSynchronizationRegistryImple.getTransactionStatus");
/*     */     }
/*     */ 
/* 164 */     javax.transaction.TransactionManager tm = com.arjuna.ats.jta.TransactionManager.transactionManager();
/*     */     try
/*     */     {
/* 167 */       return tm.getStatus();
/*     */     }
/*     */     catch (SystemException e) {
/*     */     }
/* 171 */     throw new RuntimeException(jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.systemexception"), e);
/*     */   }
/*     */ 
/*     */   public void setRollbackOnly()
/*     */   {
/* 179 */     if (jtaLogger.logger.isDebugEnabled())
/*     */     {
/* 181 */       jtaLogger.logger.debug(16L, 4L, 1L, "TransactionSynchronizationRegistryImple.setRollbackOnly");
/*     */     }
/*     */ 
/* 187 */     javax.transaction.TransactionManager tm = com.arjuna.ats.jta.TransactionManager.transactionManager();
/*     */     try
/*     */     {
/* 190 */       Transaction transaction = tm.getTransaction();
/*     */ 
/* 192 */       if (transaction == null)
/*     */       {
/* 194 */         throw new IllegalStateException();
/*     */       }
/*     */ 
/* 197 */       tm.setRollbackOnly();
/*     */     }
/*     */     catch (SystemException e)
/*     */     {
/* 201 */       throw new RuntimeException(jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.systemexception"), e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean getRollbackOnly()
/*     */   {
/* 208 */     if (jtaLogger.logger.isDebugEnabled())
/*     */     {
/* 210 */       jtaLogger.logger.debug(16L, 4L, 1L, "TransactionSynchronizationRegistryImple.getRollbackOnly");
/*     */     }
/*     */ 
/* 216 */     TransactionImple transactionImple = getTransactionImple();
/*     */ 
/* 218 */     if (transactionImple == null) {
/* 219 */       throw new IllegalStateException();
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 224 */       return transactionImple.getStatus() == 1;
/*     */     }
/*     */     catch (SystemException e) {
/*     */     }
/* 228 */     throw new RuntimeException(jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.systemexception"), e);
/*     */   }
/*     */ 
/*     */   private TransactionImple getTransactionImple()
/*     */     throws IllegalStateException
/*     */   {
/* 234 */     javax.transaction.TransactionManager tm = com.arjuna.ats.jta.TransactionManager.transactionManager();
/* 235 */     TransactionImple transactionImple = null;
/*     */     try
/*     */     {
/* 238 */       transactionImple = (TransactionImple)tm.getTransaction();
/*     */     }
/*     */     catch (SystemException e)
/*     */     {
/* 242 */       throw new RuntimeException(jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.systemexception"), e);
/*     */     }
/*     */ 
/* 245 */     if (transactionImple == null)
/*     */     {
/* 247 */       throw new IllegalStateException();
/*     */     }
/*     */ 
/* 250 */     return transactionImple;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionSynchronizationRegistryImple
 * JD-Core Version:    0.6.0
 */