/*      */ package com.arjuna.ats.internal.jta.transaction.arjunacore;
/*      */ 
/*      */ import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
/*      */ import com.arjuna.ats.arjuna.LastResourceRecord;
/*      */ import com.arjuna.ats.arjuna.common.Uid;
/*      */ import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
/*      */ import com.arjuna.ats.arjuna.coordinator.ActionStatus;
/*      */ import com.arjuna.ats.arjuna.coordinator.BasicAction;
/*      */ import com.arjuna.ats.arjuna.exceptions.FatalError;
/*      */ import com.arjuna.ats.internal.jta.resources.arjunacore.SynchronizationImple;
/*      */ import com.arjuna.ats.internal.jta.resources.arjunacore.XAOnePhaseResource;
/*      */ import com.arjuna.ats.internal.jta.resources.arjunacore.XAResourceRecord;
/*      */ import com.arjuna.ats.internal.jta.utils.XAUtils;
/*      */ import com.arjuna.ats.internal.jta.utils.arjunacore.StatusConverter;
/*      */ import com.arjuna.ats.internal.jta.xa.TxInfo;
/*      */ import com.arjuna.ats.jta.common.Configuration;
/*      */ import com.arjuna.ats.jta.common.jtaPropertyManager;
/*      */ import com.arjuna.ats.jta.logging.jtaLogger;
/*      */ import com.arjuna.ats.jta.resources.LastResourceCommitOptimisation;
/*      */ import com.arjuna.ats.jta.utils.XAHelper;
/*      */ import com.arjuna.ats.jta.xa.XAModifier;
/*      */ import com.arjuna.ats.jta.xa.XidImple;
/*      */ import com.arjuna.common.util.logging.LogNoi18n;
/*      */ import com.arjuna.common.util.logging.Logi18n;
/*      */ import com.arjuna.common.util.propertyservice.PropertyManager;
/*      */ import java.util.Collections;
/*      */ import java.util.Enumeration;
/*      */ import java.util.HashMap;
/*      */ import java.util.Hashtable;
/*      */ import java.util.Map;
/*      */ import java.util.ResourceBundle;
/*      */ import javax.transaction.HeuristicMixedException;
/*      */ import javax.transaction.HeuristicRollbackException;
/*      */ import javax.transaction.RollbackException;
/*      */ import javax.transaction.Synchronization;
/*      */ import javax.transaction.SystemException;
/*      */ import javax.transaction.xa.XAException;
/*      */ import javax.transaction.xa.XAResource;
/*      */ import javax.transaction.xa.Xid;
/*      */ 
/*      */ public class TransactionImple
/*      */   implements javax.transaction.Transaction, com.arjuna.ats.jta.transaction.Transaction
/*      */ {
/*      */   protected com.arjuna.ats.arjuna.AtomicAction _theTransaction;
/*      */   private Hashtable _resources;
/*      */   private Hashtable _duplicateResources;
/*      */   private int _suspendCount;
/*      */   private final boolean _xaTransactionTimeoutEnabled;
/*      */   private Map _txLocalResources;
/*      */   private int lastResourceCount;
/*      */   private static final boolean ALLOW_MULTIPLE_LAST_RESOURCES;
/*      */   private static final boolean XA_TRANSACTION_TIMEOUT_ENABLED;
/*      */   private static final Class LAST_RESOURCE_OPTIMISATION_INTERFACE;
/*      */   private static ConcurrentHashMap _transactions;
/*      */ 
/*      */   public TransactionImple(int timeout)
/*      */   {
/*  117 */     this._theTransaction = new AtomicAction();
/*      */ 
/*  119 */     this._theTransaction.begin(timeout);
/*      */ 
/*  121 */     this._resources = new Hashtable();
/*  122 */     this._duplicateResources = new Hashtable();
/*  123 */     this._suspendCount = 0;
/*  124 */     this._xaTransactionTimeoutEnabled = getXATransactionTimeoutEnabled();
/*      */ 
/*  126 */     this._txLocalResources = Collections.synchronizedMap(new HashMap());
/*      */   }
/*      */ 
/*      */   public boolean equals(Object obj)
/*      */   {
/*  135 */     if (jtaLogger.logger.isDebugEnabled())
/*      */     {
/*  137 */       jtaLogger.logger.debug(16L, 4L, 1L, "TransactionImple.equals");
/*      */     }
/*      */ 
/*  143 */     if (obj == null) {
/*  144 */       return false;
/*      */     }
/*  146 */     if (obj == this) {
/*  147 */       return true;
/*      */     }
/*  149 */     if ((obj instanceof TransactionImple))
/*      */     {
/*      */       try
/*      */       {
/*  158 */         TransactionImple tx = (TransactionImple)obj;
/*      */ 
/*  160 */         return tx.get_uid().equals(this._theTransaction.get_uid());
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*      */       }
/*      */     }
/*      */ 
/*  167 */     return false;
/*      */   }
/*      */ 
/*      */   public int hashCode()
/*      */   {
/*  176 */     if (this._theTransaction == null) {
/*  177 */       return -1;
/*      */     }
/*  179 */     return this._theTransaction.get_uid().hashCode();
/*      */   }
/*      */ 
/*      */   public void commit()
/*      */     throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException, IllegalStateException
/*      */   {
/*  209 */     if (jtaLogger.logger.isDebugEnabled())
/*      */     {
/*  211 */       jtaLogger.logger.debug(16L, 4L, 1L, "TransactionImple.commit");
/*      */     }
/*      */ 
/*  217 */     if (this._theTransaction != null)
/*      */     {
/*  219 */       switch (this._theTransaction.status())
/*      */       {
/*      */       case 0:
/*      */       case 3:
/*  223 */         break;
/*      */       default:
/*  225 */         throw new IllegalStateException(jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.inactive"));
/*      */       }
/*      */ 
/*  235 */       if (!endSuspendedRMs()) {
/*  236 */         this._theTransaction.preventCommit();
/*      */       }
/*      */ 
/*  240 */       int status = this._theTransaction.end(true);
/*      */ 
/*  242 */       removeTransaction(this);
/*      */ 
/*  244 */       switch (status)
/*      */       {
/*      */       case 6:
/*      */       case 7:
/*  248 */         break;
/*      */       case 13:
/*  250 */         throw new HeuristicMixedException();
/*      */       case 14:
/*  252 */         throw new HeuristicMixedException();
/*      */       case 4:
/*      */       case 11:
/*  255 */         RollbackException rollbackException = new RollbackException(jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.commitwhenaborted"));
/*      */ 
/*  258 */         if (this._theTransaction.getDeferredThrowable() != null)
/*      */         {
/*  260 */           rollbackException.initCause(this._theTransaction.getDeferredThrowable());
/*      */         }
/*      */ 
/*  263 */         throw rollbackException;
/*      */       case 5:
/*      */       case 8:
/*      */       case 9:
/*      */       case 10:
/*      */       case 12:
/*      */       default:
/*  265 */         throw new IllegalStateException(jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.invalidstate"));
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/*  271 */       throw new IllegalStateException(jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.inactive"));
/*      */     }
/*      */   }
/*      */ 
/*      */   public void rollback()
/*      */     throws IllegalStateException, SecurityException, SystemException
/*      */   {
/*  292 */     if (jtaLogger.logger.isDebugEnabled())
/*      */     {
/*  294 */       jtaLogger.logger.debug(16L, 4L, 1L, "TransactionImple.rollback");
/*      */     }
/*      */ 
/*  300 */     if (this._theTransaction != null)
/*      */     {
/*  302 */       switch (this._theTransaction.status())
/*      */       {
/*      */       case 0:
/*      */       case 3:
/*  306 */         break;
/*      */       default:
/*  308 */         throw new IllegalStateException(jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.inactive"));
/*      */       }
/*      */ 
/*  319 */       boolean endSuspendedFailed = !endSuspendedRMs();
/*      */ 
/*  321 */       if (endSuspendedFailed)
/*      */       {
/*  323 */         if (jtaLogger.loggerI18N.isWarnEnabled())
/*      */         {
/*  325 */           jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.transaction.arjunacore.endsuspendfailed1");
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  330 */       int outcome = this._theTransaction.cancel();
/*      */ 
/*  334 */       removeTransaction(this);
/*      */ 
/*  336 */       switch (outcome)
/*      */       {
/*      */       case 2:
/*      */       case 4:
/*  340 */         break;
/*      */       default:
/*  342 */         throw new IllegalStateException(jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.rollbackstatus") + ActionStatus.stringForm(outcome));
/*      */       }
/*      */ 
/*  348 */       if (endSuspendedFailed) {
/*  349 */         throw new IllegalStateException(jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.endsuspendfailed2"));
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/*  354 */       throw new IllegalStateException(jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.inactive"));
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setRollbackOnly()
/*      */     throws IllegalStateException, SystemException
/*      */   {
/*  362 */     if (jtaLogger.logger.isDebugEnabled())
/*      */     {
/*  364 */       jtaLogger.logger.debug(16L, 4L, 1L, "TransactionImple.setRollbackOnly");
/*      */     }
/*      */ 
/*  370 */     if (this._theTransaction != null)
/*      */     {
/*  372 */       if (!this._theTransaction.preventCommit())
/*      */       {
/*  374 */         switch (this._theTransaction.status())
/*      */         {
/*      */         case 2:
/*      */         case 4:
/*  378 */           break;
/*      */         default:
/*  380 */           throw new IllegalStateException(jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.inactive"));
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/*  387 */       throw new IllegalStateException(jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.inactive"));
/*      */     }
/*      */   }
/*      */ 
/*      */   public int getStatus()
/*      */     throws SystemException
/*      */   {
/*  394 */     if (jtaLogger.logger.isDebugEnabled())
/*      */     {
/*  396 */       jtaLogger.logger.debug(16L, 4L, 1L, "TransactionImple.getStatus");
/*      */     }
/*      */ 
/*  402 */     int status = 6;
/*      */ 
/*  404 */     if (this._theTransaction != null)
/*      */     {
/*  406 */       return StatusConverter.convert(this._theTransaction.status());
/*      */     }
/*      */ 
/*  409 */     return status;
/*      */   }
/*      */ 
/*      */   public void registerSynchronization(Synchronization sync)
/*      */     throws RollbackException, IllegalStateException, SystemException
/*      */   {
/*  425 */     if (jtaLogger.logger.isDebugEnabled())
/*      */     {
/*  427 */       jtaLogger.logger.debug(16L, 4L, 1L, "TransactionImple.registerSynchronization");
/*      */     }
/*      */ 
/*  433 */     if (sync == null)
/*      */     {
/*  435 */       throw new SystemException("TransactionImple.registerSynchronization - " + jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.nullparam"));
/*      */     }
/*      */ 
/*  441 */     registerSynchronizationImple(new SynchronizationImple(sync, false));
/*      */   }
/*      */ 
/*      */   void registerSynchronizationImple(SynchronizationImple synchronizationImple)
/*      */     throws RollbackException, IllegalStateException, SystemException
/*      */   {
/*  456 */     if (this._theTransaction != null)
/*      */     {
/*  458 */       if (this._theTransaction.addSynchronization(synchronizationImple) != 2)
/*      */       {
/*  460 */         int status = this._theTransaction.status();
/*      */ 
/*  462 */         switch (status)
/*      */         {
/*      */         case 4:
/*  465 */           throw new RollbackException(jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.syncwhenaborted"));
/*      */         case 8:
/*  469 */           throw new IllegalStateException(jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.inactive"));
/*      */         }
/*      */ 
/*  473 */         throw new IllegalStateException(jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.syncsnotallowed"));
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/*  480 */       throw new IllegalStateException(jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.inactive"));
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean enlistResource(XAResource xaRes)
/*      */     throws RollbackException, IllegalStateException, SystemException
/*      */   {
/*  499 */     return enlistResource(xaRes, null);
/*      */   }
/*      */ 
/*      */   public boolean enlistResource(XAResource xaRes, Object[] params)
/*      */     throws RollbackException, IllegalStateException, SystemException
/*      */   {
/*  526 */     if (jtaLogger.logger.isDebugEnabled())
/*      */     {
/*  528 */       jtaLogger.logger.debug(16L, 4L, 1L, "TransactionImple.enlistResource ( " + xaRes + " )");
/*      */     }
/*      */ 
/*  534 */     if (xaRes == null) {
/*  535 */       throw new SystemException("TransactionImple.enlistResource - " + jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.nullres"));
/*      */     }
/*      */ 
/*  540 */     int status = getStatus();
/*      */ 
/*  542 */     switch (status)
/*      */     {
/*      */     case 1:
/*  545 */       throw new RollbackException("TransactionImple.enlistResource - " + jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.nullres"));
/*      */     case 0:
/*  550 */       break;
/*      */     default:
/*  552 */       throw new IllegalStateException(jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.inactive"));
/*      */     }
/*      */ 
/*  557 */     XAModifier theModifier = null;
/*      */ 
/*  559 */     if (params != null)
/*      */     {
/*  561 */       if (params.length >= 2)
/*      */       {
/*  563 */         if ((params[1] instanceof XAModifier))
/*      */         {
/*  565 */           theModifier = (XAModifier)params[1];
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  579 */       TxInfo info = null;
/*      */       try
/*      */       {
/*  588 */         synchronized (this)
/*      */         {
/*  590 */           info = (TxInfo)this._resources.get(xaRes);
/*      */ 
/*  592 */           if (info == null)
/*      */           {
/*  599 */             info = (TxInfo)this._duplicateResources.get(xaRes);
/*      */           }
/*      */         }
/*      */ 
/*  603 */         if (info != null)
/*      */         {
/*  605 */           switch (info.getState())
/*      */           {
/*      */           case 2:
/*  615 */             int xaStartResume = theModifier == null ? 134217728 : theModifier.xaStartParameters(134217728);
/*      */ 
/*  619 */             xaRes.start(info.xid(), xaStartResume);
/*      */ 
/*  621 */             info.setState(0);
/*      */ 
/*  623 */             synchronized (this)
/*      */             {
/*  625 */               this._suspendCount -= 1;
/*      */             }
/*      */ 
/*  628 */             return true;
/*      */           case 0:
/*  637 */             return true;
/*      */           case 1:
/*  645 */             int xaStartJoin = theModifier == null ? 2097152 : theModifier.xaStartParameters(2097152);
/*      */ 
/*  649 */             xaRes.start(info.xid(), xaStartJoin);
/*      */ 
/*  651 */             info.setState(0);
/*      */ 
/*  653 */             return true;
/*      */           }
/*      */ 
/*  660 */           throw new IllegalStateException("TransactionImple.enlistResource - " + jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.illresstate") + ":" + info.getState());
/*      */         }
/*      */ 
/*      */       }
/*      */       catch (IllegalStateException ex)
/*      */       {
/*  671 */         throw ex;
/*      */       }
/*      */       catch (XAException exp)
/*      */       {
/*  675 */         if (info != null) {
/*  676 */           info.setState(3);
/*      */         }
/*  678 */         if (jtaLogger.loggerI18N.isWarnEnabled())
/*      */         {
/*  680 */           jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.transaction.arjunacore.enlisterror", new Object[] { "TransactionImple.enlistResource", XAHelper.printXAErrorCode(exp) });
/*      */         }
/*      */ 
/*  688 */         return false;
/*      */       }
/*      */ 
/*  701 */       Xid xid = null;
/*  702 */       TxInfo existingRM = isNewRM(xaRes);
/*      */ 
/*  704 */       if (existingRM == null)
/*      */       {
/*  710 */         boolean branchRequired = true;
/*      */ 
/*  712 */         synchronized (this)
/*      */         {
/*  714 */           if (this._resources.size() == 0)
/*      */           {
/*  718 */             branchRequired = true;
/*      */           }
/*      */         }
/*      */ 
/*  722 */         xid = createXid(branchRequired, theModifier);
/*      */ 
/*  724 */         boolean associatedWork = false;
/*  725 */         int retry = 20;
/*      */ 
/*  740 */         while (!associatedWork)
/*      */         {
/*      */           try
/*      */           {
/*  744 */             if (this._xaTransactionTimeoutEnabled)
/*      */             {
/*  746 */               int timeout = this._theTransaction.getTimeout();
/*      */ 
/*  748 */               if (timeout > 0)
/*      */               {
/*      */                 try
/*      */                 {
/*  752 */                   xaRes.setTransactionTimeout(timeout);
/*      */                 }
/*      */                 catch (XAException te)
/*      */                 {
/*  756 */                   if (jtaLogger.loggerI18N.isWarnEnabled())
/*      */                   {
/*  758 */                     jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.transaction.arjunacore.timeouterror", new Object[] { "TransactionImple.enlistResource", XAHelper.printXAErrorCode(te), xid });
/*      */                   }
/*      */ 
/*      */                 }
/*      */ 
/*      */               }
/*      */ 
/*      */             }
/*      */ 
/*  772 */             int xaStartNormal = theModifier == null ? 0 : theModifier.xaStartParameters(0);
/*      */ 
/*  776 */             xaRes.start(xid, xaStartNormal);
/*      */ 
/*  778 */             associatedWork = true;
/*      */ 
/*  780 */             this._resources.put(xaRes, new TxInfo(xid));
/*      */           }
/*      */           catch (XAException e)
/*      */           {
/*  786 */             if ((e.errorCode == -8) || (e.errorCode == -3))
/*      */             {
/*  789 */               if (retry > 0) {
/*  790 */                 xid = createXid(true, theModifier);
/*      */               }
/*  792 */               retry--;
/*      */             }
/*      */             else
/*      */             {
/*  801 */               if (jtaLogger.loggerI18N.isWarnEnabled())
/*      */               {
/*  803 */                 jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.transaction.arjunacore.enliststarterror", new Object[] { "TransactionImple.enlistResource", XAHelper.printXAErrorCode(e), xid });
/*      */               }
/*      */ 
/*  814 */               markRollbackOnly();
/*      */ 
/*  816 */               throw e;
/*      */             }
/*      */           }
/*  819 */           if (retry < 0)
/*      */           {
/*  821 */             if (jtaLogger.loggerI18N.isWarnEnabled())
/*      */             {
/*  823 */               jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.transaction.arjunacore.enliststarterror", new Object[] { "TransactionImple.enlistResource", XAHelper.printXAErrorCode(e), xid });
/*      */             }
/*      */ 
/*  834 */             markRollbackOnly();
/*      */ 
/*  836 */             throw new SystemException("TransactionImple.enlistResource - XAResource.start " + jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.couldnotregister") + ": " + xid);
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*      */       else
/*      */       {
/*  858 */         xid = existingRM.xid();
/*      */         try
/*      */         {
/*  862 */           int xaStartJoin = theModifier == null ? 2097152 : theModifier.xaStartParameters(2097152);
/*      */ 
/*  865 */           xaRes.start(xid, xaStartJoin);
/*      */         }
/*      */         catch (XAException ex)
/*      */         {
/*  869 */           if (jtaLogger.loggerI18N.isWarnEnabled())
/*      */           {
/*  871 */             jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.transaction.arjunacore.xastart", new Object[] { "TransactionImple.enlistResource - xa_start ", XAHelper.printXAErrorCode(ex), xid });
/*      */           }
/*      */ 
/*  881 */           markRollbackOnly();
/*      */ 
/*  883 */           throw ex;
/*      */         }
/*      */ 
/*  891 */         this._duplicateResources.put(xaRes, new TxInfo(xid));
/*      */ 
/*  893 */         return true;
/*      */       }
/*      */       AbstractRecord record;
/*      */       Object record;
/*  902 */       if (((xaRes instanceof LastResourceCommitOptimisation)) || ((LAST_RESOURCE_OPTIMISATION_INTERFACE != null) && (LAST_RESOURCE_OPTIMISATION_INTERFACE.isInstance(xaRes))))
/*      */       {
/*  906 */         if (this.lastResourceCount == 1)
/*      */         {
/*  908 */           if (jtaLogger.loggerI18N.isWarnEnabled())
/*      */           {
/*  910 */             if (ALLOW_MULTIPLE_LAST_RESOURCES)
/*      */             {
/*  912 */               jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.transaction.arjunacore.lastResource.multipleWarning", new Object[] { xaRes });
/*      */             }
/*      */             else
/*      */             {
/*  920 */               jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.transaction.arjunacore.lastResource.disallow", new Object[] { xaRes });
/*      */             }
/*      */           }
/*      */         }
/*      */         Object record;
/*  929 */         if ((this.lastResourceCount++ == 0) || (ALLOW_MULTIPLE_LAST_RESOURCES))
/*      */         {
/*  931 */           record = new LastResourceRecord(new XAOnePhaseResource(xaRes, xid, params));
/*      */         }
/*      */         else
/*      */         {
/*  936 */           record = null;
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/*  941 */         record = new XAResourceRecord(this, xaRes, xid, params);
/*      */       }
/*      */ 
/*  944 */       if ((record == null) || (this._theTransaction.add((AbstractRecord)record) != 2))
/*      */       {
/*  947 */         markRollbackOnly();
/*      */ 
/*  949 */         return false;
/*      */       }
/*      */ 
/*  952 */       return true;
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  956 */       e.printStackTrace();
/*      */ 
/*  964 */       markRollbackOnly();
/*      */     }
/*  966 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean delistResource(XAResource xaRes, int flags)
/*      */     throws IllegalStateException, SystemException
/*      */   {
/*  993 */     if (jtaLogger.logger.isDebugEnabled())
/*      */     {
/*  995 */       jtaLogger.logger.debug(16L, 4L, 1L, "TransactionImple.delistResource ( " + xaRes + " )");
/*      */     }
/*      */ 
/* 1001 */     if (xaRes == null) {
/* 1002 */       throw new SystemException("TransactionImple.delistResource - " + jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.nullres"));
/*      */     }
/*      */ 
/* 1007 */     int status = getStatus();
/*      */ 
/* 1009 */     switch (status)
/*      */     {
/*      */     case 0:
/* 1012 */       break;
/*      */     case 1:
/* 1014 */       break;
/*      */     default:
/* 1016 */       throw new IllegalStateException(jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.inactive"));
/*      */     }
/*      */ 
/* 1021 */     TxInfo info = null;
/*      */     try
/*      */     {
/* 1025 */       synchronized (this)
/*      */       {
/* 1027 */         info = (TxInfo)this._resources.get(xaRes);
/*      */ 
/* 1029 */         if (info == null) {
/* 1030 */           info = (TxInfo)this._duplicateResources.get(xaRes);
/*      */         }
/*      */       }
/* 1033 */       if (info == null)
/*      */       {
/* 1035 */         if (jtaLogger.loggerI18N.isWarnEnabled())
/*      */         {
/* 1037 */           jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.transaction.arjunacore.unknownresource", new Object[] { "TransactionImple.delistResource" });
/*      */         }
/*      */ 
/* 1044 */         return false;
/*      */       }
/*      */ 
/* 1048 */       boolean optimizedRollback = false;
/*      */       try
/*      */       {
/* 1057 */         if (status == 1)
/*      */         {
/* 1059 */           if (XAUtils.canOptimizeDelist(xaRes))
/*      */           {
/* 1061 */             xaRes.end(info.xid(), 536870912);
/* 1062 */             xaRes.rollback(info.xid());
/*      */ 
/* 1064 */             info.setState(4);
/*      */ 
/* 1066 */             optimizedRollback = true;
/*      */           }
/*      */         }
/*      */ 
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*      */       }
/*      */ 
/* 1075 */       switch (info.getState())
/*      */       {
/*      */       case 0:
/* 1079 */         if ((flags & 0x4000000) != 0)
/*      */         {
/* 1081 */           xaRes.end(info.xid(), 67108864);
/* 1082 */           info.setState(1);
/*      */         }
/* 1086 */         else if ((flags & 0x2000000) != 0)
/*      */         {
/* 1088 */           xaRes.end(info.xid(), 33554432);
/* 1089 */           info.setState(2);
/*      */ 
/* 1091 */           synchronized (this)
/*      */           {
/* 1093 */             this._suspendCount += 1;
/*      */           }
/*      */         }
/*      */         else
/*      */         {
/* 1098 */           xaRes.end(info.xid(), 536870912);
/* 1099 */           info.setState(3);
/*      */         }
/*      */ 
/* 1103 */         break;
/*      */       case 2:
/* 1106 */         if ((flags & 0x4000000) != 0)
/*      */         {
/* 1111 */           if (XAUtils.mustEndSuspendedRMs(xaRes)) {
/* 1112 */             xaRes.start(info.xid(), 134217728);
/*      */           }
/* 1114 */           xaRes.end(info.xid(), 67108864);
/* 1115 */           info.setState(1);
/*      */ 
/* 1117 */           synchronized (this)
/*      */           {
/* 1119 */             this._suspendCount -= 1;
/*      */           }
/*      */         }
/*      */         else
/*      */         {
/* 1124 */           if ((flags & 0x2000000) != 0)
/*      */           {
/* 1129 */             throw new IllegalStateException("TransactionImple.delistResource - " + jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.ressuspended"));
/*      */           }
/*      */ 
/* 1136 */           xaRes.end(info.xid(), 536870912);
/* 1137 */           info.setState(3);
/*      */ 
/* 1139 */           synchronized (this)
/*      */           {
/* 1141 */             this._suspendCount -= 1;
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/* 1146 */         break;
/*      */       default:
/* 1149 */         if (optimizedRollback) break;
/* 1150 */         throw new IllegalStateException("TransactionImple.delistResource - " + jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.illresstate") + ":" + info.getState());
/*      */       }
/*      */ 
/* 1158 */       info = null;
/*      */ 
/* 1160 */       return true;
/*      */     }
/*      */     catch (IllegalStateException ex)
/*      */     {
/* 1165 */       throw ex;
/*      */     }
/*      */     catch (XAException exp)
/*      */     {
/* 1169 */       if (info != null) {
/* 1170 */         info.setState(3);
/*      */       }
/*      */ 
/* 1176 */       markRollbackOnly();
/*      */ 
/* 1178 */       if (jtaLogger.loggerI18N.isWarnEnabled())
/*      */       {
/* 1180 */         jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.transaction.arjunacore.delistresource", new Object[] { "TransactionImple.delistResource", XAHelper.printXAErrorCode(exp) });
/*      */       }
/*      */ 
/* 1188 */       return false;
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/* 1192 */       if (jtaLogger.loggerI18N.isWarnEnabled())
/*      */       {
/* 1194 */         jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.transaction.arjunacore.delistgeneral", new Object[] { "TransactionImple.delistResource", e });
/*      */       }
/*      */ 
/* 1206 */       markRollbackOnly();
/*      */     }
/* 1208 */     return false;
/*      */   }
/*      */ 
/*      */   public final Uid get_uid()
/*      */   {
/* 1214 */     return this._theTransaction.get_uid();
/*      */   }
/*      */ 
/*      */   public String toString()
/*      */   {
/* 1219 */     if (this._theTransaction == null) {
/* 1220 */       return "TransactionImple < ac, NoTransaction >";
/*      */     }
/*      */ 
/* 1223 */     return "TransactionImple < ac, " + this._theTransaction + " >";
/*      */   }
/*      */ 
/*      */   public int getXAResourceState(XAResource xaRes)
/*      */   {
/* 1229 */     int state = 5;
/*      */ 
/* 1231 */     if (xaRes != null)
/*      */     {
/* 1233 */       TxInfo info = (TxInfo)this._resources.get(xaRes);
/*      */ 
/* 1235 */       if (info == null)
/*      */       {
/* 1237 */         info = (TxInfo)this._duplicateResources.get(xaRes);
/*      */       }
/*      */ 
/* 1240 */       if (info != null) {
/* 1241 */         state = info.getState();
/*      */       }
/*      */     }
/* 1244 */     return state;
/*      */   }
/*      */ 
/*      */   public static final TransactionImple getTransaction()
/*      */   {
/* 1249 */     TransactionImple tx = null;
/*      */ 
/* 1251 */     BasicAction current = BasicAction.Current();
/* 1252 */     if (current != null)
/*      */     {
/* 1254 */       Uid txid = current.get_uid();
/*      */ 
/* 1256 */       tx = (TransactionImple)_transactions.get(txid);
/* 1257 */       if (tx == null) {
/* 1258 */         tx = new TransactionImple(current);
/*      */       }
/*      */     }
/* 1261 */     return tx;
/*      */   }
/*      */ 
/*      */   public static final TransactionImple getTransaction(Uid id)
/*      */   {
/*      */     try
/*      */     {
/* 1268 */       if (id != null) {
/* 1269 */         return (TransactionImple)_transactions.get(id);
/*      */       }
/* 1271 */       return null;
/*      */     }
/*      */     catch (Exception e) {
/*      */     }
/* 1275 */     return new TransactionImple(null);
/*      */   }
/*      */ 
/*      */   public Object getTxLocalResource(Object key)
/*      */   {
/* 1282 */     return this._txLocalResources.get(key);
/*      */   }
/*      */ 
/*      */   public void putTxLocalResource(Object key, Object value)
/*      */   {
/* 1288 */     this._txLocalResources.put(key, value);
/*      */   }
/*      */ 
/*      */   public boolean isAlive()
/*      */   {
/* 1300 */     return _transactions.contains(this);
/*      */   }
/*      */ 
/*      */   protected TransactionImple()
/*      */   {
/* 1305 */     this(null);
/*      */   }
/*      */ 
/*      */   protected TransactionImple(BasicAction curr)
/*      */   {
/*      */     try
/*      */     {
/* 1316 */       if (curr == null)
/*      */       {
/* 1318 */         this._theTransaction = ((com.arjuna.ats.arjuna.AtomicAction)BasicAction.Current());
/*      */       }
/*      */       else
/*      */       {
/* 1322 */         this._theTransaction = ((com.arjuna.ats.arjuna.AtomicAction)curr);
/*      */       }
/*      */     }
/*      */     catch (ClassCastException ex) {
/* 1326 */       if (jtaLogger.loggerI18N.isWarnEnabled())
/*      */       {
/* 1328 */         jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.transaction.arjunacore.notatomicaction");
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1333 */     if (this._theTransaction != null)
/*      */     {
/* 1335 */       this._resources = new Hashtable();
/* 1336 */       this._duplicateResources = new Hashtable();
/* 1337 */       this._txLocalResources = Collections.synchronizedMap(new HashMap());
/*      */     }
/*      */     else
/*      */     {
/* 1341 */       this._resources = null;
/* 1342 */       this._duplicateResources = null;
/*      */     }
/*      */ 
/* 1345 */     this._suspendCount = 0;
/* 1346 */     this._xaTransactionTimeoutEnabled = getXATransactionTimeoutEnabled();
/*      */   }
/*      */ 
/*      */   final com.arjuna.ats.arjuna.AtomicAction getAtomicAction()
/*      */   {
/* 1351 */     return this._theTransaction;
/*      */   }
/*      */ 
/*      */   protected void commitAndDisassociate()
/*      */     throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException, IllegalStateException
/*      */   {
/* 1365 */     if (jtaLogger.logger.isDebugEnabled())
/*      */     {
/* 1367 */       jtaLogger.logger.debug(16L, 4L, 1L, "TransactionImple.commitAndDisassociate");
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/* 1372 */       if (this._theTransaction != null)
/*      */       {
/* 1374 */         switch (this._theTransaction.status())
/*      */         {
/*      */         case 2:
/*      */         case 4:
/* 1378 */           this._theTransaction.abort();
/* 1379 */           throw new IllegalStateException(jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.inactive"));
/*      */         case 6:
/*      */         case 7:
/* 1384 */           this._theTransaction.commit(true);
/* 1385 */           throw new IllegalStateException(jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.inactive"));
/*      */         case 3:
/*      */         case 5:
/*      */         }
/* 1389 */         switch (this._theTransaction.commit(true))
/*      */         {
/*      */         case 6:
/*      */         case 7:
/* 1393 */           break;
/*      */         case 13:
/* 1395 */           throw new HeuristicMixedException();
/*      */         case 14:
/* 1397 */           throw new HeuristicMixedException();
/*      */         case 2:
/*      */         case 4:
/*      */         case 11:
/* 1401 */           RollbackException rollbackException = new RollbackException(jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.commitwhenaborted"));
/* 1402 */           if (this._theTransaction.getDeferredThrowable() != null) {
/* 1403 */             rollbackException.initCause(this._theTransaction.getDeferredThrowable());
/*      */           }
/* 1405 */           throw rollbackException;
/*      */         case 3:
/*      */         case 5:
/*      */         case 8:
/*      */         case 9:
/*      */         case 10:
/*      */         case 12:
/*      */         default:
/* 1407 */           throw new IllegalStateException(jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.invalidstate"));
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/* 1412 */         throw new IllegalStateException(jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.inactive"));
/*      */       }
/*      */     }
/*      */     finally
/*      */     {
/* 1417 */       removeTransaction(this);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected Xid baseXid()
/*      */   {
/* 1431 */     return null;
/*      */   }
/*      */ 
/*      */   protected void rollbackAndDisassociate()
/*      */     throws IllegalStateException, SecurityException, SystemException
/*      */   {
/* 1442 */     if (jtaLogger.logger.isDebugEnabled())
/*      */     {
/* 1444 */       jtaLogger.logger.debug(16L, 4L, 1L, "TransactionImple.rollbackAndDisassociate");
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/* 1449 */       boolean statusIsValid = false;
/*      */ 
/* 1451 */       if (this._theTransaction != null)
/*      */       {
/* 1453 */         if ((this._theTransaction.status() == 0) || (this._theTransaction.status() == 3))
/*      */         {
/* 1455 */           statusIsValid = true;
/*      */         }
/*      */ 
/* 1458 */         int outcome = this._theTransaction.abort();
/*      */ 
/* 1460 */         switch (outcome)
/*      */         {
/*      */         case 2:
/*      */         case 4:
/* 1464 */           break;
/*      */         default:
/* 1466 */           throw new IllegalStateException(jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.rollbackstatus") + ActionStatus.stringForm(outcome));
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 1472 */       if ((this._theTransaction == null) || (!statusIsValid)) {
/* 1473 */         throw new IllegalStateException(jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.inactive"));
/*      */       }
/*      */ 
/*      */     }
/*      */     finally
/*      */     {
/* 1479 */       removeTransaction(this);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected boolean endSuspendedRMs()
/*      */   {
/* 1494 */     boolean result = true;
/*      */ 
/* 1496 */     if (this._suspendCount > 0)
/*      */     {
/* 1498 */       Enumeration el = this._resources.keys();
/*      */ 
/* 1507 */       if (el != null)
/*      */       {
/* 1509 */         while (el.hasMoreElements())
/*      */         {
/*      */           try
/*      */           {
/* 1521 */             XAResource xaRes = (XAResource)el.nextElement();
/* 1522 */             TxInfo info = (TxInfo)this._resources.get(xaRes);
/*      */ 
/* 1524 */             if (info.getState() == 2)
/*      */             {
/* 1526 */               if (XAUtils.mustEndSuspendedRMs(xaRes)) {
/* 1527 */                 xaRes.start(info.xid(), 134217728);
/*      */               }
/* 1529 */               xaRes.end(info.xid(), 67108864);
/* 1530 */               info.setState(1);
/*      */             }
/*      */           }
/*      */           catch (XAException ex)
/*      */           {
/* 1535 */             if (jtaLogger.loggerI18N.isWarnEnabled())
/*      */             {
/* 1537 */               jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.transaction.arjunacore.xaenderror");
/*      */             }
/*      */ 
/* 1541 */             result = false;
/*      */           }
/*      */         }
/*      */       }
/*      */ 
/* 1546 */       this._suspendCount = 0;
/*      */     }
/*      */ 
/* 1549 */     return result;
/*      */   }
/*      */ 
/*      */   private final boolean threadIsActive(XAResource xaRes)
/*      */   {
/* 1567 */     Thread t = Thread.currentThread();
/*      */     try
/*      */     {
/* 1571 */       Enumeration el = this._resources.keys();
/*      */ 
/* 1573 */       if (el != null)
/*      */       {
/* 1575 */         while (el.hasMoreElements())
/*      */         {
/* 1577 */           XAResource x = (XAResource)el.nextElement();
/*      */ 
/* 1579 */           if (x.isSameRM(xaRes))
/*      */           {
/* 1581 */             TxInfo info = (TxInfo)this._resources.get(x);
/*      */ 
/* 1583 */             if (info.thread() == t) {
/* 1584 */               return true;
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/* 1589 */       el = this._duplicateResources.keys();
/*      */ 
/* 1591 */       if (el != null)
/*      */       {
/* 1593 */         while (el.hasMoreElements())
/*      */         {
/* 1595 */           XAResource x = (XAResource)el.nextElement();
/*      */ 
/* 1597 */           if (x.isSameRM(xaRes))
/*      */           {
/* 1599 */             TxInfo info = (TxInfo)this._resources.get(x);
/*      */ 
/* 1601 */             if (info.thread() == t)
/* 1602 */               return true;
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/* 1609 */       if (jtaLogger.loggerI18N.isWarnEnabled())
/*      */       {
/* 1611 */         jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.transaction.arjunacore.threadexception", new Object[] { e });
/*      */       }
/*      */ 
/* 1618 */       throw new FatalError(e.toString());
/*      */     }
/*      */ 
/* 1621 */     return false;
/*      */   }
/*      */ 
/*      */   private final TxInfo isNewRM(XAResource xaRes)
/*      */   {
/*      */     try
/*      */     {
/* 1640 */       synchronized (this)
/*      */       {
/* 1642 */         Enumeration el = this._resources.keys();
/*      */ 
/* 1644 */         if (el != null)
/*      */         {
/* 1646 */           while (el.hasMoreElements())
/*      */           {
/* 1648 */             XAResource x = (XAResource)el.nextElement();
/*      */ 
/* 1650 */             if (x.isSameRM(xaRes))
/*      */             {
/* 1652 */               return (TxInfo)this._resources.get(x);
/*      */             }
/*      */           }
/*      */         }
/*      */ 
/* 1657 */         el = this._duplicateResources.keys();
/*      */ 
/* 1659 */         if (el != null)
/*      */         {
/* 1661 */           while (el.hasMoreElements())
/*      */           {
/* 1663 */             XAResource x = (XAResource)el.nextElement();
/*      */ 
/* 1665 */             if (x.isSameRM(xaRes))
/*      */             {
/* 1667 */               return (TxInfo)this._duplicateResources.get(x);
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */     catch (XAException ex)
/*      */     {
/* 1675 */       if (jtaLogger.loggerI18N.isWarnEnabled())
/*      */       {
/* 1677 */         jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.transaction.arjunacore.newtmerror", new Object[] { "TransactionImple.isNewRM", XAHelper.printXAErrorCode(ex) });
/*      */       }
/*      */ 
/* 1685 */       throw new FatalError(ex.toString());
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/* 1689 */       if (jtaLogger.loggerI18N.isWarnEnabled())
/*      */       {
/* 1691 */         jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.transaction.arjunacore.newtmerror", new Object[] { e });
/*      */       }
/*      */ 
/* 1698 */       throw new FatalError(e.toString());
/*      */     }
/*      */ 
/* 1701 */     return null;
/*      */   }
/*      */ 
/*      */   private final Xid createXid(boolean branch, XAModifier theModifier)
/*      */   {
/* 1706 */     Xid xid = baseXid();
/*      */ 
/* 1708 */     if (xid != null) {
/* 1709 */       return xid;
/*      */     }
/* 1711 */     xid = new XidImple(this._theTransaction, branch);
/*      */ 
/* 1713 */     if (theModifier != null)
/*      */     {
/*      */       try
/*      */       {
/* 1717 */         xid = theModifier.createXid((XidImple)xid);
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/* 1721 */         e.printStackTrace();
/*      */       }
/*      */     }
/*      */ 
/* 1725 */     return xid;
/*      */   }
/*      */ 
/*      */   private final void markRollbackOnly()
/*      */   {
/*      */     try
/*      */     {
/* 1745 */       setRollbackOnly();
/*      */     }
/*      */     catch (Exception ex)
/*      */     {
/* 1749 */       if (jtaLogger.loggerI18N.isWarnEnabled())
/*      */       {
/* 1751 */         jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.transaction.arjunacore.markrollback", new Object[] { "TransactionImple.markRollbackOnly", this._theTransaction });
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected static final void putTransaction(TransactionImple tx)
/*      */   {
/* 1767 */     _transactions.put(tx.get_uid(), tx);
/*      */   }
/*      */ 
/*      */   protected static final void removeTransaction(TransactionImple tx)
/*      */   {
/* 1772 */     _transactions.remove(tx.get_uid());
/*      */   }
/*      */ 
/*      */   private static boolean getXATransactionTimeoutEnabled()
/*      */   {
/* 1777 */     Boolean xaTransactionTimeoutEnabled = Configuration.getXATransactionTimeoutEnabled();
/*      */ 
/* 1779 */     if (xaTransactionTimeoutEnabled != null)
/*      */     {
/* 1781 */       return xaTransactionTimeoutEnabled.booleanValue();
/*      */     }
/* 1783 */     return XA_TRANSACTION_TIMEOUT_ENABLED;
/*      */   }
/*      */ 
/*      */   static
/*      */   {
/* 1814 */     String xaTransactionTimeoutEnabled = jtaPropertyManager.propertyManager.getProperty("com.arjuna.ats.jta.xaTransactionTimeoutEnabled");
/*      */ 
/* 1816 */     if (xaTransactionTimeoutEnabled != null)
/*      */     {
/* 1818 */       XA_TRANSACTION_TIMEOUT_ENABLED = Boolean.valueOf(xaTransactionTimeoutEnabled).booleanValue();
/*      */     }
/*      */     else
/*      */     {
/* 1823 */       XA_TRANSACTION_TIMEOUT_ENABLED = true;
/*      */     }
/* 1825 */     String lastResourceOptimisationInterfaceName = jtaPropertyManager.propertyManager.getProperty("com.arjuna.ats.jta.lastResourceOptimisationInterface");
/*      */ 
/* 1827 */     Class lastResourceOptimisationInterface = null;
/* 1828 */     if (lastResourceOptimisationInterfaceName != null)
/*      */     {
/*      */       try
/*      */       {
/* 1832 */         lastResourceOptimisationInterface = Thread.currentThread().getContextClassLoader().loadClass(lastResourceOptimisationInterfaceName);
/*      */       }
/*      */       catch (Throwable th)
/*      */       {
/* 1838 */         if (jtaLogger.loggerI18N.isWarnEnabled())
/*      */         {
/* 1840 */           jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.transaction.arjunacore.lastResourceOptimisationInterface", new Object[] { lastResourceOptimisationInterfaceName }, th);
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1849 */     LAST_RESOURCE_OPTIMISATION_INTERFACE = lastResourceOptimisationInterface;
/*      */ 
/* 1851 */     String allowMultipleLastResources = jtaPropertyManager.getPropertyManager().getProperty("com.arjuna.ats.jta.allowMultipleLastResources");
/*      */ 
/* 1854 */     ALLOW_MULTIPLE_LAST_RESOURCES = allowMultipleLastResources == null ? false : Boolean.valueOf(allowMultipleLastResources).booleanValue();
/*      */ 
/* 1856 */     if ((ALLOW_MULTIPLE_LAST_RESOURCES) && (jtaLogger.loggerI18N.isWarnEnabled()))
/*      */     {
/* 1859 */       jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.transaction.arjunacore.lastResource.startupWarning");
/*      */     }
/*      */ 
/* 1864 */     _transactions = new ConcurrentHashMap();
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionImple
 * JD-Core Version:    0.6.0
 */