/*     */ package com.arjuna.ats.internal.jta.recovery.arjunacore;
/*     */ 
/*     */ import com.arjuna.ats.jta.utils.XAHelper;
/*     */ import java.util.Vector;
/*     */ import javax.transaction.xa.XAResource;
/*     */ import javax.transaction.xa.Xid;
/*     */ 
/*     */ public class RecoveryXids
/*     */ {
/*     */   private Xid[] _scanN;
/*     */   private Xid[] _scanM;
/*     */   private XAResource _xares;
/*     */   private int _scanHoldNumber;
/*     */   private static final int MAX_SCAN_HOLD = 10;
/*     */ 
/*     */   public RecoveryXids(XAResource xares)
/*     */   {
/*  50 */     this._xares = xares;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/*  55 */     if ((obj instanceof RecoveryXids))
/*     */     {
/*     */       try
/*     */       {
/*  59 */         return ((RecoveryXids)obj)._xares.isSameRM(this._xares);
/*     */       }
/*     */       catch (Exception ex)
/*     */       {
/*     */       }
/*     */     }
/*     */ 
/*  66 */     return false;
/*     */   }
/*     */ 
/*     */   public final void nextScan(Xid[] trans)
/*     */   {
/*  76 */     this._scanHoldNumber += 1;
/*     */ 
/*  88 */     if (this._scanHoldNumber > 10) {
/*  89 */       this._scanM = null;
/*     */     }
/*  91 */     if (this._scanM == null) {
/*  92 */       this._scanM = this._scanN;
/*     */     }
/*  95 */     else if ((this._scanM != null) && (this._scanN != null))
/*     */     {
/*  97 */       int newArraySize = this._scanM.length + this._scanN.length;
/*  98 */       Xid[] copy = new Xid[newArraySize];
/*     */ 
/* 100 */       System.arraycopy(this._scanM, 0, copy, 0, this._scanM.length);
/* 101 */       System.arraycopy(this._scanN, 0, copy, this._scanM.length, this._scanN.length);
/*     */ 
/* 103 */       this._scanM = copy;
/*     */     }
/*     */ 
/* 107 */     this._scanN = trans;
/*     */   }
/*     */ 
/*     */   public final Object[] toRecover()
/*     */   {
/* 121 */     int numScanN = this._scanN == null ? 0 : this._scanN.length;
/* 122 */     int numScanM = this._scanM == null ? 0 : this._scanM.length;
/* 123 */     int numScan = Math.min(numScanN, numScanM);
/*     */ 
/* 125 */     if (numScan == 0)
/*     */     {
/* 127 */       return null;
/*     */     }
/*     */ 
/* 130 */     Vector workingVector = new Vector();
/*     */ 
/* 132 */     for (int count = 0; count < numScan; count++)
/*     */     {
/* 134 */       if (!XAHelper.sameXID(this._scanN[count], this._scanM[count]))
/*     */         continue;
/* 136 */       workingVector.add(this._scanN[count]);
/*     */     }
/*     */ 
/* 140 */     return workingVector.toArray();
/*     */   }
/*     */ 
/*     */   public final boolean isSameRM(XAResource xares)
/*     */   {
/*     */     try
/*     */     {
/* 147 */       if (xares == null) {
/* 148 */         return false;
/*     */       }
/* 150 */       return xares.isSameRM(this._xares);
/*     */     }
/*     */     catch (Exception ex) {
/*     */     }
/* 154 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean contains(Xid xid)
/*     */   {
/* 160 */     if (this._scanN != null)
/*     */     {
/* 162 */       for (int i = 0; i < this._scanN.length; i++)
/*     */       {
/* 164 */         if (XAHelper.sameXID(xid, this._scanN[i])) {
/* 165 */           return true;
/*     */         }
/*     */       }
/*     */     }
/* 169 */     if (this._scanM != null)
/*     */     {
/* 171 */       for (int i = 0; i < this._scanM.length; i++)
/*     */       {
/* 173 */         if (XAHelper.sameXID(xid, this._scanM[i])) {
/* 174 */           return true;
/*     */         }
/*     */       }
/*     */     }
/* 178 */     return false;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.jta.recovery.arjunacore.RecoveryXids
 * JD-Core Version:    0.6.0
 */