/*     */ package com.arjuna.ats.internal.jdbc.recovery;
/*     */ 
/*     */ import com.arjuna.ats.jdbc.common.jdbcPropertyManager;
/*     */ import com.arjuna.ats.jdbc.logging.jdbcLogger;
/*     */ import com.arjuna.ats.jta.recovery.XAResourceRecovery;
/*     */ import com.arjuna.ats.jta.xa.RecoverableXAConnection;
/*     */ import com.arjuna.common.internal.util.propertyservice.plugins.io.XMLFilePlugin;
/*     */ import com.arjuna.common.util.FileLocator;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import com.arjuna.common.util.propertyservice.PropertyManager;
/*     */ import java.sql.SQLException;
/*     */ import java.util.Properties;
/*     */ import javax.sql.XAConnection;
/*     */ import javax.transaction.xa.XAResource;
/*     */ 
/*     */ public class BasicXARecovery
/*     */   implements XAResourceRecovery
/*     */ {
/*     */   private int numberOfConnections;
/*     */   private int connectionIndex;
/*     */   private Properties props;
/*     */   private static final String dbTag = "DB_";
/*     */   private static final String urlTag = "_DatabaseURL";
/*     */   private static final String passwordTag = "_DatabasePassword";
/*     */   private static final String userTag = "_DatabaseUser";
/*     */   private static final String dynamicClassTag = "_DatabaseDynamicClass";
/*     */   private static final String jndiTag = "JNDI_";
/*     */   private static final char BREAKCHARACTER = ';';
/*     */ 
/*     */   public BasicXARecovery()
/*     */     throws SQLException
/*     */   {
/*  88 */     if (jdbcLogger.logger.isDebugEnabled())
/*     */     {
/*  90 */       jdbcLogger.logger.debug(1L, 4L, 2048L, "BasicXARecovery ()");
/*     */     }
/*     */ 
/*  98 */     this.numberOfConnections = 1;
/*  99 */     this.connectionIndex = 0;
/* 100 */     this.props = null;
/*     */   }
/*     */ 
/*     */   public boolean initialise(String parameter)
/*     */     throws SQLException
/*     */   {
/* 114 */     if (jdbcLogger.logger.isDebugEnabled())
/*     */     {
/* 116 */       jdbcLogger.logger.debug(1L, 4L, 2048L, "BasicXARecovery.setDetail(" + parameter + ")");
/*     */     }
/*     */ 
/* 124 */     if (parameter == null) {
/* 125 */       return true;
/*     */     }
/* 127 */     int breakPosition = parameter.indexOf(';');
/* 128 */     String fileName = parameter;
/*     */ 
/* 130 */     if (breakPosition != -1)
/*     */     {
/* 132 */       fileName = parameter.substring(0, breakPosition - 1);
/*     */       try
/*     */       {
/* 136 */         this.numberOfConnections = Integer.parseInt(parameter.substring(breakPosition + 1));
/*     */       }
/*     */       catch (NumberFormatException e)
/*     */       {
/* 141 */         if (jdbcLogger.loggerI18N.isWarnEnabled())
/*     */         {
/* 143 */           jdbcLogger.loggerI18N.warn("com.arjuna.ats.internal.jdbc.recovery.basic.initexp", new Object[] { e });
/*     */         }
/*     */ 
/* 148 */         return false;
/*     */       }
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 154 */       String uri = FileLocator.locateFile(fileName);
/*     */ 
/* 156 */       jdbcPropertyManager.propertyManager.load(XMLFilePlugin.class.getName(), uri);
/*     */ 
/* 159 */       this.props = jdbcPropertyManager.propertyManager.getProperties();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 163 */       if (jdbcLogger.loggerI18N.isWarnEnabled())
/*     */       {
/* 165 */         jdbcLogger.loggerI18N.warn("com.arjuna.ats.internal.jdbc.recovery.basic.initexp", new Object[] { e });
/*     */       }
/*     */ 
/* 170 */       return false;
/*     */     }
/*     */ 
/* 173 */     if (jdbcLogger.logger.isDebugEnabled())
/*     */     {
/* 175 */       jdbcLogger.logger.debug(1L, 4L, 2048L, "BasicXARecovery properties file = " + parameter);
/*     */     }
/*     */ 
/* 183 */     return true;
/*     */   }
/*     */ 
/*     */   public synchronized XAResource getXAResource()
/*     */     throws SQLException
/*     */   {
/* 193 */     JDBC2RecoveryConnection conn = null;
/*     */ 
/* 195 */     if (hasMoreResources())
/*     */     {
/* 197 */       this.connectionIndex += 1;
/*     */ 
/* 199 */       conn = getStandardConnection();
/*     */ 
/* 201 */       if (conn == null) conn = getJNDIConnection();
/*     */ 
/* 203 */       if (conn == null)
/*     */       {
/* 205 */         if (jdbcLogger.loggerI18N.isWarnEnabled())
/*     */         {
/* 207 */           jdbcLogger.loggerI18N.warn("com.arjuna.ats.internal.jdbc.recovery.basic.xarec", new Object[] { "BasicXARecovery.getConnection -" });
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 214 */     return conn.recoveryConnection().getConnection().getXAResource();
/*     */   }
/*     */ 
/*     */   public synchronized boolean hasMoreResources()
/*     */   {
/* 220 */     return this.connectionIndex != this.numberOfConnections;
/*     */   }
/*     */ 
/*     */   private final JDBC2RecoveryConnection getStandardConnection()
/*     */     throws SQLException
/*     */   {
/* 228 */     String number = new String("" + this.connectionIndex);
/* 229 */     String url = new String("DB_" + number + "_DatabaseURL");
/* 230 */     String password = new String("DB_" + number + "_DatabasePassword");
/* 231 */     String user = new String("DB_" + number + "_DatabaseUser");
/* 232 */     String dynamicClass = new String("DB_" + number + "_DatabaseDynamicClass");
/*     */ 
/* 234 */     Properties dbProperties = new Properties();
/*     */ 
/* 236 */     String theUser = this.props.getProperty(user);
/* 237 */     String thePassword = this.props.getProperty(password);
/*     */ 
/* 239 */     if (theUser != null)
/*     */     {
/* 241 */       dbProperties.put("user", theUser);
/* 242 */       dbProperties.put("password", thePassword);
/*     */ 
/* 244 */       String dc = this.props.getProperty(dynamicClass);
/*     */ 
/* 246 */       if (dc != null) {
/* 247 */         dbProperties.put("DYNAMIC_CLASS", dc);
/*     */       }
/* 249 */       return new JDBC2RecoveryConnection(url, dbProperties);
/*     */     }
/*     */ 
/* 252 */     return null;
/*     */   }
/*     */ 
/*     */   private final JDBC2RecoveryConnection getJNDIConnection()
/*     */     throws SQLException
/*     */   {
/* 258 */     String number = new String("" + this.connectionIndex);
/* 259 */     String url = new String("DB_JNDI_" + number + "_DatabaseURL");
/* 260 */     String password = new String("DB_JNDI_" + number + "_DatabasePassword");
/* 261 */     String user = new String("DB_JNDI_" + number + "_DatabaseUser");
/*     */ 
/* 263 */     Properties dbProperties = new Properties();
/*     */ 
/* 265 */     String theUser = this.props.getProperty(user);
/* 266 */     String thePassword = this.props.getProperty(password);
/*     */ 
/* 268 */     if (theUser != null)
/*     */     {
/* 270 */       dbProperties.put("user", theUser);
/* 271 */       dbProperties.put("password", thePassword);
/*     */ 
/* 273 */       return new JDBC2RecoveryConnection(url, dbProperties);
/*     */     }
/*     */ 
/* 276 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.jdbc.recovery.BasicXARecovery
 * JD-Core Version:    0.6.0
 */