/*     */ package com.arjuna.ats.internal.jdbc.drivers.modifiers;
/*     */ 
/*     */ import com.arjuna.ats.jta.exceptions.NotImplementedException;
/*     */ import com.arjuna.ats.jta.xa.XAModifier;
/*     */ import com.arjuna.ats.jta.xa.XidImple;
/*     */ import java.sql.Connection;
/*     */ import java.sql.SQLException;
/*     */ import javax.sql.XAConnection;
/*     */ import javax.transaction.SystemException;
/*     */ import javax.transaction.Transaction;
/*     */ import javax.transaction.xa.Xid;
/*     */ import oracle.jdbc.xa.OracleXid;
/*     */ 
/*     */ public class oracle_jndi
/*     */   implements XAModifier, ConnectionModifier
/*     */ {
/* 130 */   private boolean _reuseConnection = false;
/*     */ 
/*     */   public String initialise(String dbName)
/*     */   {
/*  60 */     int index = dbName.indexOf("reuseconnection=true");
/*  61 */     int end = "reuseconnection=true".length();
/*     */ 
/*  63 */     if (index != -1) {
/*  64 */       this._reuseConnection = false;
/*     */     }
/*     */     else {
/*  67 */       index = dbName.indexOf("reuseconnection=false");
/*  68 */       end = "reuseconnection=false".length();
/*     */     }
/*     */ 
/*  75 */     if (index != 0) {
/*  76 */       return dbName;
/*     */     }
/*  78 */     return dbName.substring(end + 1);
/*     */   }
/*     */ 
/*     */   public Xid createXid(XidImple xid) throws SQLException, NotImplementedException
/*     */   {
/*     */     try
/*     */     {
/*  85 */       return new OracleXid(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */     }
/*  90 */     throw new SQLException(e.toString());
/*     */   }
/*     */ 
/*     */   public int xaStartParameters(int level)
/*     */     throws SQLException, NotImplementedException
/*     */   {
/*  96 */     return level;
/*     */   }
/*     */ 
/*     */   public XAConnection getConnection(XAConnection conn)
/*     */     throws SQLException, NotImplementedException
/*     */   {
/* 102 */     return null;
/*     */   }
/*     */ 
/*     */   public boolean supportsMultipleConnections() throws SQLException, NotImplementedException
/*     */   {
/* 107 */     return true;
/*     */   }
/*     */ 
/*     */   public void setIsolationLevel(Connection conn, int level)
/*     */     throws SQLException, NotImplementedException
/*     */   {
/* 113 */     javax.transaction.TransactionManager tm = com.arjuna.ats.jta.TransactionManager.transactionManager();
/* 114 */     Transaction tx = null;
/*     */     try
/*     */     {
/* 118 */       tx = tm.getTransaction();
/*     */     }
/*     */     catch (SystemException se)
/*     */     {
/*     */     }
/*     */ 
/* 125 */     if ((tx != null) && (conn.getTransactionIsolation() != level))
/* 126 */       conn.setTransactionIsolation(level);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.jdbc.drivers.modifiers.oracle_jndi
 * JD-Core Version:    0.6.0
 */