/*     */ package com.arjuna.ats.internal.jdbc;
/*     */ 
/*     */ import com.arjuna.ats.jdbc.logging.jdbcLogger;
/*     */ import java.sql.CallableStatement;
/*     */ import java.sql.Connection;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.Savepoint;
/*     */ import java.sql.Statement;
/*     */ import java.util.Properties;
/*     */ import java.util.ResourceBundle;
/*     */ 
/*     */ public class ConnectionImpleJDBC3 extends ConnectionImple
/*     */   implements Connection
/*     */ {
/*     */   public ConnectionImpleJDBC3(String dbName, Properties info)
/*     */     throws SQLException
/*     */   {
/*  37 */     super(dbName, info);
/*     */   }
/*     */ 
/*     */   public void setHoldability(int holdability) throws SQLException
/*     */   {
/*  42 */     checkTransaction();
/*     */ 
/*  44 */     registerDatabase();
/*     */ 
/*  46 */     getConnection().setHoldability(holdability);
/*     */   }
/*     */ 
/*     */   public int getHoldability() throws SQLException
/*     */   {
/*  51 */     return getConnection().getHoldability();
/*     */   }
/*     */ 
/*     */   public Savepoint setSavepoint()
/*     */     throws SQLException
/*     */   {
/*  63 */     if (transactionRunning())
/*     */     {
/*  65 */       throw new SQLException(jdbcLogger.logMesg.getString("com.arjuna.ats.internal.jdbc.setsavepointerror"));
/*     */     }
/*     */ 
/*  69 */     return getConnection().setSavepoint();
/*     */   }
/*     */ 
/*     */   public Savepoint setSavepoint(String name)
/*     */     throws SQLException
/*     */   {
/*  75 */     if (transactionRunning())
/*     */     {
/*  77 */       throw new SQLException(jdbcLogger.logMesg.getString("com.arjuna.ats.internal.jdbc.setsavepointerror"));
/*     */     }
/*     */ 
/*  81 */     return getConnection().setSavepoint(name);
/*     */   }
/*     */ 
/*     */   public void rollback(Savepoint savepoint)
/*     */     throws SQLException
/*     */   {
/*  90 */     if (transactionRunning())
/*     */     {
/*  92 */       throw new SQLException(jdbcLogger.logMesg.getString("com.arjuna.ats.internal.jdbc.rollbacksavepointerror"));
/*     */     }
/*     */ 
/*  96 */     getConnection().rollback(savepoint);
/*     */   }
/*     */ 
/*     */   public void releaseSavepoint(Savepoint savepoint)
/*     */     throws SQLException
/*     */   {
/* 105 */     if (transactionRunning())
/*     */     {
/* 107 */       throw new SQLException(jdbcLogger.logMesg.getString("com.arjuna.ats.internal.jdbc.releasesavepointerror"));
/*     */     }
/*     */ 
/* 111 */     getConnection().releaseSavepoint(savepoint);
/*     */   }
/*     */ 
/*     */   public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability)
/*     */     throws SQLException
/*     */   {
/* 118 */     checkTransaction();
/*     */ 
/* 120 */     registerDatabase();
/*     */ 
/* 122 */     return getConnection().createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
/*     */   }
/*     */ 
/*     */   public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability)
/*     */     throws SQLException
/*     */   {
/* 128 */     checkTransaction();
/*     */ 
/* 130 */     registerDatabase();
/*     */ 
/* 132 */     return getConnection().prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
/*     */   }
/*     */ 
/*     */   public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability)
/*     */     throws SQLException
/*     */   {
/* 138 */     checkTransaction();
/*     */ 
/* 140 */     registerDatabase();
/*     */ 
/* 142 */     return getConnection().prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
/*     */   }
/*     */ 
/*     */   public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys)
/*     */     throws SQLException
/*     */   {
/* 148 */     checkTransaction();
/*     */ 
/* 150 */     registerDatabase();
/*     */ 
/* 152 */     return getConnection().prepareStatement(sql, autoGeneratedKeys);
/*     */   }
/*     */ 
/*     */   public PreparedStatement prepareStatement(String sql, int[] columnIndexes)
/*     */     throws SQLException
/*     */   {
/* 158 */     checkTransaction();
/*     */ 
/* 160 */     registerDatabase();
/*     */ 
/* 162 */     return getConnection().prepareStatement(sql, columnIndexes);
/*     */   }
/*     */ 
/*     */   public PreparedStatement prepareStatement(String sql, String[] columnNames)
/*     */     throws SQLException
/*     */   {
/* 168 */     checkTransaction();
/*     */ 
/* 170 */     registerDatabase();
/*     */ 
/* 172 */     return getConnection().prepareStatement(sql, columnNames);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.jdbc.ConnectionImpleJDBC3
 * JD-Core Version:    0.6.0
 */