/*     */ package com.arjuna.ats.internal.jbossatx.agent;
/*     */ 
/*     */ import com.arjuna.ats.tsmx.agent.AgentInterface;
/*     */ import com.arjuna.ats.tsmx.agent.exceptions.AgentNotFoundException;
/*     */ import java.io.IOException;
/*     */ import java.io.PrintStream;
/*     */ import java.io.PrintWriter;
/*     */ import java.lang.reflect.InvocationHandler;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Proxy;
/*     */ import java.util.Hashtable;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NamingException;
/*     */ import org.jboss.jmx.adaptor.rmi.RMIAdaptor;
/*     */ 
/*     */ public class JBossAgentImpl
/*     */   implements AgentInterface
/*     */ {
/*  52 */   private MBeanServer _server = null;
/*     */ 
/*  56 */   public JBossAgentImpl() { String providerUrl = System.getProperty("java.naming.provider.url", "jnp://localhost:1099");
/*  57 */     Hashtable env = new Hashtable();
/*  58 */     env.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
/*  59 */     env.put("java.naming.provider.url", providerUrl);
/*  60 */     env.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
/*     */     InitialContext ctx;
/*     */     try { ctx = new InitialContext(env);
/*     */     }
/*     */     catch (NamingException ne)
/*     */     {
/*  68 */       throw new ExceptionInInitializerError("Failed to initialize naming context: " + ne);
/*     */     }
/*     */ 
/*  71 */     RMIAdaptor adaptor = null;
/*     */     try
/*     */     {
/*  74 */       adaptor = (RMIAdaptor)ctx.lookup("jmx/rmi/RMIAdaptor");
/*     */     }
/*     */     catch (NamingException ne)
/*     */     {
/*     */       try
/*     */       {
/*  80 */         adaptor = (RMIAdaptor)ctx.lookup("jmx/invoker/RMIAdaptor");
/*     */       }
/*     */       catch (NamingException ne2)
/*     */       {
/*  84 */         throw new ExceptionInInitializerError("Failed to retrieve reference to remote MBean server: " + ne2);
/*     */       }
/*     */     }
/*     */ 
/*  88 */     Class serverClass = MBeanServer.class;
/*  89 */     this._server = ((MBeanServer)Proxy.newProxyInstance(serverClass.getClassLoader(), new Class[] { serverClass }, new RemoteInvocationHandler(adaptor)));
/*     */   }
/*     */ 
/*     */   public MBeanServer getAgent()
/*     */     throws AgentNotFoundException
/*     */   {
/*  95 */     if (this._server == null) {
/*  96 */       throw new AgentNotFoundException("Failed to lookup JBOSS agent");
/*     */     }
/*  98 */     return this._server;
/*     */   }
/*     */ 
/*     */   public static class RuntimeIOException extends RuntimeException
/*     */   {
/*     */     private static final long serialVersionUID = 3976733670713669941L;
/*     */     private final Throwable nestedThrowable;
/*     */ 
/*     */     public RuntimeIOException(Throwable nestedThrowable)
/*     */     {
/* 190 */       this.nestedThrowable = nestedThrowable;
/*     */     }
/*     */ 
/*     */     public String getLocalizedMessage()
/*     */     {
/* 199 */       return this.nestedThrowable.getLocalizedMessage();
/*     */     }
/*     */ 
/*     */     public String getMessage()
/*     */     {
/* 208 */       return this.nestedThrowable.getMessage();
/*     */     }
/*     */ 
/*     */     public StackTraceElement[] getStackTrace()
/*     */     {
/* 217 */       return this.nestedThrowable.getStackTrace();
/*     */     }
/*     */ 
/*     */     public void printStackTrace()
/*     */     {
/* 225 */       this.nestedThrowable.printStackTrace();
/*     */     }
/*     */ 
/*     */     public void printStackTrace(PrintStream ps)
/*     */     {
/* 234 */       this.nestedThrowable.printStackTrace(ps);
/*     */     }
/*     */ 
/*     */     public void printStackTrace(PrintWriter pw)
/*     */     {
/* 243 */       this.nestedThrowable.printStackTrace(pw);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class RemoteInvocationHandler
/*     */     implements InvocationHandler
/*     */   {
/* 111 */     private static final Class ADAPTOR_CLASS = RMIAdaptor.class;
/*     */     private final RMIAdaptor adaptor;
/*     */ 
/*     */     public RemoteInvocationHandler(RMIAdaptor adaptor)
/*     */     {
/* 125 */       this.adaptor = adaptor;
/*     */     }
/*     */ 
/*     */     public Object invoke(Object proxy, Method method, Object[] args) throws Throwable
/*     */     {
/* 140 */       String methodName = method.getName();
/*     */       Method adaptorMethod;
/*     */       try {
/* 144 */         adaptorMethod = ADAPTOR_CLASS.getMethod(methodName, method.getParameterTypes());
/*     */       }
/*     */       catch (NoSuchMethodException nsme)
/*     */       {
/* 149 */         throw new UnsupportedOperationException("Operation " + methodName + " not supported with remote proxy");
/*     */       }
/*     */       Throwable target;
/*     */       try
/*     */       {
/* 155 */         return adaptorMethod.invoke(this.adaptor, args);
/*     */       }
/*     */       catch (InvocationTargetException ite)
/*     */       {
/* 159 */         target = ite.getTargetException();
/* 160 */         if ((target instanceof IOException))
/*     */         {
/* 162 */           throw new JBossAgentImpl.RuntimeIOException(target);
/*     */         }
/*     */       }
/* 164 */       throw target;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.jbossatx.agent.JBossAgentImpl
 * JD-Core Version:    0.6.0
 */