/*     */ package com.arjuna.ats.internal.arjuna.thread;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.coordinator.BasicAction;
/*     */ import com.arjuna.ats.arjuna.utils.ThreadUtil;
/*     */ import java.util.ArrayList;
/*     */ import java.util.EmptyStackException;
/*     */ import java.util.NoSuchElementException;
/*     */ import java.util.Stack;
/*     */ 
/*     */ public class ThreadActionData
/*     */ {
/* 304 */   private static ThreadLocal _threadList = new ThreadLocal();
/*     */ 
/* 306 */   private static ArrayList _threadSetups = new ArrayList();
/*     */ 
/*     */   public static BasicAction currentAction()
/*     */   {
/*  58 */     setup();
/*  59 */     Stack txs = (Stack)_threadList.get();
/*     */ 
/*  61 */     if (txs != null)
/*     */     {
/*     */       try
/*     */       {
/*  65 */         return (BasicAction)txs.peek();
/*     */       }
/*     */       catch (EmptyStackException e)
/*     */       {
/*     */       }
/*     */     }
/*     */ 
/*  72 */     return null;
/*     */   }
/*     */ 
/*     */   public static void pushAction(BasicAction a)
/*     */   {
/*  77 */     pushAction(a, true);
/*     */   }
/*     */ 
/*     */   public static void pushAction(BasicAction a, boolean register)
/*     */   {
/*  88 */     Thread t = Thread.currentThread();
/*  89 */     Stack txs = (Stack)_threadList.get();
/*     */ 
/*  91 */     if (txs == null)
/*     */     {
/*  93 */       txs = new Stack();
/*  94 */       txs.push(a);
/*     */ 
/*  96 */       _threadList.set(txs);
/*     */     }
/*     */     else {
/*  99 */       txs.push(a);
/*     */     }
/* 101 */     if (register)
/* 102 */       a.addChildThread(t);
/*     */   }
/*     */ 
/*     */   public static void restoreActions(BasicAction act)
/*     */   {
/* 111 */     purgeActions();
/*     */ 
/* 113 */     if (act != null)
/*     */     {
/* 119 */       Stack s = new Stack();
/* 120 */       BasicAction nextLevel = act.parent();
/*     */ 
/* 122 */       s.push(act);
/*     */ 
/* 124 */       while (nextLevel != null)
/*     */       {
/* 126 */         s.push(nextLevel);
/*     */ 
/* 128 */         nextLevel = nextLevel.parent();
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 137 */         while (!s.empty())
/*     */         {
/* 139 */           pushAction((BasicAction)s.pop());
/*     */         }
/*     */       }
/*     */       catch (Exception ex)
/*     */       {
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static BasicAction popAction() throws EmptyStackException
/*     */   {
/* 150 */     return popAction(ThreadUtil.getThreadId(), true);
/*     */   }
/*     */ 
/*     */   public static BasicAction popAction(boolean unregister)
/*     */     throws EmptyStackException
/*     */   {
/* 156 */     return popAction(ThreadUtil.getThreadId(), unregister);
/*     */   }
/*     */ 
/*     */   public static BasicAction popAction(String threadId)
/*     */     throws EmptyStackException
/*     */   {
/* 162 */     return popAction(threadId, true);
/*     */   }
/*     */ 
/*     */   public static BasicAction popAction(String threadId, boolean unregister)
/*     */     throws EmptyStackException
/*     */   {
/* 173 */     Stack txs = (Stack)_threadList.get();
/*     */ 
/* 175 */     if (txs != null)
/*     */     {
/* 177 */       BasicAction a = (BasicAction)txs.pop();
/*     */ 
/* 179 */       if ((a != null) && (unregister))
/*     */       {
/* 181 */         a.removeChildThread(threadId);
/*     */       }
/*     */ 
/* 184 */       if (txs.size() == 0)
/*     */       {
/* 186 */         _threadList.set(null);
/*     */       }
/*     */ 
/* 189 */       return a;
/*     */     }
/*     */ 
/* 192 */     return null;
/*     */   }
/*     */ 
/*     */   public static void purgeAction(BasicAction act)
/*     */     throws NoSuchElementException
/*     */   {
/* 198 */     purgeAction(act, Thread.currentThread(), true);
/*     */   }
/*     */ 
/*     */   public static void purgeAction(BasicAction act, Thread t)
/*     */     throws NoSuchElementException
/*     */   {
/* 204 */     purgeAction(act, t, true);
/*     */   }
/*     */ 
/*     */   public static void purgeAction(BasicAction act, Thread t, boolean unregister)
/*     */     throws NoSuchElementException
/*     */   {
/* 210 */     if ((act != null) && (unregister))
/*     */     {
/* 212 */       act.removeChildThread(ThreadUtil.getThreadId(t));
/*     */     }
/*     */ 
/* 215 */     Stack txs = (Stack)_threadList.get();
/*     */ 
/* 217 */     if (txs != null)
/*     */     {
/* 219 */       txs.removeElement(act);
/*     */ 
/* 221 */       if (txs.size() == 0)
/*     */       {
/* 223 */         _threadList.set(null);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void purgeActions()
/*     */   {
/* 230 */     purgeActions(Thread.currentThread(), true);
/*     */   }
/*     */ 
/*     */   public static void purgeActions(Thread t)
/*     */   {
/* 235 */     purgeActions(t, true);
/*     */   }
/*     */ 
/*     */   public static void purgeActions(Thread t, boolean unregister)
/*     */   {
/* 240 */     Stack txs = (Stack)_threadList.get();
/*     */ 
/* 242 */     _threadList.set(null);
/*     */ 
/* 244 */     if (txs != null)
/*     */     {
/* 246 */       if (unregister)
/*     */       {
/* 248 */         while (!txs.empty())
/*     */         {
/* 250 */           BasicAction act = (BasicAction)txs.pop();
/*     */ 
/* 252 */           if (act != null)
/*     */           {
/* 254 */             act.removeChildThread(ThreadUtil.getThreadId(t));
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void addSetup(ThreadSetup s)
/*     */   {
/* 271 */     synchronized (_threadSetups)
/*     */     {
/* 273 */       _threadSetups.add(s);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static boolean removeSetup(ThreadSetup s)
/*     */   {
/* 287 */     synchronized (_threadSetups)
/*     */     {
/* 289 */       return _threadSetups.remove(s);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static void setup()
/*     */   {
/* 295 */     for (int i = 0; i < _threadSetups.size(); i++)
/*     */     {
/* 297 */       ThreadSetup s = (ThreadSetup)_threadSetups.get(i);
/*     */ 
/* 299 */       if (s != null)
/* 300 */         s.setup();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.arjuna.thread.ThreadActionData
 * JD-Core Version:    0.6.0
 */