/*     */ package com.arjuna.ats.internal.arjuna.template;
/*     */ 
/*     */ public class SimpleList
/*     */ {
/*     */   protected SimpleListEntry head_;
/*     */   protected int entryCount;
/*     */ 
/*     */   public SimpleList()
/*     */   {
/*  51 */     this.head_ = null;
/*  52 */     this.entryCount = 0;
/*     */   }
/*     */ 
/*     */   public void finalize()
/*     */   {
/*  57 */     empty();
/*     */   }
/*     */ 
/*     */   public synchronized void empty()
/*     */   {
/*  66 */     ListElement te = null;
/*     */ 
/*  68 */     while ((te = orderedPop()) != null);
/*     */   }
/*     */ 
/*     */   public synchronized ListElement head()
/*     */   {
/*  79 */     if (this.head_ != null) {
/*  80 */       return this.head_.theData;
/*     */     }
/*  82 */     return null;
/*     */   }
/*     */ 
/*     */   public synchronized int size()
/*     */   {
/*  91 */     return this.entryCount;
/*     */   }
/*     */ 
/*     */   public synchronized boolean lookFor(ListElement th)
/*     */   {
/* 101 */     if (th != null)
/*     */     {
/* 103 */       SimpleListEntry te = this.head_;
/*     */ 
/* 105 */       while (te != null)
/*     */       {
/* 109 */         if ((te.theData == th) || (te.equals(th)))
/*     */         {
/* 112 */           return true;
/*     */         }
/*     */ 
/* 115 */         te = te.next;
/*     */       }
/*     */     }
/*     */ 
/* 119 */     return false;
/*     */   }
/*     */ 
/*     */   public synchronized boolean push(ListElement th)
/*     */   {
/* 128 */     if (th != null)
/*     */     {
/* 130 */       SimpleListEntry te = new SimpleListEntry(this.head_, th);
/*     */ 
/* 132 */       this.head_ = te;
/* 133 */       this.entryCount += 1;
/*     */ 
/* 135 */       return true;
/*     */     }
/*     */ 
/* 138 */     return false;
/*     */   }
/*     */ 
/*     */   public synchronized boolean add(ListElement th)
/*     */   {
/* 148 */     return push(th);
/*     */   }
/*     */ 
/*     */   public synchronized boolean insert(ListElement th)
/*     */   {
/* 159 */     if (th != null)
/*     */     {
/* 161 */       SimpleListEntry te = this.head_;
/*     */ 
/* 163 */       while (te != null)
/*     */       {
/* 167 */         if (th == te)
/*     */         {
/* 169 */           return false;
/*     */         }
/*     */ 
/* 172 */         te = te.next;
/*     */       }
/*     */ 
/* 177 */       te = new SimpleListEntry(this.head_, th);
/*     */ 
/* 179 */       this.head_ = te;
/* 180 */       this.entryCount += 1;
/*     */ 
/* 182 */       return true;
/*     */     }
/*     */ 
/* 185 */     return false;
/*     */   }
/*     */ 
/*     */   public synchronized boolean remove(ListElement findMe)
/*     */   {
/* 195 */     SimpleListEntry te = this.head_;
/* 196 */     SimpleListEntry old = null;
/*     */ 
/* 198 */     while (te != null)
/*     */     {
/* 200 */       if (te.theData == findMe)
/*     */       {
/* 202 */         if (old == null)
/* 203 */           this.head_ = te.next;
/*     */         else {
/* 205 */           old.next = te.next;
/*     */         }
/* 207 */         te = null;
/* 208 */         this.entryCount -= 1;
/*     */ 
/* 210 */         return true;
/*     */       }
/*     */ 
/* 213 */       old = te;
/* 214 */       te = te.next;
/*     */     }
/*     */ 
/* 217 */     return false;
/*     */   }
/*     */ 
/*     */   public synchronized ListElement orderedPop()
/*     */   {
/* 226 */     ListElement th = null;
/*     */ 
/* 228 */     if (this.head_ != null)
/*     */     {
/* 230 */       SimpleListEntry te = this.head_;
/*     */ 
/* 232 */       this.head_ = te.next;
/* 233 */       th = te.theData;
/* 234 */       this.entryCount -= 1;
/*     */ 
/* 236 */       te = null;
/*     */     }
/*     */ 
/* 239 */     return th;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.arjuna.template.SimpleList
 * JD-Core Version:    0.6.0
 */