/*     */ package com.arjuna.ats.internal.arjuna.template;
/*     */ 
/*     */ public class OrderedList
/*     */ {
/*     */   private OrderedListEntry _headOfList;
/*     */   private long _entryCount;
/*     */   private boolean _increasing;
/*     */ 
/*     */   public OrderedList()
/*     */   {
/*  57 */     this(true);
/*     */   }
/*     */ 
/*     */   public OrderedList(boolean increasing)
/*     */   {
/*  67 */     this._headOfList = null;
/*  68 */     this._entryCount = 0L;
/*  69 */     this._increasing = increasing;
/*     */   }
/*     */ 
/*     */   public void finalize()
/*     */   {
/*  74 */     empty();
/*     */   }
/*     */ 
/*     */   public final synchronized boolean insert(OrderedListElement p)
/*     */   {
/*  84 */     return insert(p, false);
/*     */   }
/*     */ 
/*     */   public final synchronized boolean insert(OrderedListElement p, boolean prior)
/*     */   {
/*  95 */     if (p == null) {
/*  96 */       return false;
/*     */     }
/*     */ 
/* 100 */     if (this._entryCount == 0L)
/*     */     {
/* 102 */       this._headOfList = new OrderedListEntry(p, this._headOfList);
/* 103 */       this._entryCount += 1L;
/*     */ 
/* 105 */       return true;
/*     */     }
/*     */ 
/* 110 */     OrderedListIterator iter = new OrderedListIterator(this);
/* 111 */     OrderedListElement prev = null;
/*     */ 
/* 113 */     for (OrderedListElement q = iter.iterate(); q != null; q = iter.iterate())
/*     */     {
/* 115 */       if (this._increasing)
/*     */       {
/* 117 */         if (prior)
/*     */         {
/* 119 */           if ((q.equals(p)) || (q.greaterThan(p)))
/*     */           {
/* 121 */             return insertBefore(p, q);
/*     */           }
/*     */ 
/*     */         }
/* 126 */         else if (q.greaterThan(p)) {
/* 127 */           return insertBefore(p, q);
/*     */         }
/*     */ 
/*     */       }
/* 132 */       else if (prior)
/*     */       {
/* 134 */         if ((q.equals(p)) || (q.lessThan(p)))
/*     */         {
/* 136 */           return insertBefore(p, q);
/*     */         }
/*     */ 
/*     */       }
/* 141 */       else if (q.lessThan(p))
/* 142 */         return insertBefore(p, q);
/* 113 */       prev = q;
/*     */     }
/*     */ 
/* 149 */     return insertAfter(p, prev);
/*     */   }
/*     */ 
/*     */   public final synchronized boolean insertBefore(OrderedListElement toInsert, OrderedListElement before)
/*     */   {
/* 160 */     OrderedListEntry prev = null; for (OrderedListEntry p = this._headOfList; p != null; p = p.cdr())
/*     */     {
/* 162 */       if (p.car() == before)
/*     */       {
/* 164 */         OrderedListEntry newcons = new OrderedListEntry(toInsert, p);
/*     */ 
/* 166 */         if (prev != null)
/* 167 */           prev.setfCdr(newcons);
/*     */         else {
/* 169 */           this._headOfList = newcons;
/*     */         }
/* 171 */         this._entryCount += 1L;
/*     */ 
/* 173 */         return true;
/*     */       }
/* 160 */       prev = p;
/*     */     }
/*     */ 
/* 177 */     return false;
/*     */   }
/*     */ 
/*     */   public final synchronized boolean insertAfter(OrderedListElement toInsert, OrderedListElement after)
/*     */   {
/* 188 */     for (OrderedListEntry p = this._headOfList; p != null; p = p.cdr())
/*     */     {
/* 190 */       if (p.car() != after)
/*     */         continue;
/* 192 */       OrderedListEntry newcons = new OrderedListEntry(toInsert, p.cdr());
/*     */ 
/* 194 */       p.setfCdr(newcons);
/*     */ 
/* 196 */       this._entryCount += 1L;
/*     */ 
/* 198 */       return true;
/*     */     }
/*     */ 
/* 202 */     return false;
/*     */   }
/*     */ 
/*     */   public final synchronized boolean remove(OrderedListElement element)
/*     */   {
/* 213 */     if ((this._headOfList == null) || (element == null)) {
/* 214 */       return false;
/*     */     }
/* 216 */     OrderedListEntry prev = null; for (OrderedListEntry ptr = this._headOfList; ptr != null; ptr = ptr.cdr())
/*     */     {
/* 218 */       if (ptr.car() == element)
/*     */       {
/* 222 */         if (prev != null)
/* 223 */           prev.setfCdr(ptr.cdr());
/*     */         else
/* 225 */           this._headOfList = ptr.cdr();
/* 226 */         ptr.setfCdr(null);
/*     */ 
/* 228 */         this._entryCount -= 1L;
/*     */ 
/* 230 */         return true;
/*     */       }
/* 216 */       prev = ptr;
/*     */     }
/*     */ 
/* 234 */     return false;
/*     */   }
/*     */ 
/*     */   public final synchronized OrderedListElement orderedPop()
/*     */   {
/* 243 */     if (this._headOfList != null)
/*     */     {
/* 245 */       OrderedListEntry remove = this._headOfList;
/* 246 */       OrderedListElement p = this._headOfList.car();
/*     */ 
/* 248 */       this._headOfList = remove.cdr();
/* 249 */       remove.setfCdr(null);
/* 250 */       this._entryCount -= 1L;
/*     */ 
/* 252 */       remove = null;
/*     */ 
/* 254 */       return p;
/*     */     }
/*     */ 
/* 257 */     return null;
/*     */   }
/*     */ 
/*     */   public final synchronized OrderedListElement peak()
/*     */   {
/* 262 */     if (this._headOfList != null)
/*     */     {
/* 264 */       return this._headOfList.car();
/*     */     }
/* 266 */     return null;
/*     */   }
/*     */ 
/*     */   final synchronized OrderedListEntry head()
/*     */   {
/* 271 */     return this._headOfList;
/*     */   }
/*     */ 
/*     */   public final synchronized void empty()
/*     */   {
/*     */     OrderedListElement te;
/* 282 */     while ((te = orderedPop()) != null)
/*     */     {
/* 284 */       te = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   public final synchronized long size()
/*     */   {
/* 294 */     return this._entryCount;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.arjuna.template.OrderedList
 * JD-Core Version:    0.6.0
 */