/*    */ package com.arjuna.ats.internal.arjuna.template;
/*    */ 
/*    */ public class HashListIterator
/*    */ {
/*    */   private HashList theList;
/*    */   private BasicListIterator iter;
/*    */   private int lastBucket;
/*    */ 
/*    */   public HashListIterator(HashList list)
/*    */   {
/* 52 */     this.theList = list;
/* 53 */     this.iter = null;
/* 54 */     this.lastBucket = -1;
/*    */   }
/*    */ 
/*    */   public void finalize()
/*    */   {
/* 59 */     this.iter = null;
/*    */   }
/*    */ 
/*    */   public synchronized ListElement iterate()
/*    */   {
/* 68 */     ListElement th = null;
/*    */ 
/* 75 */     if (this.iter != null) {
/* 76 */       th = this.iter.iterate();
/*    */     }
/* 78 */     if (th != null) {
/* 79 */       return th;
/*    */     }
/* 81 */     this.iter = null;
/*    */ 
/* 83 */     this.lastBucket += 1;
/*    */ 
/* 85 */     while ((this.lastBucket < this.theList.maxBucket) && ((this.theList.buckets[this.lastBucket] == null) || (this.theList.buckets[this.lastBucket].size() == 0)))
/*    */     {
/* 88 */       this.lastBucket += 1;
/*    */     }
/* 90 */     if (this.lastBucket < this.theList.maxBucket) {
/* 91 */       this.iter = new BasicListIterator(this.theList.buckets[this.lastBucket]);
/*    */     }
/* 93 */     if (this.iter != null) {
/* 94 */       th = this.iter.iterate();
/*    */     }
/* 96 */     return th;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.arjuna.template.HashListIterator
 * JD-Core Version:    0.6.0
 */