/*     */ package com.arjuna.ats.internal.arjuna.template;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ 
/*     */ public class HashList
/*     */ {
/*     */   protected BasicList[] buckets;
/*     */   protected int maxBucket;
/*     */ 
/*     */   public HashList(int hashBucket)
/*     */   {
/*  55 */     this.maxBucket = hashBucket;
/*  56 */     this.buckets = new BasicList[hashBucket];
/*     */ 
/*  58 */     for (int i = 0; i < hashBucket; i++)
/*  59 */       this.buckets[i] = null;
/*     */   }
/*     */ 
/*     */   public void finalize()
/*     */   {
/*  64 */     empty();
/*     */ 
/*  66 */     this.buckets = null;
/*     */   }
/*     */ 
/*     */   public synchronized void empty()
/*     */   {
/*  75 */     for (int i = 0; i < this.maxBucket; i++)
/*  76 */       if (this.buckets[i] != null)
/*  77 */         this.buckets[i] = null;
/*     */   }
/*     */ 
/*     */   public synchronized int size()
/*     */   {
/*  86 */     int rVal = 0;
/*     */ 
/*  88 */     for (int i = 0; i < this.maxBucket; i++)
/*     */     {
/*  90 */       if (this.buckets[i] == null)
/*     */         continue;
/*  92 */       rVal += this.buckets[i].size();
/*     */     }
/*     */ 
/*  96 */     return rVal;
/*     */   }
/*     */ 
/*     */   public synchronized boolean add(ListElement th)
/*     */   {
/* 106 */     if (th != null)
/*     */     {
/* 108 */       int entry = th.get_uid().hashCode() % this.maxBucket;
/*     */ 
/* 110 */       if (this.buckets[entry] == null) {
/* 111 */         this.buckets[entry] = new BasicList();
/*     */       }
/* 113 */       return this.buckets[entry].add(th);
/*     */     }
/*     */ 
/* 116 */     return false;
/*     */   }
/*     */ 
/*     */   public synchronized boolean insert(ListElement th)
/*     */   {
/* 126 */     if (th != null)
/*     */     {
/* 128 */       int entry = th.get_uid().hashCode() % this.maxBucket;
/*     */ 
/* 130 */       if (this.buckets[entry] != null) {
/* 131 */         return this.buckets[entry].insert(th);
/*     */       }
/*     */ 
/* 134 */       this.buckets[entry] = new BasicList();
/* 135 */       return this.buckets[entry].add(th);
/*     */     }
/*     */ 
/* 139 */     return false;
/*     */   }
/*     */ 
/*     */   public synchronized boolean remove(ListElement findMe)
/*     */   {
/* 149 */     if (findMe != null)
/*     */     {
/* 151 */       int entry = findMe.get_uid().hashCode() % this.maxBucket;
/*     */ 
/* 153 */       if (this.buckets[entry] != null) {
/* 154 */         return this.buckets[entry].remove(findMe);
/*     */       }
/*     */     }
/* 157 */     return false;
/*     */   }
/*     */ 
/*     */   public synchronized ListElement remove(Uid findMe)
/*     */   {
/* 166 */     int entry = findMe.hashCode() % this.maxBucket;
/*     */ 
/* 168 */     if (this.buckets[entry] != null) {
/* 169 */       return this.buckets[entry].remove(findMe);
/*     */     }
/* 171 */     return null;
/*     */   }
/*     */ 
/*     */   public synchronized ListElement lookFor(Uid findMe)
/*     */   {
/* 180 */     int entry = findMe.hashCode() % this.maxBucket;
/*     */ 
/* 182 */     if (this.buckets[entry] != null) {
/* 183 */       return this.buckets[entry].lookFor(findMe);
/*     */     }
/* 185 */     return null;
/*     */   }
/*     */ 
/*     */   public synchronized ListElement orderedPop()
/*     */   {
/* 194 */     ListElement th = null;
/*     */ 
/* 196 */     for (int i = 0; (i < this.maxBucket) && (th != null); i++)
/*     */     {
/* 198 */       if ((this.buckets[i] == null) || (this.buckets[i].size() <= 0))
/*     */         continue;
/* 200 */       th = this.buckets[i].orderedPop();
/*     */     }
/*     */ 
/* 204 */     return th;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.arjuna.template.HashList
 * JD-Core Version:    0.6.0
 */