/*     */ package com.arjuna.ats.internal.arjuna.recovery;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.ats.arjuna.recovery.Service;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import java.io.BufferedReader;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.InputStreamReader;
/*     */ import java.io.OutputStream;
/*     */ import java.io.OutputStreamWriter;
/*     */ import java.io.PrintWriter;
/*     */ 
/*     */ public class WorkerService
/*     */   implements Service
/*     */ {
/* 118 */   private PeriodicRecovery _periodicRecovery = null;
/*     */ 
/*     */   public WorkerService(PeriodicRecovery pr)
/*     */   {
/*  51 */     this._periodicRecovery = pr;
/*     */   }
/*     */ 
/*     */   public synchronized void doWork(InputStream is, OutputStream os) throws IOException
/*     */   {
/*  56 */     BufferedReader in = new BufferedReader(new InputStreamReader(is));
/*  57 */     PrintWriter out = new PrintWriter(new OutputStreamWriter(os));
/*     */     try
/*     */     {
/*  61 */       String request = in.readLine();
/*     */ 
/*  63 */       if (request.equals("PING"))
/*     */       {
/*  65 */         out.println("PONG");
/*     */       }
/*  68 */       else if ((request.equals("SCAN")) || (request.equals("ASYNC_SCAN")))
/*     */       {
/*  70 */         this._periodicRecovery.interrupt();
/*     */ 
/*  72 */         tsLogger.arjLogger.info("com.arjuna.ats.internal.arjuna.recovery.WorkerService_3");
/*     */ 
/*  74 */         if (request.equals("SCAN"))
/*     */         {
/*     */           try
/*     */           {
/*  78 */             wait();
/*     */           }
/*     */           catch (Exception ex)
/*     */           {
/*  82 */             tsLogger.arjLogger.info("com.arjuna.ats.internal.arjuna.recovery.WorkerService_4");
/*     */           }
/*     */         }
/*     */ 
/*  86 */         out.println("DONE");
/*     */       }
/*     */       else {
/*  89 */         out.println("ERROR");
/*     */       }
/*  91 */       out.flush();
/*     */     }
/*     */     catch (IOException ex)
/*     */     {
/*  95 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*  96 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.WorkerService_2");
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 100 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */       {
/* 102 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.WorkerService_1", new Object[] { ex });
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized void signalDone()
/*     */   {
/*     */     try
/*     */     {
/* 111 */       notifyAll();
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.arjuna.recovery.WorkerService
 * JD-Core Version:    0.6.0
 */