/*     */ package com.arjuna.ats.internal.arjuna.recovery;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.coordinator.TxControl;
/*     */ import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.ats.arjuna.objectstore.ObjectStore;
/*     */ import com.arjuna.ats.arjuna.state.InputObjectState;
/*     */ import com.arjuna.ats.arjuna.state.OutputObjectState;
/*     */ import com.arjuna.ats.arjuna.utils.Utility;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import java.io.IOException;
/*     */ import java.net.InetAddress;
/*     */ import java.net.UnknownHostException;
/*     */ import java.util.Date;
/*     */ 
/*     */ public class TransactionStatusManagerItem
/*     */ {
/*     */   private Uid _pidUid;
/* 360 */   private static String _typeName = "/Recovery/TransactionStatusManager";
/*     */   private String _host;
/*     */   private int _port;
/* 367 */   private static ObjectStore _objectStore = null;
/*     */ 
/* 370 */   private static TransactionStatusManagerItem _singularItem = null;
/*     */ 
/* 373 */   private Date _deadTime = null;
/*     */ 
/* 376 */   private boolean _markedDead = false;
/*     */ 
/*     */   public static boolean createAndSave(int port)
/*     */   {
/*  67 */     boolean ret_status = true;
/*     */ 
/*  69 */     if (_singularItem == null)
/*     */     {
/*  71 */       _singularItem = new TransactionStatusManagerItem(port);
/*     */ 
/*  73 */       ret_status = _singularItem.saveThis();
/*     */     }
/*  75 */     return ret_status;
/*     */   }
/*     */ 
/*     */   public static ObjectStore getStore()
/*     */   {
/*  83 */     if (_objectStore == null)
/*     */     {
/*  85 */       _objectStore = TxControl.getStore();
/*     */     }
/*  87 */     return _objectStore;
/*     */   }
/*     */ 
/*     */   public String host()
/*     */   {
/*  95 */     return this._host;
/*     */   }
/*     */ 
/*     */   public int port()
/*     */   {
/* 103 */     return this._port;
/*     */   }
/*     */ 
/*     */   public void markAsDead()
/*     */   {
/* 112 */     if (!this._markedDead)
/*     */     {
/* 115 */       this._markedDead = true;
/* 116 */       this._deadTime = new Date();
/* 117 */       saveThis();
/*     */     }
/*     */   }
/*     */ 
/*     */   public Date getDeadTime()
/*     */   {
/* 126 */     return this._deadTime;
/*     */   }
/*     */ 
/*     */   public static TransactionStatusManagerItem get()
/*     */   {
/* 134 */     return _singularItem;
/*     */   }
/*     */ 
/*     */   public static TransactionStatusManagerItem recreate(Uid uid)
/*     */   {
/* 145 */     TransactionStatusManagerItem theItem = new TransactionStatusManagerItem(uid);
/*     */ 
/* 147 */     if (theItem.restoreThis())
/*     */     {
/* 149 */       return theItem;
/*     */     }
/*     */ 
/* 153 */     return null;
/*     */   }
/*     */ 
/*     */   public static boolean removeThis(Uid pidUid)
/*     */   {
/* 162 */     boolean ret_status = false;
/*     */     try
/*     */     {
/* 166 */       ret_status = getStore().remove_committed(pidUid, _typeName);
/*     */     }
/*     */     catch (ObjectStoreException ex)
/*     */     {
/* 170 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */       {
/* 172 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.TransactionStatusManagerItem_1", new Object[] { ex });
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 177 */     return ret_status;
/*     */   }
/*     */ 
/*     */   public static String typeName()
/*     */   {
/* 185 */     return _typeName;
/*     */   }
/*     */ 
/*     */   private boolean restoreThis()
/*     */   {
/* 194 */     boolean ret_status = false;
/*     */     try
/*     */     {
/* 198 */       InputObjectState objstate = getStore().read_committed(this._pidUid, _typeName);
/*     */ 
/* 201 */       if (restore_state(objstate))
/*     */       {
/* 203 */         return ret_status = 1;
/*     */       }
/*     */     }
/*     */     catch (ObjectStoreException ex)
/*     */     {
/* 208 */       ret_status = false;
/*     */ 
/* 210 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */       {
/* 212 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.TransactionStatusManagerItem_2", new Object[] { ex });
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 217 */     return ret_status;
/*     */   }
/*     */ 
/*     */   private boolean restore_state(InputObjectState objstate)
/*     */   {
/* 225 */     boolean ret_status = false;
/*     */     try
/*     */     {
/* 229 */       this._host = objstate.unpackString();
/* 230 */       this._port = objstate.unpackInt();
/* 231 */       this._markedDead = objstate.unpackBoolean();
/*     */ 
/* 233 */       if (this._markedDead)
/*     */       {
/* 235 */         long deadtime = objstate.unpackLong();
/* 236 */         this._deadTime = new Date(deadtime);
/*     */       }
/*     */ 
/* 239 */       ret_status = true;
/*     */     }
/*     */     catch (IOException ex)
/*     */     {
/* 243 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */       {
/* 245 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.TransactionStatusManagerItem_3", new Object[] { ex });
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 250 */     return ret_status;
/*     */   }
/*     */ 
/*     */   private boolean save_state(OutputObjectState objstate)
/*     */   {
/* 258 */     boolean ret_status = false;
/*     */     try
/*     */     {
/* 262 */       objstate.packString(this._host);
/* 263 */       objstate.packInt(this._port);
/*     */ 
/* 265 */       objstate.packBoolean(this._markedDead);
/*     */ 
/* 267 */       if (this._markedDead)
/*     */       {
/* 269 */         objstate.packLong(this._deadTime.getTime());
/*     */       }
/*     */ 
/* 272 */       ret_status = true;
/*     */     }
/*     */     catch (IOException ex)
/*     */     {
/* 276 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */       {
/* 278 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.TransactionStatusManagerItem_2", new Object[] { ex });
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 283 */     return ret_status;
/*     */   }
/*     */ 
/*     */   private boolean saveThis()
/*     */   {
/* 292 */     boolean ret_status = false;
/*     */     try
/*     */     {
/* 296 */       OutputObjectState objstate = new OutputObjectState();
/*     */ 
/* 298 */       if (save_state(objstate))
/*     */       {
/* 300 */         ret_status = getStore().write_committed(this._pidUid, _typeName, objstate);
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (ObjectStoreException ex)
/*     */     {
/* 307 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */       {
/* 309 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.TransactionStatusManagerItem_2", new Object[] { ex });
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 314 */     return ret_status;
/*     */   }
/*     */ 
/*     */   private TransactionStatusManagerItem(int port)
/*     */   {
/* 323 */     this._pidUid = Utility.getProcessUid();
/* 324 */     this._port = port;
/*     */     try
/*     */     {
/* 328 */       this._host = InetAddress.getLocalHost().getHostAddress();
/*     */ 
/* 330 */       if (tsLogger.arjLogger.isInfoEnabled())
/*     */       {
/* 332 */         tsLogger.arjLogger.info("TransactionStatusManagerItem - host: " + this._host + " port: " + this._port);
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (UnknownHostException ex)
/*     */     {
/* 339 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */       {
/* 341 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.TransactionStatusManagerItem_4", new Object[] { ex });
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private TransactionStatusManagerItem(Uid uid)
/*     */   {
/* 353 */     this._pidUid = new Uid(uid);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.arjuna.recovery.TransactionStatusManagerItem
 * JD-Core Version:    0.6.0
 */