/*     */ package com.arjuna.ats.internal.arjuna.recovery;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.exceptions.FatalError;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.ats.arjuna.recovery.RecoveryConfiguration;
/*     */ import com.arjuna.ats.arjuna.recovery.RecoveryModule;
/*     */ import com.arjuna.ats.internal.arjuna.Implementations;
/*     */ import com.arjuna.ats.internal.arjuna.utils.SocketProcessId;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import com.arjuna.common.util.propertyservice.PropertyManagerFactory;
/*     */ import java.io.IOException;
/*     */ import java.net.ServerSocket;
/*     */ import java.util.Vector;
/*     */ 
/*     */ public class RecoveryManagerImple
/*     */ {
/*  57 */   private PeriodicRecovery _periodicRecovery = null;
/*     */ 
/*  59 */   private RecActivatorLoader _recActivatorLoader = null;
/*     */ 
/*     */   public RecoveryManagerImple(boolean threaded)
/*     */   {
/*  81 */     String rmPropertyFile = RecoveryConfiguration.recoveryManagerPropertiesFile();
/*     */     try
/*     */     {
/*  86 */       com.arjuna.ats.arjuna.common.arjPropertyManager.propertyManager = PropertyManagerFactory.getPropertyManager("com.arjuna.ats.propertymanager", "recoverymanager");
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*  92 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */       {
/*  94 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.RecoveryManagerImple_1", new Object[] { ex });
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 102 */     tsLogger.arjLogger.mergeFacilityCode(262144L);
/* 103 */     tsLogger.arjLoggerI18N.mergeFacilityCode(262144L);
/*     */ 
/* 111 */     Implementations.initialise();
/*     */ 
/* 118 */     if (activeRecoveryManager())
/*     */     {
/* 120 */       throw new FatalError("Recovery manager already active!");
/*     */     }
/*     */ 
/* 127 */     this._recActivatorLoader = new RecActivatorLoader();
/*     */ 
/* 131 */     ExpiredEntryMonitor.startUp();
/*     */ 
/* 136 */     this._periodicRecovery = new PeriodicRecovery(threaded);
/*     */     try
/*     */     {
/* 140 */       if (tsLogger.arjLogger.isInfoEnabled())
/*     */       {
/* 142 */         tsLogger.arjLoggerI18N.info("com.arjuna.ats.internal.arjuna.recovery.ready", new Object[] { new Integer(PeriodicRecovery.getServerSocket().getLocalPort()) });
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (IOException ex)
/*     */     {
/* 150 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */       {
/* 152 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.RecoveryManagerImple_2", new Object[] { ex });
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public final void scan()
/*     */   {
/* 162 */     this._periodicRecovery.doWork(false);
/*     */   }
/*     */ 
/*     */   public final void addModule(RecoveryModule module)
/*     */   {
/* 167 */     this._periodicRecovery.addModule(module);
/*     */   }
/*     */ 
/*     */   public final Vector getModules()
/*     */   {
/* 172 */     return this._periodicRecovery.getModules();
/*     */   }
/*     */ 
/*     */   public void start()
/*     */   {
/* 177 */     if (!this._periodicRecovery.isAlive())
/*     */     {
/* 179 */       this._periodicRecovery.start();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/* 185 */     this._periodicRecovery.shutdown();
/*     */   }
/*     */ 
/*     */   public void finalize()
/*     */   {
/* 194 */     stop();
/*     */   }
/*     */ 
/*     */   private final boolean activeRecoveryManager()
/*     */   {
/* 201 */     SocketProcessId socket = null;
/* 202 */     boolean active = false;
/*     */     try
/*     */     {
/* 206 */       socket = new SocketProcessId();
/*     */ 
/* 208 */       if (socket.getpid() == -1) {
/* 209 */         active = true;
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (FatalError ex)
/*     */     {
/* 215 */       active = true;
/*     */     }
/*     */ 
/* 218 */     return active;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.arjuna.recovery.RecoveryManagerImple
 * JD-Core Version:    0.6.0
 */