/*     */ package com.arjuna.ats.internal.arjuna.recovery;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.common.arjPropertyManager;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.ats.arjuna.recovery.RecoveryActivator;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import com.arjuna.common.util.propertyservice.PropertyManager;
/*     */ import java.util.Enumeration;
/*     */ import java.util.Properties;
/*     */ import java.util.Vector;
/*     */ 
/*     */ public class RecActivatorLoader
/*     */ {
/* 205 */   private static Vector _recoveryActivators = null;
/*     */ 
/*     */   public RecActivatorLoader()
/*     */   {
/*  60 */     initialise();
/*     */ 
/*  63 */     loadRecoveryActivators();
/*     */ 
/*  65 */     startRecoveryActivators();
/*     */   }
/*     */ 
/*     */   public void startRecoveryActivators()
/*     */   {
/*  76 */     if (tsLogger.arjLogger.isInfoEnabled())
/*     */     {
/*  78 */       tsLogger.arjLogger.info("\n  --- Start RecoveryActivators ");
/*     */     }
/*     */ 
/*  81 */     Enumeration activators = _recoveryActivators.elements();
/*     */ 
/*  83 */     while (activators.hasMoreElements())
/*     */     {
/*  85 */       RecoveryActivator acti = (RecoveryActivator)activators.nextElement();
/*  86 */       acti.startRCservice();
/*     */     }
/*     */   }
/*     */ 
/*     */   private static void loadRecoveryActivators()
/*     */   {
/*  96 */     Properties properties = arjPropertyManager.propertyManager.getProperties();
/*     */ 
/*  98 */     if (properties != null)
/*     */     {
/* 100 */       Vector activatorNames = new Vector();
/* 101 */       Enumeration names = properties.propertyNames();
/*     */ 
/* 103 */       while (names.hasMoreElements())
/*     */       {
/* 105 */         String attrName = (String)names.nextElement();
/*     */ 
/* 107 */         if (attrName.startsWith("com.arjuna.ats.arjuna.recovery.recoveryActivator"))
/*     */         {
/* 110 */           int position = 0;
/*     */ 
/* 112 */           while ((position < activatorNames.size()) && (attrName.compareTo((String)activatorNames.elementAt(position)) > 0))
/*     */           {
/* 114 */             position++;
/*     */           }
/* 116 */           activatorNames.add(position, attrName);
/*     */         }
/*     */       }
/*     */ 
/* 120 */       names = activatorNames.elements();
/*     */ 
/* 122 */       while (names.hasMoreElements())
/*     */       {
/* 124 */         String attrName = (String)names.nextElement();
/* 125 */         loadActivator(properties.getProperty(attrName));
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private static void loadActivator(String className)
/*     */   {
/* 133 */     if (tsLogger.arjLogger.isDebugEnabled())
/*     */     {
/* 135 */       tsLogger.arjLogger.debug(16L, 1L, 2048L, "Loading recovery activator " + className);
/*     */     }
/*     */ 
/* 142 */     if (className == null)
/*     */     {
/* 144 */       if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/* 145 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.RecActivatorLoader_1");
/*     */       }
/* 147 */       return;
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 153 */       Class c = Thread.currentThread().getContextClassLoader().loadClass(className);
/*     */       try
/*     */       {
/* 157 */         RecoveryActivator ra = (RecoveryActivator)c.newInstance();
/* 158 */         _recoveryActivators.add(ra);
/*     */       }
/*     */       catch (ClassCastException e)
/*     */       {
/* 162 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */         {
/* 164 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.RecActivatorLooader_2", new Object[] { className });
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (IllegalAccessException iae)
/*     */       {
/* 170 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */         {
/* 172 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.RecActivatorLoader_3", new Object[] { iae });
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (InstantiationException ie)
/*     */       {
/* 178 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */         {
/* 180 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.RecActivatorLoader_4", new Object[] { ie });
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 185 */       c = null;
/*     */     }
/*     */     catch (ClassNotFoundException cnfe)
/*     */     {
/* 189 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */       {
/* 191 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.RecActivatorLoader_5", new Object[] { className });
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private final void initialise()
/*     */   {
/* 200 */     _recoveryActivators = new Vector();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.arjuna.recovery.RecActivatorLoader
 * JD-Core Version:    0.6.0
 */