/*     */ package com.arjuna.ats.internal.arjuna.recovery;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.common.arjPropertyManager;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.ats.arjuna.recovery.RecoveryModule;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import com.arjuna.common.util.propertyservice.PropertyManager;
/*     */ import java.io.IOException;
/*     */ import java.net.ServerSocket;
/*     */ import java.text.SimpleDateFormat;
/*     */ import java.util.Date;
/*     */ import java.util.Enumeration;
/*     */ import java.util.Properties;
/*     */ import java.util.Vector;
/*     */ 
/*     */ public class PeriodicRecovery extends Thread
/*     */ {
/* 404 */   private static Vector _recoveryModules = null;
/*     */ 
/* 409 */   private static int _backoffPeriod = 0;
/* 410 */   private static int _recoveryPeriod = 0;
/*     */   private static final int _defaultBackoffPeriod = 10;
/*     */   private static final int _defaultRecoveryPeriod = 120;
/* 417 */   private static boolean _terminate = false;
/*     */ 
/* 419 */   private static SimpleDateFormat _theTimestamper = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss");
/*     */ 
/* 421 */   private static ServerSocket _socket = null;
/*     */ 
/* 423 */   private static Listener _listener = null;
/* 424 */   private static WorkerService _workerService = null;
/*     */ 
/*     */   public PeriodicRecovery(boolean threaded)
/*     */   {
/*  81 */     initialise();
/*     */ 
/*  85 */     loadModules();
/*     */     try
/*     */     {
/*  89 */       _workerService = new WorkerService(this);
/*     */ 
/*  91 */       _listener = new Listener(getServerSocket(), _workerService);
/*  92 */       _listener.setDaemon(true);
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*  96 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */       {
/*  98 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery_9", new Object[] { ex });
/*     */       }
/*     */     }
/*     */ 
/* 102 */     if (threaded)
/*     */     {
/* 104 */       start();
/*     */     }
/*     */ 
/* 107 */     _listener.start();
/*     */   }
/*     */ 
/*     */   public void shutdown()
/*     */   {
/* 112 */     _terminate = true;
/*     */ 
/* 114 */     interrupt();
/*     */   }
/*     */ 
/*     */   public static final ServerSocket getServerSocket()
/*     */     throws IOException
/*     */   {
/* 125 */     if (_socket == null)
/*     */     {
/* 129 */       String tsmPortStr = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.internal.arjuna.recovery.recoveryPort");
/* 130 */       int port = 0;
/*     */ 
/* 132 */       if (tsmPortStr != null)
/*     */       {
/*     */         try
/*     */         {
/* 136 */           port = Integer.parseInt(tsmPortStr);
/*     */         }
/*     */         catch (Exception ex)
/*     */         {
/* 140 */           if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */           {
/* 142 */             tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery_8", new Object[] { ex });
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/* 147 */       _socket = new ServerSocket(port);
/*     */     }
/*     */ 
/* 150 */     return _socket;
/*     */   }
/*     */ 
/*     */   public void run()
/*     */   {
/* 159 */     boolean finished = false;
/*     */     do
/*     */     {
/* 163 */       finished = doWork(true);
/*     */     }
/* 165 */     while (!finished);
/*     */   }
/*     */ 
/*     */   public final boolean doWork(boolean periodic)
/*     */   {
/* 182 */     boolean interrupted = false;
/*     */ 
/* 184 */     tsLogger.arjLogger.info("Periodic recovery - first pass <" + _theTimestamper.format(new Date()) + ">");
/*     */ 
/* 187 */     Enumeration modules = _recoveryModules.elements();
/*     */ 
/* 189 */     while (modules.hasMoreElements())
/*     */     {
/* 191 */       RecoveryModule m = (RecoveryModule)modules.nextElement();
/*     */ 
/* 193 */       m.periodicWorkFirstPass();
/*     */ 
/* 195 */       if (tsLogger.arjLogger.isDebugEnabled())
/*     */       {
/* 197 */         tsLogger.arjLogger.debug(16L, 4L, 2048L, " ");
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 204 */     if (interrupted)
/*     */     {
/* 206 */       interrupted = false;
/*     */ 
/* 208 */       _workerService.signalDone();
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 216 */       Thread.sleep(_backoffPeriod * 1000);
/*     */     }
/*     */     catch (InterruptedException ie)
/*     */     {
/* 220 */       interrupted = true;
/*     */     }
/*     */ 
/* 223 */     if (_terminate)
/*     */     {
/* 225 */       return true;
/*     */     }
/*     */ 
/* 228 */     tsLogger.arjLogger.info("Periodic recovery - second pass <" + _theTimestamper.format(new Date()) + ">");
/*     */ 
/* 231 */     modules = _recoveryModules.elements();
/*     */ 
/* 233 */     while (modules.hasMoreElements())
/*     */     {
/* 235 */       RecoveryModule m = (RecoveryModule)modules.nextElement();
/*     */ 
/* 237 */       m.periodicWorkSecondPass();
/*     */ 
/* 239 */       if (tsLogger.arjLogger.isDebugEnabled())
/*     */       {
/* 241 */         tsLogger.arjLogger.debug(16L, 4L, 2048L, " ");
/*     */       }
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 247 */       if ((!interrupted) && (periodic))
/* 248 */         Thread.sleep(_recoveryPeriod * 1000);
/*     */     }
/*     */     catch (InterruptedException ie)
/*     */     {
/* 252 */       interrupted = true;
/*     */     }
/*     */ 
/* 257 */     return _terminate;
/*     */   }
/*     */ 
/*     */   public final void addModule(RecoveryModule module)
/*     */   {
/* 273 */     _recoveryModules.add(module);
/*     */   }
/*     */ 
/*     */   public final Vector getModules()
/*     */   {
/* 282 */     return _recoveryModules;
/*     */   }
/*     */ 
/*     */   private static final void loadModules()
/*     */   {
/* 293 */     Properties properties = arjPropertyManager.propertyManager.getProperties();
/*     */ 
/* 295 */     if (properties != null)
/*     */     {
/* 297 */       Vector moduleNames = new Vector();
/* 298 */       Enumeration names = properties.propertyNames();
/*     */ 
/* 300 */       while (names.hasMoreElements())
/*     */       {
/* 302 */         String attrName = (String)names.nextElement();
/*     */ 
/* 304 */         if (attrName.startsWith("com.arjuna.ats.arjuna.recovery.recoveryExtension"))
/*     */         {
/* 307 */           int position = 0;
/*     */ 
/* 310 */           while ((position < moduleNames.size()) && (attrName.compareTo((String)moduleNames.elementAt(position)) > 0))
/*     */           {
/* 312 */             position++;
/*     */           }
/* 314 */           moduleNames.add(position, attrName);
/*     */         }
/*     */       }
/*     */ 
/* 318 */       names = moduleNames.elements();
/*     */ 
/* 320 */       while (names.hasMoreElements())
/*     */       {
/* 322 */         String attrName = (String)names.nextElement();
/*     */ 
/* 324 */         loadModule(properties.getProperty(attrName));
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private static final void loadModule(String className)
/*     */   {
/* 331 */     if (tsLogger.arjLogger.isDebugEnabled())
/*     */     {
/* 333 */       tsLogger.arjLogger.debug(16L, 1L, 2048L, "Loading recovery module " + className);
/*     */     }
/*     */ 
/* 340 */     if (className == null)
/*     */     {
/* 342 */       if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/* 343 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery_1");
/*     */       }
/* 345 */       return;
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 351 */       Class c = Thread.currentThread().getContextClassLoader().loadClass(className);
/*     */       try
/*     */       {
/* 355 */         RecoveryModule m = (RecoveryModule)c.newInstance();
/* 356 */         _recoveryModules.add(m);
/*     */       }
/*     */       catch (ClassCastException e)
/*     */       {
/* 360 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */         {
/* 362 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery_2", new Object[] { className });
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (IllegalAccessException iae)
/*     */       {
/* 368 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */         {
/* 370 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery_3", new Object[] { iae });
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (InstantiationException ie)
/*     */       {
/* 376 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */         {
/* 378 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery_4", new Object[] { ie });
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 383 */       c = null;
/*     */     }
/*     */     catch (ClassNotFoundException cnfe)
/*     */     {
/* 387 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */       {
/* 389 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery_5", new Object[] { className });
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private final void initialise()
/*     */   {
/* 398 */     _recoveryModules = new Vector();
/* 399 */     _terminate = false;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/* 435 */     _recoveryPeriod = 120;
/*     */ 
/* 437 */     String recoveryPeriodString = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.recovery.periodicRecoveryPeriod");
/*     */ 
/* 440 */     if (recoveryPeriodString != null)
/*     */     {
/*     */       try
/*     */       {
/* 444 */         Integer recoveryPeriodInteger = new Integer(recoveryPeriodString);
/* 445 */         _recoveryPeriod = recoveryPeriodInteger.intValue();
/*     */ 
/* 447 */         if (tsLogger.arjLogger.isDebugEnabled())
/*     */         {
/* 449 */           tsLogger.arjLogger.debug(16L, 1L, 2048L, "com.arjuna.ats.arjuna.recovery.PeriodicRecovery: Recovery period set to " + _recoveryPeriod + " seconds");
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (NumberFormatException e)
/*     */       {
/* 459 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */         {
/* 461 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery_6", new Object[] { "com.arjuna.ats.arjuna.recovery.periodicRecoveryPeriod", recoveryPeriodString });
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 467 */     _backoffPeriod = 10;
/*     */ 
/* 469 */     String backoffPeriodString = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.recovery.recoveryBackoffPeriod");
/*     */ 
/* 473 */     if (backoffPeriodString != null)
/*     */     {
/*     */       try
/*     */       {
/* 477 */         Integer backoffPeriodInteger = new Integer(backoffPeriodString);
/* 478 */         _backoffPeriod = backoffPeriodInteger.intValue();
/*     */ 
/* 480 */         if (tsLogger.arjLogger.isDebugEnabled())
/*     */         {
/* 482 */           tsLogger.arjLogger.debug(16L, 1L, 2048L, "PeriodicRecovery: Backoff period set to " + _backoffPeriod + " seconds");
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (NumberFormatException e)
/*     */       {
/* 492 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */         {
/* 494 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery_7", new Object[] { "com.arjuna.ats.arjuna.recovery.recoveryBackoffPeriod", backoffPeriodString });
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery
 * JD-Core Version:    0.6.0
 */