/*     */ package com.arjuna.ats.internal.arjuna.recovery;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.common.arjPropertyManager;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.ats.arjuna.objectstore.ObjectStore;
/*     */ import com.arjuna.ats.arjuna.recovery.ExpiryScanner;
/*     */ import com.arjuna.ats.arjuna.state.InputObjectState;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import com.arjuna.common.util.propertyservice.PropertyManager;
/*     */ import java.text.SimpleDateFormat;
/*     */ import java.util.Date;
/*     */ import java.util.StringTokenizer;
/*     */ 
/*     */ public class ExpiredTransactionStatusManagerScanner
/*     */   implements ExpiryScanner
/*     */ {
/*     */   private String _itemTypeName;
/*     */   private ObjectStore _objectStore;
/* 194 */   private static int _expiryTime = 43200;
/*     */ 
/* 196 */   private static SimpleDateFormat _timeFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss");
/*     */ 
/*     */   public ExpiredTransactionStatusManagerScanner()
/*     */   {
/*  69 */     if (tsLogger.arjLoggerI18N.isDebugEnabled())
/*     */     {
/*  71 */       tsLogger.arjLoggerI18N.debug(1L, 4L, 2048L, "com.arjuna.ats.internal.arjuna.recovery.ExpiredTransactionStatusManagerScanner_1", new Object[] { Integer.toString(_expiryTime) });
/*     */     }
/*     */ 
/*  77 */     this._objectStore = TransactionStatusManagerItem.getStore();
/*  78 */     this._itemTypeName = TransactionStatusManagerItem.typeName();
/*     */   }
/*     */ 
/*     */   public void scan()
/*     */   {
/*  87 */     Date oldestSurviving = new Date(new Date().getTime() - _expiryTime * 1000);
/*     */ 
/*  89 */     if (tsLogger.arjLoggerI18N.isDebugEnabled())
/*     */     {
/*  91 */       tsLogger.arjLoggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.internal.arjuna.recovery.ExpiredTransactionStatusManagerScanner_2", new Object[] { _timeFormat.format(oldestSurviving) });
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/*  99 */       InputObjectState uids = new InputObjectState();
/*     */ 
/* 102 */       if (this._objectStore.allObjUids(this._itemTypeName, uids))
/*     */       {
/* 104 */         Uid theUid = new Uid(Uid.nullUid());
/*     */ 
/* 106 */         boolean endOfUids = false;
/*     */ 
/* 108 */         while (!endOfUids)
/*     */         {
/* 111 */           theUid.unpack(uids);
/*     */ 
/* 113 */           if (theUid.equals(Uid.nullUid())) {
/* 114 */             endOfUids = true; continue;
/*     */           }
/*     */ 
/* 117 */           Uid newUid = new Uid(theUid);
/*     */ 
/* 120 */           TransactionStatusManagerItem tsmItem = TransactionStatusManagerItem.recreate(newUid);
/*     */ 
/* 122 */           if (tsmItem != null)
/*     */           {
/* 124 */             Date timeOfDeath = tsmItem.getDeadTime();
/*     */ 
/* 126 */             if ((timeOfDeath != null) && (timeOfDeath.before(oldestSurviving)))
/*     */             {
/* 128 */               if (tsLogger.arjLoggerI18N.isInfoEnabled())
/*     */               {
/* 130 */                 tsLogger.arjLoggerI18N.info("com.arjuna.ats.internal.arjuna.recovery.ExpiredTransactionStatusManagerScanner_3", new Object[] { newUid });
/*     */               }
/*     */ 
/* 133 */               this._objectStore.remove_committed(newUid, this._itemTypeName);
/*     */             }
/*     */             else
/*     */             {
/* 140 */               Uid currentUid = newUid;
/*     */ 
/* 142 */               String process_id = get_process_id(currentUid);
/*     */ 
/* 144 */               TransactionStatusConnector tsc = new TransactionStatusConnector(process_id, currentUid);
/*     */ 
/* 147 */               tsc.test(tsmItem);
/*     */ 
/* 149 */               if (tsc.isDead())
/*     */               {
/* 151 */                 if (tsLogger.arjLoggerI18N.isInfoEnabled())
/*     */                 {
/* 153 */                   tsLogger.arjLoggerI18N.info("com.arjuna.ats.internal.arjuna.recovery.ExpiredTransactionStatusManagerScanner_3", new Object[] { newUid });
/*     */                 }
/*     */ 
/* 156 */                 tsc.delete();
/* 157 */                 tsc = null;
/*     */               }
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean toBeUsed()
/*     */   {
/* 173 */     return _expiryTime != 0;
/*     */   }
/*     */ 
/*     */   private String get_process_id(Uid uid)
/*     */   {
/* 183 */     String strUid = uid.toString();
/* 184 */     StringTokenizer st = new StringTokenizer(strUid, ":");
/* 185 */     st.nextToken();
/* 186 */     String process_id_in_Hex = st.nextToken();
/*     */ 
/* 188 */     return process_id_in_Hex;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/* 201 */     String expiryTimeString = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.recovery.transactionStatusManagerExpiryTime");
/*     */ 
/* 203 */     if (expiryTimeString != null)
/*     */     {
/*     */       try
/*     */       {
/* 207 */         Integer expiryTimeInteger = new Integer(expiryTimeString);
/*     */ 
/* 209 */         _expiryTime = expiryTimeInteger.intValue() * 60 * 60;
/*     */ 
/* 211 */         if (tsLogger.arjLoggerI18N.isDebugEnabled())
/*     */         {
/* 213 */           tsLogger.arjLoggerI18N.debug(16L, 1L, 2048L, "com.arjuna.ats.internal.arjuna.recovery.ExpiredTransactionStatusManagerScanner_4", new Object[] { Integer.toString(_expiryTime) });
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (NumberFormatException e)
/*     */       {
/* 220 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */         {
/* 222 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.ExpiredTransactionStatusManagerScanner_5", new Object[] { "com.arjuna.ats.arjuna.recovery.transactionStatusManagerExpiryTime", expiryTimeString });
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.arjuna.recovery.ExpiredTransactionStatusManagerScanner
 * JD-Core Version:    0.6.0
 */