/*     */ package com.arjuna.ats.internal.arjuna.objectstore.jdbc;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.ats.arjuna.state.InputObjectState;
/*     */ import com.arjuna.ats.arjuna.state.OutputObjectState;
/*     */ import com.arjuna.ats.internal.arjuna.objectstore.JDBCImple;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import java.sql.Connection;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.Statement;
/*     */ 
/*     */ public class sqlserver_driver extends JDBCImple
/*     */ {
/*     */   private static final int _maxStateSize = 65535;
/*     */ 
/*     */   public InputObjectState read_state(Uid objUid, String tName, int ft, String tableName)
/*     */     throws ObjectStoreException
/*     */   {
/*  69 */     InputObjectState newImage = null;
/*     */ 
/*  71 */     if (!storeValid()) {
/*  72 */       return newImage;
/*     */     }
/*  74 */     if (tName != null)
/*     */     {
/*  76 */       if ((ft == 1) || (ft == 2))
/*     */       {
/*  78 */         int pool = getPool();
/*  79 */         ResultSet rs = null;
/*     */         try
/*     */         {
/*  83 */           PreparedStatement pstmt = this._preparedStatements[pool][4];
/*     */ 
/*  85 */           if (pstmt == null)
/*     */           {
/*  87 */             pstmt = this._theConnection[pool].prepareStatement("SELECT ObjectState FROM " + tableName + " WHERE UidString = ? AND TypeName = ? AND StateType = ?");
/*     */ 
/*  89 */             this._preparedStatements[pool][4] = pstmt;
/*     */           }
/*     */ 
/*  92 */           pstmt.setString(1, objUid.stringForm());
/*  93 */           pstmt.setString(2, tName);
/*  94 */           pstmt.setInt(3, ft);
/*     */ 
/*  96 */           rs = pstmt.executeQuery();
/*     */ 
/*  98 */           if (!rs.next()) {
/*  99 */             Object localObject1 = null;
/*     */             return localObject1;
/*     */           }
/* 102 */           buffer = rs.getBytes(1);
/*     */ 
/* 104 */           if (buffer != null)
/*     */           {
/* 106 */             newImage = new InputObjectState(objUid, tName, buffer);
/*     */           }
/* 109 */           else if (tsLogger.arjLoggerI18N.isWarnEnabled())
/* 110 */             tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.jdbc.sqlserver_1");
/*     */         }
/*     */         catch (Throwable e)
/*     */         {
/*     */           Object buffer;
/* 115 */           if (retryConnection(e, pool)) {
/* 116 */             buffer = read_state(objUid, tName, ft, tableName);
/*     */             return buffer;
/*     */           }
/* 118 */           throw new ObjectStoreException(e.toString());
/*     */         }
/*     */         finally
/*     */         {
/*     */           try
/*     */           {
/* 125 */             rs.close();
/*     */           }
/*     */           catch (Exception re) {
/*     */           }
/* 129 */           freePool(pool);
/*     */         }
/*     */       }
/*     */     }
/*     */     else {
/* 134 */       throw new ObjectStoreException("sqlserver.read_state - object with uid " + objUid + " has no TypeName");
/*     */     }
/* 136 */     return (InputObjectState)newImage;
/*     */   }
/*     */ 
/*     */   public boolean write_state(Uid objUid, String tName, OutputObjectState state, int s, String tableName)
/*     */     throws ObjectStoreException
/*     */   {
/* 142 */     boolean result = false;
/*     */ 
/* 144 */     int imageSize = state.length();
/*     */ 
/* 146 */     if (imageSize > 65535) {
/* 147 */       throw new ObjectStoreException("Object state is too large - maximum size allowed: 65535");
/*     */     }
/* 149 */     byte[] b = state.buffer();
/*     */ 
/* 151 */     if ((imageSize > 0) && (storeValid()))
/*     */     {
/* 153 */       int pool = getPool();
/* 154 */       ResultSet rs = null;
/*     */       try
/*     */       {
/* 158 */         PreparedStatement pstmt = this._preparedStatements[pool][9];
/*     */ 
/* 160 */         if (pstmt == null)
/*     */         {
/* 162 */           pstmt = this._theConnection[pool].prepareStatement("SELECT ObjectState FROM " + tableName + " WHERE UidString = ? AND StateType = ? AND TypeName = ?", 1003, 1008);
/*     */ 
/* 164 */           this._preparedStatements[pool][9] = pstmt;
/*     */         }
/*     */ 
/* 167 */         pstmt.setString(1, objUid.stringForm());
/* 168 */         pstmt.setInt(2, s);
/* 169 */         pstmt.setString(3, tName);
/*     */ 
/* 171 */         rs = pstmt.executeQuery();
/*     */ 
/* 173 */         if (rs.next())
/*     */         {
/* 175 */           rs.updateBytes(1, b);
/* 176 */           rs.updateRow();
/*     */         }
/*     */         else
/*     */         {
/* 180 */           pstmt2 = this._preparedStatements[pool][6];
/*     */ 
/* 182 */           if (pstmt2 == null)
/*     */           {
/* 184 */             pstmt2 = this._theConnection[pool].prepareStatement("INSERT INTO " + tableName + " (StateType,TypeName,UidString,ObjectState) VALUES (?,?,?,?)");
/*     */ 
/* 186 */             this._preparedStatements[pool][6] = pstmt2;
/*     */           }
/*     */ 
/* 189 */           pstmt2.setInt(1, s);
/* 190 */           pstmt2.setString(2, tName);
/* 191 */           pstmt2.setString(3, objUid.stringForm());
/* 192 */           pstmt2.setBytes(4, b);
/*     */ 
/* 194 */           pstmt2.executeUpdate();
/* 195 */           this._theConnection[pool].commit();
/*     */         }
/*     */ 
/* 199 */         this._theConnection[pool].commit();
/* 200 */         result = true;
/*     */       }
/*     */       catch (Throwable re)
/*     */       {
/*     */         PreparedStatement pstmt2;
/* 205 */         e.printStackTrace();
/* 206 */         if (retryConnection(e, pool)) {
/* 207 */           pstmt2 = write_state(objUid, tName, state, s, tableName);
/*     */           return pstmt2;
/*     */         }
/* 209 */         if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/* 210 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.jdbc.sqlserver_2", new Object[] { e });
/*     */         }
/*     */       }
/*     */       finally
/*     */       {
/*     */         try
/*     */         {
/* 217 */           rs.close();
/*     */         }
/*     */         catch (Exception re) {
/*     */         }
/* 221 */         freePool(pool);
/*     */       }
/*     */     }
/* 224 */     return result;
/*     */   }
/*     */ 
/*     */   protected void createTable(Statement stmt, String tableName)
/*     */     throws SQLException
/*     */   {
/* 230 */     stmt.executeUpdate("CREATE TABLE " + tableName + " (StateType INTEGER, TypeName VARCHAR(1024), UidString VARCHAR(255), ObjectState IMAGE, PRIMARY KEY(UidString, StateType, TypeName))");
/*     */   }
/*     */ 
/*     */   public String name()
/*     */   {
/* 236 */     return "sqlserver";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.arjuna.objectstore.jdbc.sqlserver_driver
 * JD-Core Version:    0.6.0
 */