/*     */ package com.arjuna.ats.internal.arjuna.objectstore.jdbc;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.ats.arjuna.state.InputObjectState;
/*     */ import com.arjuna.ats.arjuna.state.OutputObjectState;
/*     */ import com.arjuna.ats.internal.arjuna.objectstore.JDBCImple;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import java.sql.Blob;
/*     */ import java.sql.Connection;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.Statement;
/*     */ import oracle.sql.BLOB;
/*     */ 
/*     */ public class oracle_driver extends JDBCImple
/*     */ {
/*     */   private static final int MAX_RETRIES = 10;
/*     */   private static final int _maxStateSize = 10485760;
/*     */ 
/*     */   public InputObjectState read_state(Uid objUid, String tName, int ft, String tableName)
/*     */     throws ObjectStoreException
/*     */   {
/*  71 */     InputObjectState newImage = null;
/*     */ 
/*  73 */     if (!storeValid()) {
/*  74 */       return newImage;
/*     */     }
/*  76 */     if (tName != null)
/*     */     {
/*  78 */       if ((ft == 1) || (ft == 2))
/*     */       {
/*  80 */         int pool = getPool();
/*  81 */         ResultSet rs = null;
/*     */         try
/*     */         {
/*  85 */           for (int count = 0; count < 10; count++)
/*     */           {
/*     */             try
/*     */             {
/*  89 */               PreparedStatement pstmt = this._preparedStatements[pool][4];
/*     */ 
/*  91 */               if (pstmt == null)
/*     */               {
/*  93 */                 pstmt = this._theConnection[pool].prepareStatement("SELECT ObjectState FROM " + tableName + " WHERE UidString = ? AND TypeName = ? AND StateType = ?");
/*     */ 
/*  95 */                 this._preparedStatements[pool][4] = pstmt;
/*     */               }
/*     */ 
/*  98 */               pstmt.setString(1, objUid.stringForm());
/*  99 */               pstmt.setString(2, tName);
/* 100 */               pstmt.setInt(3, ft);
/*     */ 
/* 102 */               rs = pstmt.executeQuery();
/*     */ 
/* 104 */               if (!rs.next()) {
/* 105 */                 Object localObject1 = null;
/*     */                 try
/*     */                 {
/* 143 */                   if (rs != null)
/* 144 */                     rs.close();
/*     */                 }
/*     */                 catch (Exception re) {
/*     */                 }
/* 148 */                 freePool(pool); return localObject1;
/*     */               }
/* 108 */               Blob myBlob = rs.getBlob(1);
/* 109 */               byte[] buffer = myBlob.getBytes(1L, (int)myBlob.length());
/*     */ 
/* 111 */               if (buffer != null)
/*     */               {
/* 113 */                 newImage = new InputObjectState(objUid, tName, buffer);
/*     */               }
/* 116 */               else if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/* 117 */                 tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.jdbc.oracle_1");
/*     */               }
/*     */ 
/* 120 */               InputObjectState localInputObjectState1 = newImage;
/*     */               try
/*     */               {
/* 143 */                 if (rs != null)
/* 144 */                   rs.close();
/*     */               }
/*     */               catch (Exception re) {
/*     */               }
/* 148 */               freePool(pool); return localInputObjectState1;
/*     */             }
/*     */             catch (Throwable e)
/*     */             {
/* 124 */               if (count == 9)
/*     */               {
/* 126 */                 throw new ObjectStoreException(e.toString());
/*     */               }
/*     */               try
/*     */               {
/* 130 */                 reconnect(pool);
/*     */               }
/*     */               catch (Throwable th)
/*     */               {
/* 134 */                 throw new ObjectStoreException(e.toString());
/*     */               }
/*     */             }
/*     */           }
/*     */         }
/*     */         finally
/*     */         {
/*     */           try
/*     */           {
/* 143 */             if (rs != null)
/* 144 */               rs.close();
/*     */           }
/*     */           catch (Exception re) {
/*     */           }
/* 148 */           freePool(pool);
/*     */         }
/*     */       }
/* 151 */       return newImage;
/*     */     }
/*     */ 
/* 154 */     throw new ObjectStoreException("oracle.read_state - object with uid " + objUid + " has no TypeName");
/*     */   }
/*     */ 
/*     */   public boolean write_state(Uid objUid, String tName, OutputObjectState state, int s, String tableName)
/*     */     throws ObjectStoreException
/*     */   {
/* 160 */     int imageSize = state.length();
/*     */ 
/* 162 */     if (imageSize > 10485760) {
/* 163 */       throw new ObjectStoreException("Object state is too large - maximum size allowed: 10485760");
/*     */     }
/* 165 */     byte[] b = state.buffer();
/*     */ 
/* 167 */     if ((imageSize > 0) && (storeValid()))
/*     */     {
/* 169 */       int pool = getPool();
/* 170 */       ResultSet rs = null;
/* 171 */       ResultSet rs3 = null;
/*     */       try
/*     */       {
/* 175 */         for (int count = 0; count < 10; count++)
/*     */         {
/*     */           try
/*     */           {
/* 179 */             PreparedStatement pstmt = this._preparedStatements[pool][9];
/*     */ 
/* 181 */             this._theConnection[pool].setAutoCommit(false);
/*     */ 
/* 183 */             if (pstmt == null)
/*     */             {
/* 185 */               pstmt = this._theConnection[pool].prepareStatement("SELECT ObjectState FROM " + tableName + " WHERE UidString = ? AND StateType = ? AND TypeName = ? FOR UPDATE", 1003, 1008);
/* 186 */               this._preparedStatements[pool][9] = pstmt;
/*     */             }
/* 188 */             pstmt.setString(1, objUid.stringForm());
/* 189 */             pstmt.setInt(2, s);
/* 190 */             pstmt.setString(3, tName);
/*     */ 
/* 192 */             rs = pstmt.executeQuery();
/*     */ 
/* 194 */             if (rs.next())
/*     */             {
/* 196 */               BLOB myBlob = (BLOB)rs.getBlob(1);
/* 197 */               myBlob.putBytes(1L, b);
/*     */             }
/*     */             else
/*     */             {
/* 201 */               pstmt2 = this._preparedStatements[pool][6];
/*     */ 
/* 203 */               if (pstmt2 == null)
/*     */               {
/* 205 */                 pstmt2 = this._theConnection[pool].prepareStatement("INSERT INTO " + tableName + " (StateType,TypeName,UidString,ObjectState) VALUES (?,?,?,empty_blob())");
/*     */ 
/* 207 */                 this._preparedStatements[pool][6] = pstmt2;
/*     */               }
/*     */ 
/* 210 */               pstmt2.setInt(1, s);
/* 211 */               pstmt2.setString(2, tName);
/* 212 */               pstmt2.setString(3, objUid.stringForm());
/*     */ 
/* 214 */               pstmt2.executeUpdate();
/* 215 */               this._theConnection[pool].commit();
/*     */ 
/* 217 */               PreparedStatement pstmt3 = this._preparedStatements[pool][8];
/* 218 */               if (pstmt3 == null) {
/* 219 */                 pstmt3 = this._theConnection[pool].prepareStatement("SELECT ObjectState FROM " + tableName + " WHERE UidString = ? AND TypeName = ? AND StateType = ? FOR UPDATE");
/* 220 */                 this._preparedStatements[pool][8] = pstmt3;
/*     */               }
/*     */ 
/* 223 */               pstmt3.setString(1, objUid.stringForm());
/* 224 */               pstmt3.setString(2, tName);
/* 225 */               pstmt3.setInt(3, s);
/*     */ 
/* 227 */               rs3 = pstmt3.executeQuery();
/* 228 */               rs3.next();
/* 229 */               BLOB myBlob = (BLOB)rs3.getBlob(1);
/* 230 */               myBlob.putBytes(1L, b);
/*     */             }
/*     */ 
/* 233 */             this._theConnection[pool].commit();
/* 234 */             pstmt2 = 1;
/*     */             try
/*     */             {
/* 261 */               this._theConnection[pool].setAutoCommit(true);
/*     */             }
/*     */             catch (Exception e) {
/*     */             }
/*     */             try {
/* 266 */               if (rs != null)
/* 267 */                 rs.close();
/*     */             }
/*     */             catch (Exception re)
/*     */             {
/*     */             }
/*     */             try
/*     */             {
/* 274 */               if (rs3 != null)
/* 275 */                 rs3.close();
/*     */             }
/*     */             catch (Exception re3)
/*     */             {
/*     */             }
/* 280 */             freePool(pool); return pstmt2;
/*     */           }
/*     */           catch (Throwable e)
/*     */           {
/*     */             PreparedStatement pstmt2;
/* 239 */             if (count == 9)
/*     */             {
/* 241 */               if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/* 242 */                 tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.jdbc.oracle_2", new Object[] { e });
/*     */               }
/* 244 */               pstmt2 = 0;
/*     */               try
/*     */               {
/* 261 */                 this._theConnection[pool].setAutoCommit(true);
/*     */               }
/*     */               catch (Exception e) {
/*     */               }
/*     */               try {
/* 266 */                 if (rs != null)
/* 267 */                   rs.close();
/*     */               }
/*     */               catch (Exception re)
/*     */               {
/*     */               }
/*     */               try
/*     */               {
/* 274 */                 if (rs3 != null)
/* 275 */                   rs3.close();
/*     */               }
/*     */               catch (Exception re3)
/*     */               {
/*     */               }
/* 280 */               freePool(pool); return pstmt2;
/*     */             }
/*     */             try
/*     */             {
/* 248 */               reconnect(pool);
/*     */             }
/*     */             catch (Throwable th)
/*     */             {
/* 252 */               throw new ObjectStoreException(e.toString());
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */       finally
/*     */       {
/*     */         try
/*     */         {
/* 261 */           this._theConnection[pool].setAutoCommit(true);
/*     */         }
/*     */         catch (Exception e) {
/*     */         }
/*     */         try {
/* 266 */           if (rs != null)
/* 267 */             rs.close();
/*     */         }
/*     */         catch (Exception re)
/*     */         {
/*     */         }
/*     */         try
/*     */         {
/* 274 */           if (rs3 != null)
/* 275 */             rs3.close();
/*     */         }
/*     */         catch (Exception re3)
/*     */         {
/*     */         }
/* 280 */         freePool(pool);
/*     */       }
/*     */     }
/* 283 */     return false;
/*     */   }
/*     */ 
/*     */   protected void createTable(Statement stmt, String tableName)
/*     */     throws SQLException
/*     */   {
/* 289 */     stmt.executeUpdate("CREATE TABLE " + tableName + " (StateType INTEGER, TypeName VARCHAR(1024),UidString VARCHAR(255), ObjectState BLOB, CONSTRAINT " + tableName + "_pk PRIMARY KEY(UidString, StateType, TypeName))");
/*     */   }
/*     */ 
/*     */   public String name()
/*     */   {
/* 294 */     return "oracle";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.arjuna.objectstore.jdbc.oracle_driver
 * JD-Core Version:    0.6.0
 */