/*      */ package com.arjuna.ats.internal.arjuna.objectstore;
/*      */ 
/*      */ import com.arjuna.ats.arjuna.common.Uid;
/*      */ import com.arjuna.ats.arjuna.common.arjPropertyManager;
/*      */ import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
/*      */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*      */ import com.arjuna.ats.arjuna.objectstore.jdbc.JDBCAccess;
/*      */ import com.arjuna.ats.arjuna.state.InputObjectState;
/*      */ import com.arjuna.ats.arjuna.state.OutputObjectState;
/*      */ import com.arjuna.common.util.logging.Logi18n;
/*      */ import com.arjuna.common.util.propertyservice.PropertyManager;
/*      */ import java.io.IOException;
/*      */ import java.sql.Connection;
/*      */ import java.sql.PreparedStatement;
/*      */ import java.sql.ResultSet;
/*      */ import java.sql.SQLException;
/*      */ import java.sql.Statement;
/*      */ import java.util.Hashtable;
/*      */ 
/*      */ public abstract class JDBCImple
/*      */ {
/*      */   private int shareStatus;
/* 1328 */   private Hashtable stateCache = new Hashtable();
/*      */ 
/* 1330 */   protected JDBCAccess _jdbcAccess = null;
/*      */ 
/* 1332 */   protected Connection[] _theConnection = null;
/*      */ 
/* 1334 */   protected boolean _isValid = false;
/*      */ 
/* 1336 */   protected PreparedStatement[][] _preparedStatements = (PreparedStatement[][])null;
/*      */   protected static final int COMMIT_STATE = 0;
/*      */   protected static final int HIDE_STATE = 1;
/*      */   protected static final int REVEAL_STATE = 2;
/*      */   protected static final int CURRENT_STATE = 3;
/*      */   protected static final int READ_STATE = 4;
/*      */   protected static final int REMOVE_STATE = 5;
/*      */   protected static final int WRITE_STATE_NEW = 6;
/*      */   protected static final int WRITE_STATE_EXISTING = 7;
/*      */   protected static final int SELECT_FOR_WRITE_STATE = 8;
/*      */   protected static final int READ_WRITE_SHORTCUT = 9;
/*      */   protected static final int PRECOMMIT_CLEANUP = 10;
/*      */   protected static final int STATEMENT_SIZE = 11;
/* 1367 */   protected boolean[] _inUse = null;
/*      */ 
/* 1369 */   protected int _poolSizeInit = 1;
/*      */ 
/* 1371 */   protected int _poolSizeMax = 1;
/*      */ 
/* 1373 */   protected boolean _poolPutConn = false;
/*      */ 
/*      */   public final boolean storeValid()
/*      */   {
/*   57 */     return this._isValid;
/*      */   }
/*      */ 
/*      */   public boolean commit_state(Uid objUid, String typeName, String tableName)
/*      */     throws ObjectStoreException
/*      */   {
/*   63 */     boolean result = false;
/*   64 */     boolean cleanup = true;
/*      */ 
/*   68 */     if (!storeValid()) {
/*   69 */       return false;
/*      */     }
/*   71 */     if (typeName != null)
/*      */     {
/*   73 */       int currState = currentState(objUid, typeName, tableName);
/*   74 */       int pool = getPool();
/*      */       try
/*      */       {
/*   79 */         PreparedStatement pstmt = this._preparedStatements[pool][10];
/*   80 */         if (pstmt == null)
/*      */         {
/*   82 */           pstmt = this._theConnection[pool].prepareStatement("DELETE FROM " + tableName + " WHERE UidString = ? AND TypeName = ? AND StateType = " + 1);
/*      */ 
/*   87 */           this._preparedStatements[pool][10] = pstmt;
/*      */         }
/*   89 */         pstmt.setString(1, objUid.stringForm());
/*   90 */         pstmt.setString(2, typeName);
/*   91 */         pstmt.executeUpdate();
/*      */ 
/*   95 */         pstmt = this._preparedStatements[pool][0];
/*   96 */         if (pstmt == null)
/*      */         {
/*   98 */           pstmt = this._theConnection[pool].prepareStatement("UPDATE " + tableName + " SET StateType = ? WHERE UidString = ? AND TypeName = ? AND StateType = ?");
/*      */ 
/*  102 */           this._preparedStatements[pool][0] = pstmt;
/*      */         }
/*      */ 
/*  105 */         if (currState == 2)
/*      */         {
/*  107 */           pstmt.setInt(1, 1);
/*      */         }
/*  109 */         else if (currState == 6)
/*      */         {
/*  111 */           pstmt.setInt(1, 5);
/*      */         }
/*      */         else
/*      */         {
/*  115 */           throw new ObjectStoreException("can't commit object " + objUid + " in state " + currState);
/*      */         }
/*      */ 
/*  119 */         pstmt.setString(2, objUid.stringForm());
/*  120 */         pstmt.setString(3, typeName);
/*  121 */         pstmt.setInt(4, currState);
/*      */ 
/*  123 */         rowcount = pstmt.executeUpdate();
/*      */ 
/*  125 */         if (rowcount > 0)
/*      */         {
/*  127 */           result = true;
/*      */         }
/*      */       }
/*      */       catch (Throwable e)
/*      */       {
/*      */         int rowcount;
/*  132 */         cleanup = false;
/*  133 */         if (retryConnection(e, pool))
/*      */         {
/*  135 */           rowcount = commit_state(objUid, typeName, tableName);
/*      */           return rowcount;
/*      */         }
/*  139 */         throw new ObjectStoreException(e.toString());
/*      */       }
/*      */       finally
/*      */       {
/*  144 */         if (cleanup)
/*  145 */           freePool(pool);
/*      */       }
/*      */     }
/*      */     else {
/*  149 */       throw new ObjectStoreException("commit_state - object with uid " + objUid + " has no TypeName");
/*      */     }
/*      */ 
/*  152 */     return result;
/*      */   }
/*      */ 
/*      */   public boolean hide_state(Uid objUid, String typeName, String tableName)
/*      */     throws ObjectStoreException
/*      */   {
/*  163 */     boolean hiddenOk = true;
/*  164 */     boolean cleanup = true;
/*      */ 
/*  168 */     if (storeValid())
/*      */     {
/*  170 */       int state = currentState(objUid, typeName, tableName);
/*  171 */       int pool = getPool();
/*  172 */       PreparedStatement pstmt = null;
/*      */       try
/*      */       {
/*  176 */         pstmt = this._preparedStatements[pool][1];
/*      */ 
/*  178 */         if (pstmt == null)
/*      */         {
/*  180 */           pstmt = this._theConnection[pool].prepareStatement("UPDATE " + tableName + " SET StateType = ? WHERE UidString = ? AND TypeName = ? AND StateType = ?");
/*      */ 
/*  185 */           this._preparedStatements[pool][1] = pstmt;
/*      */         }
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*  190 */         if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/*  191 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.JDBCImple_1", new Object[] { e });
/*      */         }
/*      */ 
/*  197 */         freePool(pool);
/*  198 */         return false;
/*      */       }
/*      */ 
/*      */       try
/*      */       {
/*  203 */         switch (state)
/*      */         {
/*      */         case 5:
/*      */         case 6:
/*  207 */           break;
/*      */         case 2:
/*  210 */           pstmt.setInt(1, 6);
/*  211 */           pstmt.setString(2, objUid.stringForm());
/*  212 */           pstmt.setString(3, typeName);
/*  213 */           pstmt.setInt(4, state);
/*  214 */           pstmt.executeUpdate();
/*      */ 
/*  216 */           break;
/*      */         case 1:
/*  219 */           pstmt.setInt(1, 5);
/*  220 */           pstmt.setString(2, objUid.stringForm());
/*  221 */           pstmt.setString(3, typeName);
/*  222 */           pstmt.setInt(4, state);
/*  223 */           pstmt.executeUpdate();
/*      */ 
/*  225 */           break;
/*      */         case 3:
/*      */         case 4:
/*      */         default:
/*  227 */           hiddenOk = false;
/*      */         }
/*      */       }
/*      */       catch (Throwable e)
/*      */       {
/*  232 */         cleanup = false;
/*  233 */         if (retryConnection(e, pool))
/*      */         {
/*  235 */           hide_state(objUid, typeName, tableName);
/*      */         }
/*      */         else
/*      */         {
/*  239 */           throw new ObjectStoreException(e.toString());
/*      */         }
/*      */       }
/*      */       finally
/*      */       {
/*  244 */         if (cleanup)
/*  245 */           freePool(pool);
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/*  250 */       hiddenOk = false;
/*      */     }
/*      */ 
/*  253 */     return hiddenOk;
/*      */   }
/*      */ 
/*      */   public boolean reveal_state(Uid objUid, String typeName, String tableName)
/*      */     throws ObjectStoreException
/*      */   {
/*  264 */     boolean revealedOk = true;
/*  265 */     boolean cleanup = true;
/*      */ 
/*  267 */     if (storeValid())
/*      */     {
/*  269 */       int state = currentState(objUid, typeName, tableName);
/*      */ 
/*  271 */       int pool = getPool();
/*      */ 
/*  273 */       PreparedStatement pstmt = null;
/*      */       try
/*      */       {
/*  276 */         pstmt = this._preparedStatements[pool][2];
/*      */ 
/*  278 */         if (pstmt == null)
/*      */         {
/*  280 */           pstmt = this._theConnection[pool].prepareStatement("UPDATE " + tableName + " SET StateType = ? WHERE UidString = ? AND AND TypeName = ? StateType = ?");
/*      */ 
/*  284 */           this._preparedStatements[pool][2] = pstmt;
/*      */         }
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*  289 */         if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/*  290 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.JDBCImple_2", new Object[] { e });
/*      */         }
/*      */ 
/*  296 */         freePool(pool);
/*  297 */         return false;
/*      */       }
/*      */ 
/*      */       try
/*      */       {
/*  302 */         switch (state)
/*      */         {
/*      */         case 6:
/*  306 */           pstmt.setInt(1, 2);
/*  307 */           pstmt.setString(2, objUid.stringForm());
/*  308 */           pstmt.setString(3, typeName);
/*  309 */           pstmt.setInt(4, state);
/*  310 */           pstmt.executeUpdate();
/*      */ 
/*  312 */           break;
/*      */         case 5:
/*  315 */           pstmt.setInt(1, 1);
/*  316 */           pstmt.setString(2, objUid.stringForm());
/*  317 */           pstmt.setString(3, typeName);
/*  318 */           pstmt.setInt(4, state);
/*  319 */           pstmt.executeUpdate();
/*      */ 
/*  321 */           break;
/*      */         case 1:
/*      */         case 2:
/*  324 */           break;
/*      */         case 3:
/*      */         case 4:
/*      */         default:
/*  326 */           revealedOk = false;
/*      */         }
/*      */       }
/*      */       catch (Throwable e)
/*      */       {
/*  331 */         cleanup = false;
/*  332 */         if (retryConnection(e, pool))
/*      */         {
/*  334 */           reveal_state(objUid, typeName, tableName);
/*      */         }
/*      */         else
/*      */         {
/*  338 */           throw new ObjectStoreException(e.toString());
/*      */         }
/*      */       }
/*      */       finally
/*      */       {
/*  343 */         if (cleanup)
/*  344 */           freePool(pool);
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/*  349 */       revealedOk = false;
/*      */     }
/*      */ 
/*  352 */     return revealedOk;
/*      */   }
/*      */ 
/*      */   public int currentState(Uid objUid, String typeName, String tableName)
/*      */     throws ObjectStoreException
/*      */   {
/*  367 */     int theState = 0;
/*  368 */     ResultSet rs = null;
/*  369 */     boolean cleanup = true;
/*      */ 
/*  371 */     if (storeValid())
/*      */     {
/*  373 */       int pool = getPool();
/*      */       try
/*      */       {
/*  376 */         PreparedStatement pstmt = this._preparedStatements[pool][3];
/*      */ 
/*  378 */         if (pstmt == null)
/*      */         {
/*  380 */           pstmt = this._theConnection[pool].prepareStatement("SELECT StateType, UidString FROM " + tableName + " WHERE UidString = ? AND TypeName = ?");
/*      */ 
/*  384 */           this._preparedStatements[pool][3] = pstmt;
/*      */         }
/*      */ 
/*  387 */         pstmt.setString(1, objUid.stringForm());
/*  388 */         pstmt.setString(2, typeName);
/*      */ 
/*  390 */         rs = pstmt.executeQuery();
/*      */ 
/*  397 */         boolean have_OS_UNCOMMITTED = false;
/*  398 */         boolean have_OS_UNCOMMITTED_HIDDEN = false;
/*  399 */         boolean have_OS_COMMITTED = false;
/*  400 */         boolean have_OS_COMMITTED_HIDDEN = false;
/*      */ 
/*  402 */         while (rs.next())
/*      */         {
/*  405 */           int stateStatus = rs.getInt(1);
/*      */ 
/*  407 */           switch (stateStatus)
/*      */           {
/*      */           case 2:
/*  410 */             have_OS_UNCOMMITTED = true;
/*  411 */             break;
/*      */           case 1:
/*  413 */             have_OS_COMMITTED = true;
/*  414 */             break;
/*      */           case 5:
/*  416 */             have_OS_COMMITTED_HIDDEN = true;
/*  417 */             break;
/*      */           case 6:
/*  419 */             have_OS_UNCOMMITTED_HIDDEN = true;
/*      */           case 3:
/*      */           case 4:
/*      */           }
/*      */         }
/*      */ 
/*  425 */         if (have_OS_COMMITTED_HIDDEN)
/*      */         {
/*  427 */           theState = 5;
/*      */         }
/*  429 */         if (have_OS_COMMITTED)
/*      */         {
/*  431 */           theState = 1;
/*      */         }
/*  433 */         if (have_OS_UNCOMMITTED_HIDDEN)
/*      */         {
/*  435 */           theState = 6;
/*      */         }
/*  437 */         if (have_OS_UNCOMMITTED)
/*      */         {
/*  439 */           theState = 2;
/*      */         }
/*      */       }
/*      */       catch (Throwable e)
/*      */       {
/*  444 */         cleanup = false;
/*      */         try
/*      */         {
/*  447 */           if (rs != null) {
/*  448 */             rs.close();
/*      */           }
/*      */         }
/*      */         catch (SQLException re)
/*      */         {
/*      */         }
/*  454 */         if (retryConnection(e, pool))
/*      */         {
/*  456 */           re = currentState(objUid, typeName, tableName);
/*      */           return re;
/*      */         }
/*  460 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.JDBCImple_3", new Object[] { e });
/*      */ 
/*  466 */         re = 0;
/*      */         return re;
/*      */       }
/*      */       finally
/*      */       {
/*  471 */         if (cleanup)
/*      */         {
/*      */           try
/*      */           {
/*  475 */             if (rs != null) {
/*  476 */               rs.close();
/*      */             }
/*      */           }
/*      */           catch (SQLException e)
/*      */           {
/*      */           }
/*  482 */           freePool(pool);
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  487 */     return theState;
/*      */   }
/*      */ 
/*      */   public boolean allObjUids(String typeName, InputObjectState state, int match, String tableName)
/*      */     throws ObjectStoreException
/*      */   {
/*  504 */     int pool = getPool();
/*      */     try
/*      */     {
/*  508 */       OutputObjectState store = new OutputObjectState();
/*  509 */       Statement stmt = this._theConnection[pool].createStatement();
/*  510 */       ResultSet rs = null;
/*      */       try
/*      */       {
/*  517 */         rs = stmt.executeQuery("SELECT DISTINCT UidString FROM " + tableName + " WHERE TypeName = '" + typeName + "'");
/*      */ 
/*  520 */         boolean finished = false;
/*      */ 
/*  522 */         while ((!finished) && (rs.next()))
/*      */         {
/*  524 */           Uid theUid = null;
/*      */           try
/*      */           {
/*  528 */             theUid = new Uid(rs.getString(1));
/*  529 */             theUid.pack(store);
/*      */           }
/*      */           catch (IOException ex)
/*      */           {
/*  533 */             if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/*  534 */               tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.JDBCImple_5", new Object[] { ex });
/*      */             }
/*      */ 
/*  540 */             int i = 0;
/*      */             try
/*      */             {
/*  568 */               if (rs != null) {
/*  569 */                 rs.close();
/*      */               }
/*      */             }
/*      */             catch (SQLException e)
/*      */             {
/*      */             }
/*      */             try
/*      */             {
/*  577 */               if (stmt != null) {
/*  578 */                 stmt.close();
/*      */               }
/*      */ 
/*      */             }
/*      */             catch (SQLException e)
/*      */             {
/*      */             }
/*      */ 
/*  613 */             freePool(pool); return i;
/*      */           }
/*      */           catch (Exception e)
/*      */           {
/*  544 */             if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/*  545 */               tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.JDBCImple_4", new Object[] { e });
/*      */             }
/*      */ 
/*  551 */             finished = true;
/*      */           }
/*      */         }
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*  557 */         if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/*  558 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.JDBCImple_4", new Object[] { e });
/*      */         }
/*      */ 
/*      */       }
/*      */       finally
/*      */       {
/*      */         try
/*      */         {
/*  568 */           if (rs != null) {
/*  569 */             rs.close();
/*      */           }
/*      */         }
/*      */         catch (SQLException e)
/*      */         {
/*      */         }
/*      */         try
/*      */         {
/*  577 */           if (stmt != null) {
/*  578 */             stmt.close();
/*      */           }
/*      */         }
/*      */         catch (SQLException e)
/*      */         {
/*      */         }
/*      */       }
/*      */ 
/*      */       try
/*      */       {
/*  588 */         Uid.nullUid().pack(store);
/*      */       }
/*      */       catch (IOException e)
/*      */       {
/*  592 */         throw new ObjectStoreException("allObjUids - could not pack end of list Uid.");
/*      */       }
/*      */ 
/*  596 */       state.setBuffer(store.buffer());
/*      */ 
/*  598 */       store = null;
/*      */ 
/*  600 */       e = 1;
/*      */       return e;
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  604 */       if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/*  605 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.JDBCImple_4", new Object[] { e });
/*      */       }
/*      */ 
/*      */     }
/*      */     finally
/*      */     {
/*  613 */       freePool(pool);
/*      */     }
/*      */ 
/*  616 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean allTypes(InputObjectState foundTypes, String tableName)
/*      */     throws ObjectStoreException
/*      */   {
/*  633 */     int pool = getPool();
/*      */     try
/*      */     {
/*  637 */       OutputObjectState store = new OutputObjectState();
/*  638 */       Statement stmt = this._theConnection[pool].createStatement();
/*  639 */       ResultSet rs = null;
/*      */       try
/*      */       {
/*  646 */         rs = stmt.executeQuery("SELECT DISTINCT TypeName FROM " + tableName);
/*      */ 
/*  649 */         boolean finished = false;
/*      */ 
/*  651 */         while ((!finished) && (rs.next()))
/*      */         {
/*      */           try
/*      */           {
/*  655 */             String type = rs.getString(1);
/*  656 */             store.packString(type);
/*      */           }
/*      */           catch (IOException ex)
/*      */           {
/*  660 */             if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/*  661 */               tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.JDBCImple_7", new Object[] { ex });
/*      */             }
/*      */ 
/*  667 */             int i = 0;
/*      */             try
/*      */             {
/*  695 */               if (rs != null) {
/*  696 */                 rs.close();
/*      */               }
/*      */             }
/*      */             catch (SQLException e)
/*      */             {
/*      */             }
/*      */             try
/*      */             {
/*  704 */               if (stmt != null) {
/*  705 */                 stmt.close();
/*      */               }
/*      */ 
/*      */             }
/*      */             catch (SQLException e)
/*      */             {
/*      */             }
/*      */ 
/*  737 */             freePool(pool); return i;
/*      */           }
/*      */           catch (Exception e)
/*      */           {
/*  671 */             if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/*  672 */               tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.JDBCImple_6", new Object[] { e });
/*      */             }
/*      */ 
/*  678 */             finished = true;
/*      */           }
/*      */         }
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*  684 */         if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/*  685 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.JDBCImple_6", new Object[] { e });
/*      */         }
/*      */ 
/*      */       }
/*      */       finally
/*      */       {
/*      */         try
/*      */         {
/*  695 */           if (rs != null) {
/*  696 */             rs.close();
/*      */           }
/*      */         }
/*      */         catch (SQLException e)
/*      */         {
/*      */         }
/*      */         try
/*      */         {
/*  704 */           if (stmt != null) {
/*  705 */             stmt.close();
/*      */           }
/*      */         }
/*      */         catch (SQLException e)
/*      */         {
/*      */         }
/*      */       }
/*      */ 
/*      */       try
/*      */       {
/*  715 */         store.packString("");
/*      */       }
/*      */       catch (IOException e)
/*      */       {
/*  719 */         throw new ObjectStoreException(tsLogger.arjLoggerI18N.getString("com.arjuna.ats.internal.arjuna.objectstore.packProblem"));
/*      */       }
/*      */ 
/*  722 */       foundTypes.setBuffer(store.buffer());
/*      */ 
/*  724 */       e = 1;
/*      */       return e;
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  728 */       if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/*  729 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.JDBCImple_6", new Object[] { e });
/*      */       }
/*      */ 
/*      */     }
/*      */     finally
/*      */     {
/*  737 */       freePool(pool);
/*      */     }
/*      */ 
/*  740 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean remove_state(Uid objUid, String name, int ft, String tableName)
/*      */     throws ObjectStoreException
/*      */   {
/*  759 */     boolean removeOk = false;
/*  760 */     boolean cleanup = true;
/*      */ 
/*  762 */     if (!storeValid()) {
/*  763 */       return false;
/*      */     }
/*  765 */     if (name != null)
/*      */     {
/*  767 */       if ((ft == 1) || (ft == 2))
/*      */       {
/*  770 */         int pool = getPool();
/*      */         try
/*      */         {
/*  774 */           PreparedStatement pstmt = this._preparedStatements[pool][5];
/*      */ 
/*  776 */           if (pstmt == null)
/*      */           {
/*  778 */             pstmt = this._theConnection[pool].prepareStatement("DELETE FROM " + tableName + " WHERE UidString = ? AND TypeName = ? AND StateType = ?");
/*      */ 
/*  783 */             this._preparedStatements[pool][5] = pstmt;
/*      */           }
/*      */ 
/*  786 */           pstmt.setString(1, objUid.stringForm());
/*  787 */           pstmt.setString(2, name);
/*  788 */           pstmt.setInt(3, ft);
/*  789 */           if (pstmt.executeUpdate() > 0)
/*      */           {
/*  791 */             removeOk = true;
/*      */           }
/*      */         }
/*      */         catch (Throwable e)
/*      */         {
/*  796 */           cleanup = false;
/*  797 */           if (retryConnection(e, pool))
/*      */           {
/*  799 */             boolean bool1 = remove_state(objUid, name, ft, tableName);
/*      */             return bool1;
/*      */           }
/*  803 */           if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/*  804 */             tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.JDBCImple_8", new Object[] { e });
/*      */           }
/*      */ 
/*  810 */           removeOk = false;
/*      */         }
/*      */         finally
/*      */         {
/*  815 */           if (cleanup)
/*  816 */             freePool(pool);
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/*  821 */         removeOk = false;
/*      */ 
/*  823 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */         {
/*  825 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.JDBCImple_9", new Object[] { new Integer(ft), objUid });
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/*  835 */       removeOk = false;
/*      */ 
/*  837 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */       {
/*  839 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.JDBCImple_10", new Object[] { objUid });
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  847 */     return removeOk;
/*      */   }
/*      */ 
/*      */   public abstract InputObjectState read_state(Uid paramUid, String paramString1, int paramInt, String paramString2)
/*      */     throws ObjectStoreException;
/*      */ 
/*      */   public abstract boolean write_state(Uid paramUid, String paramString1, OutputObjectState paramOutputObjectState, int paramInt, String paramString2)
/*      */     throws ObjectStoreException;
/*      */ 
/*      */   public boolean initialise(Connection conn, JDBCAccess jdbcAccess, String tableName)
/*      */     throws SQLException
/*      */   {
/*  873 */     String poolSizeInitStr = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.objectstore.jdbcPoolSizeInitial");
/*      */ 
/*  875 */     String poolSizeMaxStr = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.objectstore.jdbcPoolSizeMaximum");
/*      */ 
/*  878 */     if (poolSizeInitStr != null)
/*      */     {
/*      */       try
/*      */       {
/*  882 */         this._poolSizeInit = Integer.parseInt(poolSizeInitStr);
/*  883 */         if (this._poolSizeInit < 1)
/*      */         {
/*  885 */           this._poolSizeInit = 1;
/*  886 */           if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */           {
/*  888 */             tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.JDBCImple_11", new Object[] { poolSizeInitStr });
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*  898 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */         {
/*  900 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.JDBCImple_11", new Object[] { poolSizeInitStr });
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  909 */     if (poolSizeMaxStr != null)
/*      */     {
/*      */       try
/*      */       {
/*  913 */         this._poolSizeMax = Integer.parseInt(poolSizeMaxStr);
/*  914 */         if (this._poolSizeMax < this._poolSizeInit)
/*      */         {
/*  916 */           this._poolSizeMax = this._poolSizeInit;
/*  917 */           if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */           {
/*  919 */             tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.JDBCImple_12", new Object[] { poolSizeMaxStr });
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*  929 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */         {
/*  931 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.JDBCImple_12", new Object[] { poolSizeMaxStr });
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  940 */     this._poolPutConn = "yes".equalsIgnoreCase(arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.objectstore.jdbcPoolPutConnections"));
/*      */ 
/*  943 */     this._jdbcAccess = jdbcAccess;
/*  944 */     this._theConnection = new Connection[this._poolSizeMax];
/*  945 */     this._theConnection[0] = conn;
/*      */     try
/*      */     {
/*  949 */       for (int i = 1; i < this._poolSizeInit; i++)
/*      */       {
/*  951 */         this._theConnection[i] = this._jdbcAccess.getConnection();
/*  952 */         this._theConnection[i].setAutoCommit(true);
/*      */       }
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  957 */       if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/*  958 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.JDBCImple_13", new Object[] { e });
/*      */       }
/*      */ 
/*  964 */       this._isValid = false;
/*  965 */       return this._isValid;
/*      */     }
/*      */ 
/*  968 */     for (int i = this._poolSizeInit; i < this._poolSizeMax; i++)
/*      */     {
/*  970 */       this._theConnection[i] = null;
/*      */     }
/*  972 */     if (this._inUse == null)
/*      */     {
/*  974 */       this._inUse = new boolean[this._poolSizeMax];
/*      */     }
/*      */ 
/*  977 */     this._preparedStatements = new PreparedStatement[this._poolSizeMax][];
/*      */ 
/*  979 */     for (int i = 0; i < this._poolSizeMax; i++)
/*      */     {
/*  981 */       this._preparedStatements[i] = new PreparedStatement[11];
/*      */ 
/*  983 */       for (int j = 0; j < 11; j++)
/*      */       {
/*  985 */         this._preparedStatements[i][j] = null;
/*      */       }
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  991 */       Statement stmt = this._theConnection[0].createStatement();
/*      */ 
/*  997 */       if (jdbcAccess.dropTable())
/*      */       {
/*      */         try
/*      */         {
/* 1001 */           stmt.executeUpdate("DROP TABLE " + tableName);
/*      */         }
/*      */         catch (SQLException ex)
/*      */         {
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */       try
/*      */       {
/* 1013 */         createTable(stmt, tableName);
/*      */       }
/*      */       catch (SQLException ex)
/*      */       {
/*      */       }
/*      */ 
/* 1020 */       this._isValid = true;
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/* 1024 */       if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/* 1025 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.JDBCImple_13", new Object[] { e });
/*      */       }
/*      */ 
/* 1031 */       this._isValid = false;
/*      */     }
/*      */ 
/* 1034 */     return this._isValid;
/*      */   }
/*      */ 
/*      */   protected void addTable(String tableName)
/*      */     throws Exception
/*      */   {
/* 1043 */     int pool = getPool();
/* 1044 */     Statement stmt = this._theConnection[pool].createStatement();
/*      */     try
/*      */     {
/* 1048 */       createTable(stmt, tableName);
/*      */     }
/*      */     catch (SQLException ex)
/*      */     {
/*      */     }
/*      */     finally
/*      */     {
/* 1056 */       freePool(pool);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected abstract void createTable(Statement paramStatement, String paramString)
/*      */     throws SQLException;
/*      */ 
/*      */   public abstract String name();
/*      */ 
/*      */   protected final int getState(String state)
/*      */   {
/*      */     try
/*      */     {
/* 1081 */       Integer st = (Integer)this.stateCache.get(state);
/*      */ 
/* 1083 */       if (st != null)
/*      */       {
/* 1085 */         return st.intValue();
/*      */       }
/*      */     }
/*      */     catch (Exception ex)
/*      */     {
/* 1090 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */       {
/* 1092 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.JDBCImple_14", new Object[] { ex });
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1100 */     return 0;
/*      */   }
/*      */ 
/*      */   protected final void addToCache(Uid state, int status)
/*      */   {
/* 1105 */     if (this.shareStatus == 14)
/*      */     {
/* 1107 */       this.stateCache.put(state, new Integer(status));
/*      */     }
/*      */   }
/*      */ 
/*      */   protected final void removeFromCache(String state)
/*      */   {
/* 1113 */     removeFromCache(state, true);
/*      */   }
/*      */ 
/*      */   protected final void removeFromCache(String state, boolean warn)
/*      */   {
/* 1125 */     if (this.shareStatus == 14)
/*      */     {
/* 1127 */       if ((this.stateCache.remove(state) == null) && (warn))
/*      */       {
/* 1129 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */         {
/* 1131 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.JDBCImple_15", new Object[] { state });
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   final void setShareStatus(int status)
/*      */   {
/* 1143 */     this.shareStatus = status;
/*      */   }
/*      */ 
/*      */   protected boolean retryConnection(Throwable e, int pool)
/*      */   {
/* 1162 */     if ((e instanceof SQLException))
/*      */     {
/*      */       try
/*      */       {
/* 1167 */         reconnect(pool);
/*      */       }
/*      */       catch (Exception e1)
/*      */       {
/* 1171 */         return false;
/*      */       }
/* 1173 */       synchronized (this._inUse)
/*      */       {
/* 1175 */         this._inUse[pool] = true;
/*      */       }
/* 1177 */       freePool(pool);
/* 1178 */       return true;
/*      */     }
/*      */ 
/* 1181 */     return false;
/*      */   }
/*      */ 
/*      */   protected void reconnect(int pool)
/*      */     throws SQLException
/*      */   {
/* 1189 */     Connection newConnection = this._theConnection[pool];
/* 1190 */     this._theConnection[pool] = null;
/*      */     try
/*      */     {
/* 1196 */       newConnection.close();
/*      */     }
/*      */     catch (SQLException e)
/*      */     {
/*      */     }
/* 1201 */     this._jdbcAccess.putConnection(newConnection);
/*      */ 
/* 1205 */     for (int i = 0; i < 11; i++)
/*      */     {
/* 1207 */       this._preparedStatements[pool][i] = null;
/*      */     }
/*      */ 
/* 1211 */     newConnection = this._jdbcAccess.getConnection();
/*      */     try
/*      */     {
/* 1214 */       newConnection.setAutoCommit(true);
/*      */     }
/*      */     catch (SQLException e)
/*      */     {
/* 1218 */       newConnection = null;
/* 1219 */       throw e;
/*      */     }
/* 1221 */     this._theConnection[pool] = newConnection;
/*      */   }
/*      */ 
/*      */   protected int getPool()
/*      */   {
/* 1238 */     int i = 0;
/* 1239 */     int rtn = -1;
/*      */ 
/* 1241 */     synchronized (this._inUse)
/*      */     {
/*      */       while (true)
/*      */       {
/* 1245 */         if (this._inUse[i] == 0)
/*      */         {
/* 1247 */           if (this._theConnection[i] == null)
/*      */           {
/*      */             try
/*      */             {
/* 1254 */               this._theConnection[i] = this._jdbcAccess.getConnection();
/* 1255 */               this._inUse[i] = true;
/* 1256 */               rtn = i;
/*      */             }
/*      */             catch (Exception e)
/*      */             {
/* 1261 */               if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/* 1262 */                 tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.JDBCImple_16", new Object[] { e });
/*      */               }
/*      */ 
/* 1267 */               break label103;
/*      */             }
/*      */           }
/*      */           else {
/* 1271 */             this._inUse[i] = true;
/* 1272 */             rtn = i;
/* 1273 */             break;
/*      */           }
/*      */         }
/*      */ 
/* 1277 */         label103: i++;
/* 1278 */         if (i != this._poolSizeMax)
/*      */           continue;
/* 1280 */         i = 0;
/*      */         try
/*      */         {
/* 1283 */           this._inUse.wait();
/*      */         }
/*      */         catch (InterruptedException ie)
/*      */         {
/* 1287 */           if (tsLogger.arjLoggerI18N.isInfoEnabled())
/*      */           {
/* 1289 */             tsLogger.arjLoggerI18N.info("com.arjuna.ats.internal.arjuna.objectstore.JDBCImple_17");
/*      */           }
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1297 */     return rtn;
/*      */   }
/*      */ 
/*      */   protected void freePool(int pool)
/*      */   {
/* 1313 */     synchronized (this._inUse)
/*      */     {
/* 1315 */       if (this._inUse[pool] == 0)
/*      */       {
/* 1317 */         if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/* 1318 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.JDBCImple_18");
/*      */         }
/*      */       }
/* 1321 */       this._inUse[pool] = false;
/* 1322 */       this._inUse.notifyAll();
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.arjuna.objectstore.JDBCImple
 * JD-Core Version:    0.6.0
 */