/*     */ package com.arjuna.ats.internal.arjuna.objectstore;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.ArjunaNames;
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.common.arjPropertyManager;
/*     */ import com.arjuna.ats.arjuna.exceptions.FatalError;
/*     */ import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
/*     */ import com.arjuna.ats.arjuna.gandiva.ClassName;
/*     */ import com.arjuna.ats.arjuna.gandiva.ObjectName;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.ats.arjuna.objectstore.ObjectStore;
/*     */ import com.arjuna.ats.arjuna.state.InputObjectState;
/*     */ import com.arjuna.ats.arjuna.state.OutputObjectState;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import com.arjuna.common.util.propertyservice.PropertyManager;
/*     */ import java.io.File;
/*     */ import java.io.IOException;
/*     */ import java.util.ResourceBundle;
/*     */ 
/*     */ public class HashedStore extends ShadowNoFileLockStore
/*     */ {
/*     */   public static final char SHADOWCHAR = '!';
/*     */   private static final int DEFAULT_NUMBER_DIRECTORIES = 255;
/*     */   private static final String HASH_SEPARATOR = "#";
/* 438 */   private static int NUMBEROFDIRECTORIES = 255;
/*     */ 
/*     */   public int typeIs()
/*     */   {
/*  89 */     return 5;
/*     */   }
/*     */ 
/*     */   public ClassName className()
/*     */   {
/*  94 */     return ArjunaNames.Implementation_ObjectStore_HashedStore();
/*     */   }
/*     */ 
/*     */   public static ClassName name()
/*     */   {
/*  99 */     return ArjunaNames.Implementation_ObjectStore_HashedStore();
/*     */   }
/*     */ 
/*     */   public static ShadowingStore create()
/*     */   {
/* 109 */     return new HashedStore("");
/*     */   }
/*     */ 
/*     */   public static ShadowingStore create(Object[] param)
/*     */   {
/* 114 */     if (param == null) {
/* 115 */       return null;
/*     */     }
/* 117 */     String location = (String)param[0];
/* 118 */     Integer shareStatus = (Integer)param[1];
/* 119 */     int ss = 14;
/*     */ 
/* 121 */     if (shareStatus != null)
/*     */     {
/*     */       try
/*     */       {
/* 125 */         if (shareStatus.intValue() == 13)
/* 126 */           ss = 13;
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 130 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */         {
/* 132 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.HashedStore_1", new Object[] { e });
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 138 */     return new HashedStore(location, ss);
/*     */   }
/*     */ 
/*     */   public static ShadowingStore create(ObjectName param)
/*     */   {
/* 143 */     if (param == null) {
/* 144 */       return null;
/*     */     }
/* 146 */     return new HashedStore(param);
/*     */   }
/*     */ 
/*     */   public boolean allObjUids(String tName, InputObjectState state, int match)
/*     */     throws ObjectStoreException
/*     */   {
/* 156 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 158 */       tsLogger.arjLogger.debug(16L, 4L, 16L, "HashedStore.allObjUids(" + tName + ", " + state + ", " + match + ")");
/*     */     }
/*     */ 
/* 167 */     String directory = locateStore(getStoreName());
/* 168 */     OutputObjectState store = new OutputObjectState();
/*     */ 
/* 172 */     if ((tName != null) && (tName.charAt(0) == File.separatorChar))
/* 173 */       directory = directory + tName.substring(1, tName.length());
/*     */     else {
/* 175 */       directory = directory + tName;
/*     */     }
/* 177 */     if (!directory.endsWith(File.separator)) {
/* 178 */       directory = directory + File.separator;
/*     */     }
/* 180 */     File f = new File(directory);
/* 181 */     String[] entry = f.list();
/*     */ 
/* 183 */     if ((entry != null) && (entry.length > 0))
/*     */     {
/* 185 */       for (int i = 0; i < entry.length; i++)
/*     */       {
/* 187 */         if ((!Character.isDigit(entry[i].charAt(1))) && (!entry[i].startsWith("#")))
/*     */           continue;
/* 189 */         File dir = new File(directory + entry[i]);
/*     */ 
/* 191 */         if (!dir.isDirectory())
/*     */           continue;
/* 193 */         String[] dirEnt = dir.list();
/*     */ 
/* 195 */         for (int j = 0; j < dirEnt.length; j++)
/*     */         {
/*     */           try
/*     */           {
/* 199 */             Uid aUid = new Uid(dirEnt[j], true);
/*     */ 
/* 201 */             if ((!aUid.valid()) || (aUid.equals(Uid.nullUid())))
/*     */             {
/* 203 */               String revealed = revealedId(dirEnt[j]);
/*     */ 
/* 207 */               if (present(revealed, dirEnt))
/* 208 */                 aUid = null;
/*     */               else {
/* 210 */                 aUid = new Uid(revealed);
/*     */               }
/*     */             }
/* 213 */             if ((aUid.notEquals(Uid.nullUid())) && ((match == 0) || (isType(aUid, tName, match))))
/*     */             {
/* 216 */               aUid.pack(store);
/*     */             }
/*     */ 
/*     */           }
/*     */           catch (NumberFormatException e)
/*     */           {
/*     */           }
/*     */           catch (IOException e)
/*     */           {
/* 227 */             throw new ObjectStoreException(tsLogger.log_mesg.getString("com.arjuna.ats.internal.arjuna.objectstore.HashedStore_5"));
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 243 */       Uid.nullUid().pack(store);
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 247 */       throw new ObjectStoreException(tsLogger.log_mesg.getString("com.arjuna.ats.internal.arjuna.objectstore.HashedStore_6"));
/*     */     }
/*     */ 
/* 250 */     state.setBuffer(store.buffer());
/*     */ 
/* 252 */     store = null;
/*     */ 
/* 254 */     return true;
/*     */   }
/*     */ 
/*     */   protected HashedStore()
/*     */   {
/* 263 */     this(14);
/*     */   }
/*     */ 
/*     */   protected HashedStore(int shareStatus)
/*     */   {
/* 268 */     super(shareStatus);
/*     */ 
/* 270 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 272 */       tsLogger.arjLogger.debug(16L, 2L, 16L, "HashedStore.HashedStore( " + shareStatus + " )");
/*     */     }
/*     */   }
/*     */ 
/*     */   protected HashedStore(String locationOfStore)
/*     */   {
/* 279 */     this(locationOfStore, 14);
/*     */   }
/*     */ 
/*     */   protected HashedStore(String locationOfStore, int shareStatus)
/*     */   {
/* 284 */     super(shareStatus);
/*     */ 
/* 286 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 288 */       tsLogger.arjLogger.debug(16L, 2L, 16L, "HashedStore.HashedStore(" + locationOfStore + ")");
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 294 */       setupStore(locationOfStore);
/*     */     }
/*     */     catch (ObjectStoreException e)
/*     */     {
/* 298 */       tsLogger.arjLogger.warn(e.getMessage());
/*     */ 
/* 300 */       throw new FatalError(e.toString());
/*     */     }
/*     */   }
/*     */ 
/*     */   protected HashedStore(ObjectName objName)
/*     */   {
/* 306 */     super(objName);
/*     */ 
/* 308 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 310 */       tsLogger.arjLogger.debug(16L, 2L, 16L, "HashedStore.HashedStore(" + objName + ")");
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 316 */       setupStore("");
/*     */     }
/*     */     catch (ObjectStoreException e)
/*     */     {
/* 320 */       tsLogger.arjLogger.warn(e.getMessage());
/*     */ 
/* 322 */       throw new FatalError(e.toString());
/*     */     }
/*     */   }
/*     */ 
/*     */   protected String truncate(String value)
/*     */   {
/* 328 */     int lastIndex = value.lastIndexOf("#");
/* 329 */     String toReturn = value;
/*     */ 
/* 331 */     if (lastIndex != -1)
/*     */     {
/* 333 */       int nextIndex = value.lastIndexOf("#", lastIndex - 1);
/*     */ 
/* 335 */       if (nextIndex != -1)
/*     */       {
/* 337 */         char[] bitInbetween = new char[lastIndex - nextIndex - 1];
/* 338 */         boolean isDigit = true;
/*     */ 
/* 340 */         value.getChars(nextIndex + 1, lastIndex, bitInbetween, 0);
/*     */ 
/* 342 */         for (int i = 0; (i < bitInbetween.length) && (isDigit); i++)
/*     */         {
/* 344 */           if (Character.isDigit(bitInbetween[i]))
/*     */             continue;
/* 346 */           isDigit = false;
/*     */         }
/*     */ 
/* 350 */         if (isDigit) {
/* 351 */           toReturn = value.substring(lastIndex + 1);
/*     */         }
/*     */       }
/*     */     }
/* 355 */     return toReturn;
/*     */   }
/*     */ 
/*     */   protected String genPathName(Uid objUid, String tName, int otype)
/*     */     throws ObjectStoreException
/*     */   {
/* 365 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 367 */       tsLogger.arjLogger.debug(16L, 2L, 16L, "HashedStore.genPathName(" + objUid + ", " + tName + ", " + ObjectStore.stateTypeString(otype) + ")");
/*     */     }
/*     */ 
/* 372 */     String storeName = locateStore(getStoreName());
/* 373 */     String fname = null;
/* 374 */     String cPtr = null;
/* 375 */     int uidHash = objUid.hashCode();
/* 376 */     String os = objUid.fileStringForm();
/* 377 */     String hashDir = "#" + uidHash % NUMBEROFDIRECTORIES + "#" + File.separator;
/*     */ 
/* 379 */     if ((tName == null) || (tName.length() == 0)) {
/* 380 */       cPtr = "";
/*     */     }
/*     */     else {
/* 383 */       cPtr = tName;
/*     */ 
/* 389 */       if ((FileSystemStore.rewriteSeparator) && (cPtr.indexOf('/') != -1))
/*     */       {
/* 391 */         cPtr = cPtr.replace('/', File.separatorChar);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 400 */     if (cPtr.charAt(0) == File.separatorChar) {
/* 401 */       cPtr = cPtr.substring(1, cPtr.length());
/*     */     }
/* 403 */     if (cPtr.charAt(cPtr.length() - 1) != File.separatorChar)
/* 404 */       fname = storeName + cPtr + File.separator + hashDir + os;
/*     */     else {
/* 406 */       fname = storeName + cPtr + hashDir + os;
/*     */     }
/*     */ 
/* 412 */     if (fname.charAt(fname.length() - 1) == File.separatorChar) {
/* 413 */       fname = fname.substring(0, fname.length() - 2);
/*     */     }
/*     */ 
/* 416 */     if (otype == 10) {
/* 417 */       fname = fname + '!';
/*     */     }
/* 419 */     return fname;
/*     */   }
/*     */ 
/*     */   private final boolean present(String id, String[] list)
/*     */   {
/* 426 */     for (int i = 0; i < list.length; i++)
/*     */     {
/* 428 */       if (list[i].equals(id)) {
/* 429 */         return true;
/*     */       }
/*     */     }
/* 432 */     return false;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/* 442 */     String numberOfDirs = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.objectstore.hashedDirectories");
/*     */ 
/* 444 */     if (numberOfDirs != null)
/*     */     {
/*     */       try
/*     */       {
/* 448 */         Integer i = new Integer(numberOfDirs);
/*     */ 
/* 450 */         NUMBEROFDIRECTORIES = i.intValue();
/*     */ 
/* 452 */         if (NUMBEROFDIRECTORIES <= 0)
/*     */         {
/* 454 */           if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */           {
/* 456 */             tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.HashedStore_2", new Object[] { numberOfDirs });
/*     */           }
/*     */ 
/* 460 */           NUMBEROFDIRECTORIES = 255;
/*     */         }
/*     */       }
/*     */       catch (NumberFormatException e)
/*     */       {
/* 465 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */         {
/* 467 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.HashedStore_3", new Object[] { numberOfDirs });
/*     */         }
/*     */ 
/* 471 */         throw new FatalError("Invalid hash directory number: " + numberOfDirs);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 475 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */         {
/* 477 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.HashedStore_4", new Object[] { e });
/*     */         }
/*     */ 
/* 481 */         throw new FatalError(e.toString());
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.arjuna.objectstore.HashedStore
 * JD-Core Version:    0.6.0
 */