/*     */ package com.arjuna.ats.internal.arjuna.objectstore;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.ArjunaNames;
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.common.arjPropertyManager;
/*     */ import com.arjuna.ats.arjuna.exceptions.FatalError;
/*     */ import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
/*     */ import com.arjuna.ats.arjuna.gandiva.ClassName;
/*     */ import com.arjuna.ats.arjuna.gandiva.ObjectName;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.ats.arjuna.objectstore.ObjectStoreImple;
/*     */ import com.arjuna.ats.arjuna.state.InputBuffer;
/*     */ import com.arjuna.ats.arjuna.state.InputObjectState;
/*     */ import com.arjuna.ats.arjuna.state.OutputBuffer;
/*     */ import com.arjuna.ats.arjuna.state.OutputObjectState;
/*     */ import com.arjuna.ats.arjuna.utils.FileLock;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import com.arjuna.common.util.propertyservice.PropertyManager;
/*     */ import java.io.File;
/*     */ import java.io.IOException;
/*     */ import java.util.Hashtable;
/*     */ import java.util.ResourceBundle;
/*     */ 
/*     */ public abstract class FileSystemStore extends ObjectStoreImple
/*     */ {
/*     */   static final char unixSeparator = '/';
/* 796 */   static boolean rewriteSeparator = false;
/*     */ 
/* 800 */   protected boolean syncWrites = true;
/*     */   private String fullStoreName;
/*     */   private String localStoreRoot;
/*     */   private boolean isValid;
/*     */   private static final int MAXPNAMELEN = 255;
/*     */   private static final int MAXNAMELENGTH = 255;
/*     */   private static final int SLOP = 9;
/* 816 */   private static boolean doSync = true;
/* 817 */   private static Hashtable fileCache = new Hashtable();
/* 818 */   private static int createRetry = 100;
/* 819 */   private static int createTimeout = 100;
/*     */ 
/*     */   public FileSystemStore(String locationOfStore, int ss)
/*     */   {
/*  83 */     super(ss);
/*     */ 
/*  85 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/*  87 */       tsLogger.arjLogger.debug(1L, 4L, 16L, "FileSystemStore.FileSystemStore(" + locationOfStore + ")");
/*     */     }
/*     */ 
/*  92 */     this.fullStoreName = null;
/*  93 */     this.localStoreRoot = null;
/*  94 */     this.isValid = true;
/*     */     try
/*     */     {
/*  98 */       setupStore(locationOfStore);
/*     */     }
/*     */     catch (ObjectStoreException e)
/*     */     {
/* 102 */       this.isValid = false;
/*     */ 
/* 104 */       tsLogger.arjLogger.warn(e.getMessage());
/*     */ 
/* 106 */       throw new FatalError(e.toString());
/*     */     }
/*     */   }
/*     */ 
/*     */   public FileSystemStore(ObjectName objName)
/*     */   {
/* 118 */     super(objName);
/*     */ 
/* 120 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 122 */       tsLogger.arjLogger.debug(1L, 4L, 16L, "FileSystemStore.FileSystemStore(" + objName + ")");
/*     */     }
/*     */ 
/* 126 */     this.fullStoreName = null;
/* 127 */     this.localStoreRoot = null;
/* 128 */     this.isValid = true;
/*     */     try
/*     */     {
/* 132 */       setupStore("");
/*     */     }
/*     */     catch (ObjectStoreException e)
/*     */     {
/* 136 */       this.isValid = false;
/*     */ 
/* 138 */       tsLogger.arjLogger.warn(e.getMessage());
/*     */ 
/* 140 */       throw new FatalError(e.toString());
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getStoreName()
/*     */   {
/* 146 */     return this.localStoreRoot;
/*     */   }
/*     */ 
/*     */   public InputObjectState read_committed(Uid storeUid, String tName)
/*     */     throws ObjectStoreException
/*     */   {
/* 156 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 158 */       tsLogger.arjLogger.debug(16L, 4L, 16L, "FileSystemStore.read_committed(" + storeUid + ", " + tName + ")");
/*     */     }
/*     */ 
/* 162 */     return read_state(storeUid, tName, 11);
/*     */   }
/*     */ 
/*     */   public InputObjectState read_uncommitted(Uid storeUid, String tName) throws ObjectStoreException
/*     */   {
/* 167 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 169 */       tsLogger.arjLogger.debug(16L, 4L, 16L, "FileSystemStore.read_uncommitted(" + storeUid + ", " + tName + ")");
/*     */     }
/*     */ 
/* 173 */     return read_state(storeUid, tName, 10);
/*     */   }
/*     */ 
/*     */   public boolean remove_committed(Uid storeUid, String tName) throws ObjectStoreException
/*     */   {
/* 178 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 180 */       tsLogger.arjLogger.debug(16L, 4L, 16L, "FileSystemStore.remove_committed(" + storeUid + ", " + tName + ")");
/*     */     }
/*     */ 
/* 185 */     return remove_state(storeUid, tName, 11);
/*     */   }
/*     */ 
/*     */   public boolean remove_uncommitted(Uid storeUid, String tName) throws ObjectStoreException
/*     */   {
/* 190 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 192 */       tsLogger.arjLogger.debug(16L, 4L, 16L, "FileSystemStore.remove_uncommitted(" + storeUid + ", " + tName + ")");
/*     */     }
/*     */ 
/* 197 */     return remove_state(storeUid, tName, 10);
/*     */   }
/*     */ 
/*     */   public boolean write_committed(Uid storeUid, String tName, OutputObjectState state) throws ObjectStoreException
/*     */   {
/* 202 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 204 */       tsLogger.arjLogger.debug(16L, 4L, 16L, "FileSystemStore.write_committed(" + storeUid + ", " + tName + ")");
/*     */     }
/*     */ 
/* 209 */     return write_state(storeUid, tName, state, 11);
/*     */   }
/*     */ 
/*     */   public boolean write_uncommitted(Uid storeUid, String tName, OutputObjectState state) throws ObjectStoreException
/*     */   {
/* 214 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 216 */       tsLogger.arjLogger.debug(16L, 4L, 16L, "FileSystemStore.write_uncommitted(" + storeUid + ", " + tName + ", " + state + ")");
/*     */     }
/*     */ 
/* 221 */     return write_state(storeUid, tName, state, 10);
/*     */   }
/*     */ 
/*     */   public final synchronized boolean storeValid()
/*     */   {
/* 226 */     return this.isValid;
/*     */   }
/*     */ 
/*     */   public final synchronized void makeInvalid()
/*     */   {
/* 231 */     this.isValid = false;
/*     */   }
/*     */ 
/*     */   public final synchronized void makeValid()
/*     */   {
/* 236 */     this.isValid = true;
/*     */   }
/*     */ 
/*     */   public boolean allObjUids(String tName, InputObjectState state, int match)
/*     */     throws ObjectStoreException
/*     */   {
/* 246 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 248 */       tsLogger.arjLogger.debug(16L, 4L, 16L, "FileSystemStore.allObjUids(" + tName + ", " + state + ", " + match + ")");
/*     */     }
/*     */ 
/* 253 */     String directory = null;
/* 254 */     OutputObjectState store = new OutputObjectState();
/*     */ 
/* 260 */     if ((tName != null) && (tName.charAt(0) == File.separatorChar))
/*     */     {
/* 262 */       String s = tName.substring(1, tName.length());
/* 263 */       directory = new String(this.fullStoreName + s);
/*     */     }
/*     */     else {
/* 266 */       directory = new String(this.fullStoreName + tName);
/*     */     }
/* 268 */     File f = new File(directory);
/* 269 */     String[] entry = f.list();
/*     */ 
/* 271 */     if ((entry != null) && (entry.length > 0))
/*     */     {
/* 273 */       for (int i = 0; i < entry.length; i++)
/*     */       {
/*     */         try
/*     */         {
/* 277 */           Uid aUid = new Uid(entry[i], true);
/*     */ 
/* 279 */           if ((!aUid.valid()) || (aUid.equals(Uid.nullUid())))
/*     */           {
/* 281 */             String revealed = revealedId(entry[i]);
/*     */ 
/* 285 */             if (present(revealed, entry))
/* 286 */               aUid = null;
/*     */             else {
/* 288 */               aUid = new Uid(revealed);
/*     */             }
/*     */           }
/* 291 */           if ((aUid != null) && (aUid.valid()))
/*     */           {
/* 293 */             if ((aUid.notEquals(Uid.nullUid())) && ((match == 0) || (isType(aUid, tName, match))))
/*     */             {
/* 296 */               aUid.pack(store);
/*     */             }
/*     */ 
/*     */           }
/*     */ 
/*     */         }
/*     */         catch (NumberFormatException e)
/*     */         {
/*     */         }
/*     */         catch (IOException e)
/*     */         {
/* 308 */           throw new ObjectStoreException(tsLogger.log_mesg.getString("com.arjuna.ats.internal.arjuna.objectstore.FileSystemStore_2a"));
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 315 */       Uid.nullUid().pack(store);
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 319 */       throw new ObjectStoreException(tsLogger.log_mesg.getString("com.arjuna.ats.internal.arjuna.objectstore.FileSystemStore_3"));
/*     */     }
/*     */ 
/* 322 */     state.setBuffer(store.buffer());
/*     */ 
/* 324 */     store = null;
/*     */ 
/* 326 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean allTypes(InputObjectState foundTypes) throws ObjectStoreException
/*     */   {
/* 331 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 333 */       tsLogger.arjLogger.debug(16L, 4L, 16L, "FileSystemStore.allTypes(" + foundTypes + ")");
/*     */     }
/*     */ 
/* 337 */     boolean result = true;
/* 338 */     String directory = new String(this.fullStoreName);
/* 339 */     File f = new File(directory);
/* 340 */     String[] entry = f.list();
/*     */ 
/* 342 */     if (entry == null) {
/* 343 */       return true;
/*     */     }
/* 345 */     OutputObjectState store = new OutputObjectState();
/*     */ 
/* 347 */     for (int i = 0; i < entry.length; i++)
/*     */     {
/* 349 */       if (supressEntry(entry[i]))
/*     */         continue;
/* 351 */       File tmpFile = new File(directory + File.separator + entry[i]);
/*     */ 
/* 353 */       if (tmpFile.isDirectory())
/*     */       {
/*     */         try
/*     */         {
/* 357 */           store.packString(entry[i]);
/*     */ 
/* 359 */           result = allTypes(store, entry[i]);
/*     */         }
/*     */         catch (IOException e)
/*     */         {
/* 363 */           throw new ObjectStoreException(tsLogger.log_mesg.getString("com.arjuna.ats.internal.arjuna.objectstore.FileSystemStore_4"));
/*     */         }
/*     */       }
/*     */ 
/* 367 */       tmpFile = null;
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 373 */       store.packString("");
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 377 */       throw new ObjectStoreException(tsLogger.log_mesg.getString("com.arjuna.ats.internal.arjuna.objectstore.FileSystemStore_5"));
/*     */     }
/*     */ 
/* 380 */     foundTypes.setBuffer(store.buffer());
/*     */ 
/* 382 */     return result;
/*     */   }
/*     */ 
/*     */   public synchronized void packInto(OutputBuffer buff) throws IOException
/*     */   {
/* 387 */     if (this.localStoreRoot != null)
/*     */     {
/* 389 */       if (this.localStoreRoot.compareTo("") == 0)
/*     */       {
/* 391 */         buff.packString(null);
/* 392 */         return;
/*     */       }
/*     */     }
/*     */ 
/* 396 */     buff.packString(this.localStoreRoot);
/*     */   }
/*     */ 
/*     */   public synchronized void unpackFrom(InputBuffer buff) throws IOException
/*     */   {
/*     */     try
/*     */     {
/* 403 */       setupStore(buff.unpackString());
/*     */     }
/*     */     catch (ObjectStoreException e)
/*     */     {
/* 407 */       throw new IOException(tsLogger.log_mesg.getString("com.arjuna.ats.internal.arjuna.objectstore.FileSystemStore_6"));
/*     */     }
/*     */   }
/*     */ 
/*     */   public ClassName className()
/*     */   {
/* 413 */     return ArjunaNames.Implementation_ObjectStore_FileSystemStore();
/*     */   }
/*     */ 
/*     */   public static ClassName name()
/*     */   {
/* 418 */     return ArjunaNames.Implementation_ObjectStore_FileSystemStore();
/*     */   }
/*     */ 
/*     */   protected abstract InputObjectState read_state(Uid paramUid, String paramString, int paramInt) throws ObjectStoreException;
/*     */ 
/*     */   protected abstract boolean remove_state(Uid paramUid, String paramString, int paramInt) throws ObjectStoreException;
/*     */ 
/*     */   protected abstract boolean write_state(Uid paramUid, String paramString, OutputObjectState paramOutputObjectState, int paramInt) throws ObjectStoreException;
/*     */ 
/*     */   protected final synchronized void syncOn() {
/* 431 */     doSync = true;
/*     */   }
/*     */ 
/*     */   protected final synchronized void syncOff()
/*     */   {
/* 436 */     doSync = false;
/*     */   }
/*     */ 
/*     */   protected final synchronized boolean synchronousWrites()
/*     */   {
/* 445 */     return (doSync) && (this.syncWrites);
/*     */   }
/*     */ 
/*     */   protected synchronized boolean lock(File fd, int lmode, boolean create)
/*     */   {
/* 454 */     FileLock fileLock = new FileLock(fd);
/*     */ 
/* 456 */     return fileLock.lock(lmode, create);
/*     */   }
/*     */ 
/*     */   protected synchronized boolean unlock(File fd)
/*     */   {
/* 465 */     FileLock fileLock = new FileLock(fd);
/*     */ 
/* 467 */     return fileLock.unlock();
/*     */   }
/*     */ 
/*     */   protected FileSystemStore(int ss)
/*     */   {
/* 472 */     super(ss);
/*     */ 
/* 474 */     this.fullStoreName = null;
/* 475 */     this.localStoreRoot = null;
/* 476 */     this.isValid = true;
/*     */   }
/*     */ 
/*     */   protected boolean allTypes(OutputObjectState foundTypes, String root) throws ObjectStoreException
/*     */   {
/* 481 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 483 */       tsLogger.arjLogger.debug(16L, 2L, 16L, "FileSystemStore.allTypes(" + foundTypes + ", " + root + ")");
/*     */     }
/*     */ 
/* 488 */     boolean result = true;
/* 489 */     String directory = new String(this.fullStoreName + File.separator + root);
/* 490 */     File f = new File(directory);
/* 491 */     String[] entry = f.list();
/*     */ 
/* 493 */     if ((entry != null) && (entry.length > 0))
/*     */     {
/* 495 */       for (int i = 0; i < entry.length; i++)
/*     */       {
/* 497 */         if (supressEntry(entry[i]))
/*     */           continue;
/*     */         try
/*     */         {
/* 501 */           File tmpFile = new File(directory + File.separator + entry[i]);
/*     */ 
/* 503 */           if (tmpFile.isDirectory())
/*     */           {
/* 505 */             String pack = truncate(entry[i]);
/*     */ 
/* 507 */             if (pack.length() > 0)
/*     */             {
/* 509 */               foundTypes.packString(root + File.separator + pack);
/*     */ 
/* 511 */               result = allTypes(foundTypes, root + File.separator + pack);
/*     */             }
/*     */           }
/*     */ 
/* 515 */           tmpFile = null;
/*     */         }
/*     */         catch (IOException e)
/*     */         {
/* 519 */           throw new ObjectStoreException(tsLogger.log_mesg.getString("com.arjuna.ats.internal.arjuna.objectstore.FileSystemStore_7"));
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 525 */     return result;
/*     */   }
/*     */ 
/*     */   protected String genPathName(Uid objUid, String tName, int m)
/*     */     throws ObjectStoreException
/*     */   {
/* 539 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 541 */       tsLogger.arjLogger.debug(16L, 2L, 16L, "FileSystemStore.genPathName(" + objUid + ", " + tName + ", " + m + ")");
/*     */     }
/*     */ 
/* 546 */     String storeName = locateStore(getStoreName());
/* 547 */     String cPtr = null;
/* 548 */     String fname = null;
/* 549 */     String os = objUid.fileStringForm();
/*     */ 
/* 551 */     if ((tName == null) || (tName.length() == 0)) {
/* 552 */       cPtr = "";
/*     */     }
/*     */     else {
/* 555 */       cPtr = tName;
/*     */ 
/* 561 */       if ((rewriteSeparator) && (cPtr.indexOf('/') != -1))
/*     */       {
/* 563 */         cPtr = cPtr.replace('/', File.separatorChar);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 572 */     if (cPtr.charAt(0) == File.separatorChar) {
/* 573 */       cPtr = cPtr.substring(1, cPtr.length());
/*     */     }
/* 575 */     if (cPtr.charAt(cPtr.length() - 1) != File.separatorChar)
/* 576 */       fname = storeName + cPtr + File.separator + os;
/*     */     else {
/* 578 */       fname = storeName + cPtr + os;
/*     */     }
/*     */ 
/* 584 */     if (fname.charAt(fname.length() - 1) == File.separatorChar) {
/* 585 */       fname = fname.substring(0, fname.length() - 2);
/*     */     }
/* 587 */     return fname;
/*     */   }
/*     */ 
/*     */   protected synchronized boolean setupStore(String localOSRoot) throws ObjectStoreException
/*     */   {
/* 592 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 594 */       tsLogger.arjLogger.debug(16L, 2L, 16L, "FileSystemStore.setupStore(" + localOSRoot + ")");
/*     */     }
/*     */ 
/* 598 */     this.isValid = true;
/*     */ 
/* 600 */     if (localOSRoot == null) {
/* 601 */       localOSRoot = "";
/*     */     }
/* 603 */     this.localStoreRoot = localOSRoot;
/* 604 */     this.fullStoreName = locateStore(this.localStoreRoot);
/*     */ 
/* 608 */     if ((this.fullStoreName == null) || (!createHierarchy(this.fullStoreName)))
/*     */     {
/* 610 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */       {
/* 612 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.FileSystemStore_1", new Object[] { this.fullStoreName });
/*     */       }
/*     */ 
/* 616 */       this.isValid = false;
/*     */     }
/*     */ 
/* 619 */     return this.isValid;
/*     */   }
/*     */ 
/*     */   protected boolean supressEntry(String name)
/*     */   {
/* 625 */     return (name.compareTo(".") == 0) || (name.compareTo("..") == 0);
/*     */   }
/*     */ 
/*     */   protected String truncate(String value)
/*     */   {
/* 632 */     return value;
/*     */   }
/*     */ 
/*     */   protected final synchronized boolean createHierarchy(String path)
/*     */     throws ObjectStoreException
/*     */   {
/* 653 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 655 */       tsLogger.arjLogger.debug(16L, 2L, 16L, "FileSystemStore.createHierarchy(" + path + ")");
/*     */     }
/*     */ 
/* 659 */     if ((path != null) && (path.length() > 0))
/*     */     {
/* 661 */       File f = null;
/*     */ 
/* 668 */       if (path.charAt(path.length() - 1) != File.separatorChar)
/*     */       {
/* 670 */         int index = path.lastIndexOf(File.separator);
/*     */ 
/* 672 */         if (index <= 0) {
/* 673 */           return true;
/*     */         }
/* 675 */         f = new File(path.substring(0, index));
/*     */       }
/*     */       else {
/* 678 */         f = new File(path);
/*     */       }
/* 680 */       int retryLimit = createRetry;
/*     */       do
/*     */       {
/* 684 */         if (f.exists())
/*     */         {
/* 686 */           return true;
/*     */         }
/*     */ 
/* 690 */         if (!f.mkdirs())
/*     */         {
/* 692 */           retryLimit--;
/*     */ 
/* 694 */           if (retryLimit == 0) {
/* 695 */             return false;
/*     */           }
/*     */           try
/*     */           {
/* 699 */             Thread.currentThread(); Thread.sleep(createTimeout);
/*     */           }
/*     */           catch (Exception ex)
/*     */           {
/*     */           }
/*     */         }
/*     */         else {
/* 706 */           return true;
/*     */         }
/*     */       }
/* 708 */       while ((!f.exists()) && (retryLimit > 0));
/*     */ 
/* 710 */       return f.exists();
/*     */     }
/*     */ 
/* 713 */     throw new ObjectStoreException(tsLogger.log_mesg.getString("com.arjuna.ats.internal.arjuna.objectstore.FileSystemStore_8"));
/*     */   }
/*     */ 
/*     */   protected final boolean exists(String path)
/*     */   {
/* 729 */     if (this.shareStatus == 14)
/*     */     {
/* 731 */       if (fileCache.get(path) != null) {
/* 732 */         return true;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 740 */     File f = new File(path);
/* 741 */     boolean doesExist = f.exists();
/*     */ 
/* 743 */     if (doesExist) {
/* 744 */       addToCache(path);
/*     */     }
/* 746 */     return doesExist;
/*     */   }
/*     */ 
/*     */   protected final void addToCache(String fname)
/*     */   {
/* 751 */     if (this.shareStatus == 14)
/*     */     {
/* 753 */       fileCache.put(fname, fname);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected final void removeFromCache(String fname)
/*     */   {
/* 759 */     removeFromCache(fname, true);
/*     */   }
/*     */ 
/*     */   protected final void removeFromCache(String fname, boolean warn)
/*     */   {
/* 770 */     if (this.shareStatus == 14)
/*     */     {
/* 772 */       if ((fileCache.remove(fname) == null) && (warn))
/*     */       {
/* 774 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */         {
/* 776 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.FileSystemStore_2", new Object[] { fname });
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private final boolean present(String id, String[] list)
/*     */   {
/* 785 */     for (int i = 0; i < list.length; i++)
/*     */     {
/* 787 */       if (list[i].equals(id)) {
/* 788 */         return true;
/*     */       }
/*     */     }
/* 791 */     return false;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/* 823 */     String syncOpt = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.objectstore.objectStoreSync");
/*     */ 
/* 825 */     if (syncOpt != null)
/*     */     {
/* 827 */       if (syncOpt.compareTo("OFF") == 0)
/* 828 */         doSync = false;
/*     */     }
/*     */     else {
/* 831 */       doSync = true;
/*     */     }
/* 833 */     if (File.separatorChar != '/') {
/* 834 */       rewriteSeparator = true;
/*     */     }
/* 836 */     String retry = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.objectstore.hierarchyRetry");
/*     */ 
/* 838 */     if (retry != null)
/*     */     {
/*     */       try
/*     */       {
/* 842 */         Integer i = new Integer(retry);
/*     */ 
/* 844 */         createRetry = i.intValue();
/*     */ 
/* 846 */         if (createRetry < 0)
/* 847 */           createRetry = 100;
/*     */       }
/*     */       catch (NumberFormatException e)
/*     */       {
/* 851 */         throw new FatalError("Invalid retry for hierarchy creation: " + createRetry);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 855 */         throw new FatalError(e.toString());
/*     */       }
/*     */     }
/*     */ 
/* 859 */     String timeout = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.objectstore.hierarchyTimeout");
/*     */ 
/* 861 */     if (timeout != null)
/*     */     {
/*     */       try
/*     */       {
/* 865 */         Integer i = new Integer(timeout);
/*     */ 
/* 867 */         createTimeout = i.intValue();
/*     */ 
/* 869 */         if (createTimeout < 0)
/* 870 */           createTimeout = 100;
/*     */       }
/*     */       catch (NumberFormatException e)
/*     */       {
/* 874 */         throw new FatalError("Invalid timeout for hierarchy creation: " + createTimeout);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 878 */         throw new FatalError(e.toString());
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.arjuna.objectstore.FileSystemStore
 * JD-Core Version:    0.6.0
 */