/*     */ package com.arjuna.ats.internal.arjuna.objectstore;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
/*     */ import com.arjuna.ats.arjuna.gandiva.ObjectName;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.ats.arjuna.state.InputObjectState;
/*     */ import com.arjuna.ats.arjuna.state.OutputObjectState;
/*     */ import com.arjuna.ats.arjuna.utils.FileLock;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import java.io.File;
/*     */ 
/*     */ public abstract class FileLockingStore extends FileSystemStore
/*     */ {
/*     */   protected abstract InputObjectState read_state(Uid paramUid, String paramString, int paramInt)
/*     */     throws ObjectStoreException;
/*     */ 
/*     */   protected abstract boolean remove_state(Uid paramUid, String paramString, int paramInt)
/*     */     throws ObjectStoreException;
/*     */ 
/*     */   protected abstract boolean write_state(Uid paramUid, String paramString, OutputObjectState paramOutputObjectState, int paramInt)
/*     */     throws ObjectStoreException;
/*     */ 
/*     */   public FileLockingStore(String locationOfStore, int ss)
/*     */   {
/*  70 */     super(locationOfStore, ss);
/*     */ 
/*  72 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/*  74 */       tsLogger.arjLogger.debug(1L, 4L, 16L, "FileLockingStore.FileLockingStore(" + locationOfStore + ")");
/*     */     }
/*     */   }
/*     */ 
/*     */   protected FileLockingStore(ObjectName objName)
/*     */   {
/*  81 */     super(objName);
/*     */ 
/*  83 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/*  85 */       tsLogger.arjLogger.debug(1L, 2L, 16L, "FileLockingStore.FileLockingStore(" + objName + ")");
/*     */     }
/*     */   }
/*     */ 
/*     */   protected synchronized boolean lock(File fd, int lmode, boolean create)
/*     */   {
/*  96 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/*  98 */       tsLogger.arjLogger.debug(16L, 2L, 16L, "FileLockingStore.lock(" + fd + ", " + FileLock.modeString(lmode) + ", " + create + ")");
/*     */     }
/*     */ 
/* 103 */     FileLock fileLock = new FileLock(fd);
/*     */ 
/* 105 */     return fileLock.lock(lmode, create);
/*     */   }
/*     */ 
/*     */   protected synchronized boolean unlock(File fd)
/*     */   {
/* 110 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 112 */       tsLogger.arjLogger.debug(16L, 2L, 16L, "FileLockingStore.unlock(" + fd + ")");
/*     */     }
/*     */ 
/* 116 */     FileLock fileLock = new FileLock(fd);
/*     */ 
/* 118 */     return fileLock.unlock();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.arjuna.objectstore.FileLockingStore
 * JD-Core Version:    0.6.0
 */