/*     */ package com.arjuna.ats.internal.arjuna.objectstore;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.ArjunaNames;
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.common.arjPropertyManager;
/*     */ import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
/*     */ import com.arjuna.ats.arjuna.gandiva.ClassName;
/*     */ import com.arjuna.ats.arjuna.gandiva.ObjectName;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.ats.arjuna.state.InputObjectState;
/*     */ import com.arjuna.ats.arjuna.state.OutputObjectState;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import com.arjuna.common.util.propertyservice.PropertyManager;
/*     */ import java.io.SyncFailedException;
/*     */ 
/*     */ public class CacheStore extends HashedStore
/*     */ {
/*     */   static final int NO_STATE_TYPE = -1;
/* 280 */   static AsyncStore _storeManager = new AsyncStore();
/*     */ 
/* 282 */   private static boolean _cacheSync = false;
/*     */ 
/*     */   public boolean commit_state(Uid objUid, String tName)
/*     */     throws ObjectStoreException
/*     */   {
/*  67 */     return _storeManager.addWork(this, 0, objUid, tName, null, -1);
/*     */   }
/*     */ 
/*     */   public void sync() throws SyncFailedException, ObjectStoreException
/*     */   {
/*  72 */     _storeManager.flush();
/*     */   }
/*     */ 
/*     */   public int typeIs()
/*     */   {
/*  77 */     return 18;
/*     */   }
/*     */ 
/*     */   public ClassName className()
/*     */   {
/*  82 */     return ArjunaNames.Implementation_ObjectStore_CacheStore();
/*     */   }
/*     */ 
/*     */   public static ClassName name()
/*     */   {
/*  87 */     return ArjunaNames.Implementation_ObjectStore_CacheStore();
/*     */   }
/*     */ 
/*     */   public static ShadowingStore create()
/*     */   {
/*  97 */     return new CacheStore("");
/*     */   }
/*     */ 
/*     */   public static ShadowingStore create(Object[] param)
/*     */   {
/* 106 */     if (param == null) {
/* 107 */       return null;
/*     */     }
/* 109 */     String location = (String)param[0];
/* 110 */     Integer shareStatus = (Integer)param[1];
/* 111 */     int ss = 14;
/*     */ 
/* 113 */     if (shareStatus != null)
/*     */     {
/*     */       try
/*     */       {
/* 117 */         if (shareStatus.intValue() == 13)
/* 118 */           ss = 13;
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 122 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */         {
/* 124 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.CacheStore_1", new Object[] { e });
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 130 */     return new CacheStore(location, ss);
/*     */   }
/*     */ 
/*     */   public static ShadowingStore create(ObjectName param)
/*     */   {
/* 135 */     if (param == null) {
/* 136 */       return null;
/*     */     }
/* 138 */     return new CacheStore(param);
/*     */   }
/*     */ 
/*     */   protected boolean remove_state(Uid objUid, String name, int ft)
/*     */     throws ObjectStoreException
/*     */   {
/* 147 */     int status = _storeManager.removeState(objUid, ft);
/*     */ 
/* 154 */     int fileState = currentState(objUid, name);
/*     */ 
/* 156 */     if ((fileState != 0) || (status == 0))
/*     */     {
/* 158 */       return _storeManager.addWork(this, 1, objUid, name, null, fileState);
/*     */     }
/*     */ 
/* 163 */     return fileState != 0;
/*     */   }
/*     */ 
/*     */   protected boolean write_state(Uid objUid, String tName, OutputObjectState state, int ft)
/*     */     throws ObjectStoreException
/*     */   {
/* 182 */     int status = _storeManager.removeWriteState(objUid, ft);
/*     */ 
/* 184 */     return _storeManager.addWork(this, 2, objUid, tName, state, ft);
/*     */   }
/*     */ 
/*     */   protected InputObjectState read_state(Uid objUid, String tName, int ft)
/*     */     throws ObjectStoreException
/*     */   {
/* 196 */     OutputObjectState state = _storeManager.getState(objUid, ft);
/*     */ 
/* 198 */     if (state == null) {
/* 199 */       return super.read_state(objUid, tName, ft);
/*     */     }
/* 201 */     return new InputObjectState(state);
/*     */   }
/*     */ 
/*     */   protected boolean commitState(Uid objUid, String tName)
/*     */     throws ObjectStoreException
/*     */   {
/* 211 */     return super.commit_state(objUid, tName);
/*     */   }
/*     */ 
/*     */   protected boolean removeState(Uid objUid, String name, int ft) throws ObjectStoreException
/*     */   {
/* 216 */     return super.remove_state(objUid, name, ft);
/*     */   }
/*     */ 
/*     */   protected boolean writeState(Uid objUid, String tName, OutputObjectState state, int ft)
/*     */     throws ObjectStoreException
/*     */   {
/* 223 */     return super.write_state(objUid, tName, state, ft);
/*     */   }
/*     */ 
/*     */   protected CacheStore(String locationOfStore)
/*     */   {
/* 228 */     this(locationOfStore, 14);
/*     */   }
/*     */ 
/*     */   protected CacheStore(String locationOfStore, int shareStatus)
/*     */   {
/* 233 */     super(locationOfStore, shareStatus);
/*     */ 
/* 235 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 237 */       tsLogger.arjLogger.debug(1L, 2L, 16L, "CacheStore.CacheStore(" + locationOfStore + ")");
/*     */     }
/*     */ 
/* 246 */     this.syncWrites = _cacheSync;
/*     */   }
/*     */ 
/*     */   protected CacheStore()
/*     */   {
/* 251 */     this(14);
/*     */   }
/*     */ 
/*     */   protected CacheStore(int shareStatus)
/*     */   {
/* 256 */     super(shareStatus);
/*     */ 
/* 258 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 260 */       tsLogger.arjLogger.debug(1L, 2L, 16L, "CacheStore.CacheStore( " + shareStatus + " )");
/*     */     }
/*     */ 
/* 264 */     this.syncWrites = false;
/*     */   }
/*     */ 
/*     */   protected CacheStore(ObjectName objName)
/*     */   {
/* 269 */     super(objName);
/*     */ 
/* 271 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 273 */       tsLogger.arjLogger.debug(1L, 2L, 16L, "CacheStore.CacheStore( " + objName + " )");
/*     */     }
/*     */ 
/* 277 */     this.syncWrites = false;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/* 286 */     String cacheSync = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.internal.arjuna.objectstore.cacheStore.sync");
/*     */ 
/* 288 */     if (cacheSync != null)
/*     */     {
/* 290 */       if (cacheSync.equals("ON"))
/* 291 */         _cacheSync = true;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.arjuna.objectstore.CacheStore
 * JD-Core Version:    0.6.0
 */