/*     */ package com.arjuna.ats.internal.arjuna.gandiva.nameservice;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.ArjunaNames;
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.common.arjPropertyManager;
/*     */ import com.arjuna.ats.arjuna.gandiva.ClassName;
/*     */ import com.arjuna.ats.arjuna.gandiva.ObjectName;
/*     */ import com.arjuna.ats.arjuna.gandiva.nameservice.NameServiceImple;
/*     */ import com.arjuna.common.util.propertyservice.PropertyManager;
/*     */ import java.io.IOException;
/*     */ import java.util.Enumeration;
/*     */ 
/*     */ public class JNS extends NameServiceImple
/*     */ {
/*     */   private static final char SIGNED_NUMBER = '#';
/*     */   private static final char UNSIGNED_NUMBER = '~';
/*     */   private static final char STRING = '^';
/*     */   private static final char OBJECTNAME = '%';
/*     */   private static final char CLASSNAME = '-';
/*     */   private static final char UID = '+';
/*     */   private static final String jnsName = "JNS:";
/*     */ 
/*     */   public int attributeType(String objName, String attrName)
/*     */     throws IOException
/*     */   {
/*  70 */     String attr = arjPropertyManager.propertyManager.getProperty(objName + "." + attrName, null);
/*     */ 
/*  72 */     if (attr == null) {
/*  73 */       throw new IOException("No such attribute.");
/*     */     }
/*     */ 
/*  76 */     if (attr.charAt(0) == '#')
/*  77 */       return 0;
/*  78 */     if (attr.charAt(0) == '~')
/*  79 */       return 1;
/*  80 */     if (attr.charAt(0) == '^')
/*  81 */       return 2;
/*  82 */     if (attr.charAt(0) == '%')
/*  83 */       return 3;
/*  84 */     if (attr.charAt(0) == '-')
/*  85 */       return 4;
/*  86 */     if (attr.charAt(0) == '+') {
/*  87 */       return 5;
/*     */     }
/*  89 */     throw new IOException("Unknown attribute type.");
/*     */   }
/*     */ 
/*     */   public String firstAttributeName(String objName)
/*     */     throws IOException
/*     */   {
/*  95 */     Enumeration e = arjPropertyManager.propertyManager.propertyNames();
/*     */ 
/*  97 */     if (e.hasMoreElements()) {
/*  98 */       return (String)e.nextElement();
/*     */     }
/* 100 */     throw new IOException("No attributes.");
/*     */   }
/*     */ 
/*     */   public String nextAttributeName(String objName, String attrName) throws IOException
/*     */   {
/* 105 */     Enumeration e = arjPropertyManager.propertyManager.propertyNames();
/*     */ 
/* 107 */     while (e.hasMoreElements())
/*     */     {
/* 109 */       String s = (String)e.nextElement();
/*     */ 
/* 111 */       if (s.equals(objName + "." + attrName))
/*     */       {
/* 113 */         if (e.hasMoreElements()) {
/* 114 */           return (String)e.nextElement();
/*     */         }
/*     */       }
/*     */     }
/* 118 */     throw new IOException("No more attributes.");
/*     */   }
/*     */ 
/*     */   public long getLongAttribute(String objName, String attrName) throws IOException
/*     */   {
/* 123 */     String attr = arjPropertyManager.propertyManager.getProperty(objName + "." + attrName, null);
/*     */ 
/* 125 */     if (attr != null)
/*     */     {
/* 127 */       if (attr.charAt(0) == '#')
/*     */       {
/*     */         try
/*     */         {
/* 131 */           return Long.parseLong(new String(attr.substring(1)));
/*     */         }
/*     */         catch (NumberFormatException e)
/*     */         {
/* 135 */           throw new IOException("Not a number.");
/*     */         }
/*     */         catch (StringIndexOutOfBoundsException e)
/*     */         {
/* 139 */           throw new IOException("Not a number.");
/*     */         }
/*     */       }
/*     */ 
/* 143 */       throw new IOException("Not a signed number.");
/*     */     }
/*     */ 
/* 146 */     throw new IOException("No such attribute.");
/*     */   }
/*     */ 
/*     */   public String getStringAttribute(String objName, String attrName) throws IOException
/*     */   {
/* 151 */     String attr = arjPropertyManager.propertyManager.getProperty(objName + "." + attrName, null);
/*     */ 
/* 153 */     if (attr != null)
/*     */     {
/* 155 */       if (attr.charAt(0) == '^')
/*     */       {
/*     */         try
/*     */         {
/* 159 */           return new String(attr.substring(1));
/*     */         }
/*     */         catch (StringIndexOutOfBoundsException e)
/*     */         {
/* 163 */           throw new IOException("No string.");
/*     */         }
/*     */       }
/*     */ 
/* 167 */       throw new IOException("Not a string.");
/*     */     }
/*     */ 
/* 170 */     throw new IOException("No such attribute.");
/*     */   }
/*     */ 
/*     */   public ObjectName getObjectNameAttribute(String objName, String attrName) throws IOException
/*     */   {
/* 175 */     String attr = arjPropertyManager.propertyManager.getProperty(objName + "." + attrName, null);
/*     */ 
/* 177 */     if (attr != null)
/*     */     {
/* 179 */       if (attr.charAt(0) == '%')
/*     */       {
/*     */         try
/*     */         {
/* 183 */           return new ObjectName(new String(attr.substring(1)));
/*     */         }
/*     */         catch (StringIndexOutOfBoundsException e)
/*     */         {
/* 187 */           throw new IOException("No ObjectName.");
/*     */         }
/*     */       }
/*     */ 
/* 191 */       throw new IOException("Not an ObjectName.");
/*     */     }
/*     */ 
/* 194 */     throw new IOException("No such attribute.");
/*     */   }
/*     */ 
/*     */   public ClassName getClassNameAttribute(String objName, String attrName) throws IOException
/*     */   {
/* 199 */     String attr = arjPropertyManager.propertyManager.getProperty(objName + "." + attrName, null);
/*     */ 
/* 201 */     if (attr != null)
/*     */     {
/* 203 */       if (attr.charAt(0) == '-')
/*     */       {
/*     */         try
/*     */         {
/* 207 */           return new ClassName(new String(attr.substring(1)));
/*     */         }
/*     */         catch (StringIndexOutOfBoundsException e)
/*     */         {
/* 211 */           throw new IOException("No ClassName.");
/*     */         }
/*     */       }
/*     */ 
/* 215 */       throw new IOException("Not a ClassName.");
/*     */     }
/*     */ 
/* 218 */     throw new IOException("No such attribute.");
/*     */   }
/*     */ 
/*     */   public Uid getUidAttribute(String objName, String attrName) throws IOException
/*     */   {
/* 223 */     String attr = arjPropertyManager.propertyManager.getProperty(objName + "." + attrName, null);
/*     */ 
/* 225 */     if (attr != null)
/*     */     {
/* 227 */       if (attr.charAt(0) == '+')
/*     */       {
/*     */         try
/*     */         {
/* 231 */           return new Uid(new String(attr.substring(1)));
/*     */         }
/*     */         catch (StringIndexOutOfBoundsException e)
/*     */         {
/* 235 */           throw new IOException("No Uid.");
/*     */         }
/*     */       }
/*     */ 
/* 239 */       throw new IOException("Not a Uid.");
/*     */     }
/*     */ 
/* 242 */     throw new IOException("No such attribute.");
/*     */   }
/*     */ 
/*     */   public String setLongAttribute(String objName, String attrName, long value) throws IOException
/*     */   {
/* 247 */     arjPropertyManager.propertyManager.setProperty(objName + "." + attrName, new String("#" + value));
/*     */ 
/* 249 */     return null;
/*     */   }
/*     */ 
/*     */   public String setStringAttribute(String objName, String attrName, String value) throws IOException
/*     */   {
/* 254 */     arjPropertyManager.propertyManager.setProperty(objName + "." + attrName, new String("^" + value));
/*     */ 
/* 256 */     return null;
/*     */   }
/*     */ 
/*     */   public String setObjectNameAttribute(String objName, String attrName, ObjectName value) throws IOException
/*     */   {
/* 261 */     arjPropertyManager.propertyManager.setProperty(objName + "." + attrName, new String("%" + value.stringForm()));
/*     */ 
/* 263 */     return null;
/*     */   }
/*     */ 
/*     */   public String setClassNameAttribute(String objName, String attrName, ClassName value) throws IOException
/*     */   {
/* 268 */     arjPropertyManager.propertyManager.setProperty(objName + "." + attrName, new String("-" + value.stringForm()));
/*     */ 
/* 270 */     return null;
/*     */   }
/*     */ 
/*     */   public String setUidAttribute(String objName, String attrName, Uid value) throws IOException
/*     */   {
/* 275 */     arjPropertyManager.propertyManager.setProperty(objName + "." + attrName, new String("-" + value.stringForm()));
/*     */ 
/* 277 */     return null;
/*     */   }
/*     */ 
/*     */   public String removeAttribute(String objName, String attrName) throws IOException
/*     */   {
/* 282 */     return arjPropertyManager.propertyManager.removeProperty(objName + "." + attrName);
/*     */   }
/*     */ 
/*     */   public String uniqueAttributeName(String objName) throws IOException
/*     */   {
/* 287 */     Uid u = new Uid();
/*     */ 
/* 289 */     return u.stringForm();
/*     */   }
/*     */ 
/*     */   public ObjectName uniqueObjectName() throws IOException
/*     */   {
/* 294 */     Uid uid = new Uid();
/* 295 */     ObjectName uniqueName = new ObjectName("JNS:" + uid.stringForm());
/*     */ 
/* 297 */     return uniqueName;
/*     */   }
/*     */ 
/*     */   public Object clone()
/*     */   {
/* 302 */     return new JNS();
/*     */   }
/*     */ 
/*     */   public ClassName className()
/*     */   {
/* 307 */     return ArjunaNames.Implementation_NameService_JNS();
/*     */   }
/*     */ 
/*     */   public static ClassName name()
/*     */   {
/* 312 */     return ArjunaNames.Implementation_NameService_JNS();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.arjuna.gandiva.nameservice.JNS
 * JD-Core Version:    0.6.0
 */