/*     */ package com.arjuna.ats.internal.arjuna.gandiva.inventory;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.ArjunaNames;
/*     */ import com.arjuna.ats.arjuna.common.arjPropertyManager;
/*     */ import com.arjuna.ats.arjuna.gandiva.ClassName;
/*     */ import com.arjuna.ats.arjuna.gandiva.ObjectName;
/*     */ import com.arjuna.ats.arjuna.gandiva.inventory.InventoryElement;
/*     */ import com.arjuna.ats.arjuna.gandiva.inventory.InventoryImple;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.ats.internal.arjuna.Implementations;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import com.arjuna.common.util.propertyservice.PropertyManager;
/*     */ import java.io.PrintStream;
/*     */ import java.util.Enumeration;
/*     */ 
/*     */ public class StaticInventory extends InventoryImple
/*     */ {
/* 264 */   private static InventoryList headOfList = null;
/* 265 */   private static boolean initialised = false;
/*     */ 
/*     */   public synchronized Object createVoid(ClassName typeName)
/*     */   {
/*  73 */     InventoryElement creator = find(typeName);
/*     */ 
/*  75 */     if (creator != null) {
/*  76 */       return creator.createVoid();
/*     */     }
/*  78 */     return null;
/*     */   }
/*     */ 
/*     */   public synchronized Object createClassName(ClassName typeName, ClassName paramClassName)
/*     */   {
/*  83 */     InventoryElement creator = find(typeName);
/*     */ 
/*  85 */     if (creator != null) {
/*  86 */       return creator.createClassName(paramClassName);
/*     */     }
/*  88 */     return null;
/*     */   }
/*     */ 
/*     */   public synchronized Object createObjectName(ClassName typeName, ObjectName paramObjectName)
/*     */   {
/*  93 */     InventoryElement creator = find(typeName);
/*     */ 
/*  95 */     if (creator != null) {
/*  96 */       return creator.createObjectName(paramObjectName);
/*     */     }
/*  98 */     return null;
/*     */   }
/*     */ 
/*     */   public synchronized Object createResources(ClassName typeName, Object[] paramResources)
/*     */   {
/* 103 */     InventoryElement creator = find(typeName);
/*     */ 
/* 105 */     if (creator != null) {
/* 106 */       return creator.createResources(paramResources);
/*     */     }
/* 108 */     return null;
/*     */   }
/*     */ 
/*     */   public synchronized Object createClassNameResources(ClassName typeName, ClassName paramClassName, Object[] paramResources)
/*     */   {
/* 114 */     InventoryElement creator = find(typeName);
/*     */ 
/* 116 */     if (creator != null) {
/* 117 */       return creator.createClassNameResources(paramClassName, paramResources);
/*     */     }
/* 119 */     return null;
/*     */   }
/*     */ 
/*     */   public synchronized Object createObjectNameResources(ClassName typeName, ObjectName paramObjectName, Object[] paramResources)
/*     */   {
/* 126 */     InventoryElement creator = find(typeName);
/*     */ 
/* 128 */     if (creator != null) {
/* 129 */       return creator.createObjectNameResources(paramObjectName, paramResources);
/*     */     }
/* 131 */     return null;
/*     */   }
/*     */ 
/*     */   public synchronized void addToList(InventoryElement creator)
/*     */   {
/* 136 */     if ((creator != null) && (creator.className() != null))
/*     */     {
/* 138 */       if (headOfList == null) {
/* 139 */         headOfList = new InventoryList(creator);
/*     */       }
/*     */       else {
/* 142 */         boolean found = false;
/* 143 */         InventoryList marker = headOfList; InventoryList trail = null;
/*     */ 
/* 145 */         while ((!found) && (marker != null))
/*     */         {
/* 147 */           if (!creator.className().equals(marker._instance.className()))
/*     */           {
/* 149 */             trail = marker;
/* 150 */             marker = marker._next; continue;
/*     */           }
/*     */ 
/* 153 */           found = true;
/*     */         }
/*     */ 
/* 156 */         if (!found)
/* 157 */           trail._next = new InventoryList(creator);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized void printList(PrintStream toUse)
/*     */   {
/* 164 */     InventoryList marker = headOfList;
/*     */ 
/* 166 */     toUse.println("StaticInventory contains:");
/*     */ 
/* 168 */     while (marker != null)
/*     */     {
/* 170 */       toUse.println(marker._instance.className());
/* 171 */       marker = marker._next;
/*     */     }
/*     */ 
/* 174 */     toUse.println("End of list.");
/*     */   }
/*     */ 
/*     */   public ClassName className()
/*     */   {
/* 179 */     return ArjunaNames.Implementation_Inventory_StaticInventory();
/*     */   }
/*     */ 
/*     */   public static ClassName type()
/*     */   {
/* 184 */     return ArjunaNames.Implementation_Inventory_StaticInventory();
/*     */   }
/*     */ 
/*     */   protected InventoryElement find(ClassName className)
/*     */   {
/* 196 */     if (!initialised) {
/* 197 */       initialise();
/*     */     }
/* 199 */     if (headOfList != null)
/*     */     {
/* 201 */       InventoryList marker = headOfList;
/*     */ 
/* 203 */       while (marker != null)
/*     */       {
/* 205 */         if ((marker._instance.className() != null) && (marker._instance.className().equals(className)))
/*     */         {
/* 208 */           return marker._instance;
/*     */         }
/*     */ 
/* 212 */         marker = marker._next;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 217 */     if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */     {
/* 219 */       tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.gandiva.inventory.StaticInventory_1", new Object[] { className });
/*     */     }
/*     */ 
/* 223 */     return null;
/*     */   }
/*     */ 
/*     */   private final synchronized void initialise()
/*     */   {
/* 234 */     Implementations.initialise();
/*     */ 
/* 236 */     Enumeration e = arjPropertyManager.propertyManager.propertyNames();
/*     */ 
/* 238 */     if (e != null)
/*     */     {
/* 240 */       while (e.hasMoreElements())
/*     */       {
/* 242 */         String name = (String)e.nextElement();
/*     */ 
/* 244 */         if (name.startsWith("com.arjuna.ats.internal.arjuna.inventory.staticInventoryImple"))
/*     */         {
/* 246 */           String className = arjPropertyManager.propertyManager.getProperty(name);
/*     */           try
/*     */           {
/* 250 */             Class c = Thread.currentThread().getContextClassLoader().loadClass(className);
/* 251 */             o = c.newInstance();
/*     */           }
/*     */           catch (Exception ex)
/*     */           {
/*     */             Object o;
/* 255 */             ex.printStackTrace();
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 261 */     initialised = true;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.arjuna.gandiva.inventory.StaticInventory
 * JD-Core Version:    0.6.0
 */