/*     */ package com.arjuna.ats.internal.arjuna.gandiva.inventory;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.ArjunaNames;
/*     */ import com.arjuna.ats.arjuna.gandiva.ClassName;
/*     */ import com.arjuna.ats.arjuna.gandiva.inventory.InventoryElement;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ 
/*     */ public class DynamicInventory extends StaticInventory
/*     */ {
/*     */   private StaticInventory _staticInventory;
/*     */ 
/*     */   public DynamicInventory()
/*     */   {
/*  68 */     this._staticInventory = new StaticInventory();
/*     */   }
/*     */ 
/*     */   public synchronized void addToList(InventoryElement creator)
/*     */   {
/*  73 */     this._staticInventory.addToList(creator);
/*     */   }
/*     */ 
/*     */   public ClassName className()
/*     */   {
/*  78 */     return ArjunaNames.Implementation_Inventory_DynamicInventory();
/*     */   }
/*     */ 
/*     */   public static ClassName type()
/*     */   {
/*  83 */     return ArjunaNames.Implementation_Inventory_DynamicInventory();
/*     */   }
/*     */ 
/*     */   protected InventoryElement find(ClassName className)
/*     */   {
/*  93 */     InventoryElement ptr = this._staticInventory.find(className);
/*     */ 
/*  95 */     if (ptr == null)
/*     */     {
/* 101 */       String setupClass = className.toString() + "Setup";
/* 102 */       Class theClass = null;
/*     */       try
/*     */       {
/* 106 */         theClass = Thread.currentThread().getContextClassLoader().loadClass(setupClass);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 110 */         theClass = null;
/*     */       }
/*     */ 
/* 113 */       if (theClass != null)
/*     */       {
/*     */         try
/*     */         {
/* 123 */           theClass.newInstance();
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 127 */           if (tsLogger.arjLogger.isWarnEnabled()) {
/* 128 */             tsLogger.arjLogger.warn(e.toString());
/*     */           }
/*     */         }
/* 131 */         ptr = this._staticInventory.find(className);
/*     */       }
/* 135 */       else if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */       {
/* 137 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.gandiva.inventory.DynamicInventory_1", new Object[] { setupClass });
/*     */       }
/*     */ 
/* 142 */       if (ptr == null)
/*     */       {
/* 144 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */         {
/* 146 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.gandiva.inventory.DynamicInventory_2", new Object[] { className });
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 152 */     return ptr;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.arjuna.gandiva.inventory.DynamicInventory
 * JD-Core Version:    0.6.0
 */