/*     */ package com.arjuna.ats.internal.arjuna.coordinator;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.coordinator.TransactionReaper;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ 
/*     */ public class ReaperThread extends Thread
/*     */ {
/*     */   private TransactionReaper reaperObject;
/*     */   private long sleepPeriod;
/*     */   private boolean _shutdown;
/*     */ 
/*     */   public ReaperThread(TransactionReaper arg)
/*     */   {
/*  56 */     this.reaperObject = arg;
/*  57 */     this.sleepPeriod = this.reaperObject.checkingPeriod();
/*  58 */     this._shutdown = false;
/*     */   }
/*     */ 
/*     */   public void run()
/*     */   {
/*  67 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/*  69 */       tsLogger.arjLogger.debug(16L, 4L, 1L, "ReaperThread.run ()");
/*     */     }
/*     */ 
/*     */     while (true)
/*     */     {
/*  81 */       synchronized (this.reaperObject)
/*     */       {
/*  83 */         this.sleepPeriod = this.reaperObject.checkingPeriod();
/*     */ 
/*  85 */         if (this.sleepPeriod <= 0L)
/*     */           continue;
/*     */         try
/*     */         {
/*  89 */           if (!tsLogger.arjLoggerI18N.isDebugEnabled())
/*     */             continue;
/*  91 */           tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.internal.arjuna.coordinator.ReaperThread_1", new Object[] { Thread.currentThread(), Long.toString(this.sleepPeriod) });
/*     */ 
/*  98 */           this.reaperObject.wait(this.sleepPeriod);
/*     */         }
/*     */         catch (InterruptedException e1)
/*     */         {
/*     */         }
/*     */       }
/* 104 */       if (tsLogger.arjLogger.debugAllowed())
/*     */       {
/* 106 */         tsLogger.arjLogger.debug(16L, 4L, 1L, "ReaperThread.run ()");
/*     */       }
/*     */ 
/* 110 */       if (this._shutdown) {
/* 111 */         return;
/*     */       }
/* 113 */       this.reaperObject.check();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void shutdown()
/*     */   {
/* 119 */     this._shutdown = true;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.arjuna.coordinator.ReaperThread
 * JD-Core Version:    0.6.0
 */