/*     */ package com.arjuna.ats.internal.arjuna;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.ArjunaNames;
/*     */ import com.arjuna.ats.arjuna.PersistenceRecord;
/*     */ import com.arjuna.ats.arjuna.StateManager;
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
/*     */ import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
/*     */ import com.arjuna.ats.arjuna.gandiva.ClassName;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.ats.arjuna.objectstore.ObjectStore;
/*     */ import com.arjuna.ats.arjuna.state.OutputObjectState;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ 
/*     */ public class TxLogWritePersistenceRecord extends PersistenceRecord
/*     */ {
/*     */   public TxLogWritePersistenceRecord(OutputObjectState state, ObjectStore store, StateManager sm)
/*     */   {
/*  57 */     super(state, store, sm);
/*     */   }
/*     */ 
/*     */   public int typeIs()
/*     */   {
/*  62 */     return 112;
/*     */   }
/*     */ 
/*     */   public ClassName className()
/*     */   {
/*  67 */     return ArjunaNames.Implementation_AbstractRecord_TxLogPersistenceRecord();
/*     */   }
/*     */ 
/*     */   public int topLevelCommit()
/*     */   {
/*  76 */     boolean result = false;
/*  77 */     LogWriteStateManager sm = null;
/*  78 */     boolean writeToLog = true;
/*     */     try
/*     */     {
/*  82 */       sm = (LogWriteStateManager)this.objectAddr;
/*     */ 
/*  84 */       writeToLog = sm.writeOptimisation();
/*     */     }
/*     */     catch (ClassCastException ex)
/*     */     {
/*  88 */       writeToLog = false;
/*     */     }
/*     */ 
/*  91 */     if (this.store != null)
/*     */     {
/*     */       try
/*     */       {
/*  95 */         if (this.shadowMade)
/*     */         {
/*  97 */           result = this.store.commit_state(order(), super.getTypeOfObject());
/*     */ 
/*  99 */           if (!result)
/*     */           {
/* 101 */             if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */             {
/* 103 */               tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.PersistenceRecord_2", new Object[] { order() });
/*     */             }
/*     */ 
/*     */           }
/*     */ 
/*     */         }
/* 109 */         else if (this.topLevelState != null)
/*     */         {
/* 111 */           if (!writeToLog)
/* 112 */             result = this.store.write_committed(order(), super.getTypeOfObject(), this.topLevelState);
/*     */           else {
/* 114 */             result = true;
/*     */           }
/*     */         }
/*     */       }
/*     */       catch (ObjectStoreException e)
/*     */       {
/* 120 */         result = false;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 127 */     if (!result);
/* 131 */     super.forgetAction(true);
/*     */ 
/* 133 */     return result ? 7 : 8;
/*     */   }
/*     */ 
/*     */   public int topLevelPrepare()
/*     */   {
/* 151 */     int result = 1;
/* 152 */     StateManager sm = this.objectAddr;
/* 153 */     LogWriteStateManager lwsm = null;
/* 154 */     boolean writeToLog = true;
/*     */     try
/*     */     {
/* 158 */       lwsm = (LogWriteStateManager)sm;
/*     */ 
/* 160 */       writeToLog = lwsm.writeOptimisation();
/*     */     }
/*     */     catch (ClassCastException ex)
/*     */     {
/* 164 */       writeToLog = false;
/*     */     }
/*     */ 
/* 167 */     if ((sm != null) && (this.store != null))
/*     */     {
/* 169 */       this.topLevelState = new OutputObjectState(sm.get_uid(), sm.type());
/*     */ 
/* 171 */       if ((writeToLog) || ((!this.store.fullCommitNeeded()) && (sm.save_state(this.topLevelState, 1)) && (this.topLevelState.size() <= 4096)))
/*     */       {
/* 175 */         if (PersistenceRecord.classicPrepare)
/*     */         {
/* 177 */           OutputObjectState dummy = new OutputObjectState(Uid.nullUid(), null);
/*     */           try
/*     */           {
/* 187 */             this.store.write_uncommitted(sm.get_uid(), sm.type(), dummy);
/* 188 */             result = 0;
/*     */           }
/*     */           catch (ObjectStoreException e)
/*     */           {
/* 192 */             tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.PersistenceRecord_21", e);
/*     */           }
/*     */ 
/* 195 */           dummy = null;
/*     */         }
/*     */         else
/*     */         {
/* 199 */           result = 0;
/*     */         }
/*     */ 
/*     */       }
/* 204 */       else if (sm.deactivate(this.store.getStoreName(), false))
/*     */       {
/* 206 */         this.shadowMade = true;
/*     */ 
/* 208 */         result = 0;
/*     */       }
/* 212 */       else if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/* 213 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.PersistenceRecord_7");
/*     */       }
/*     */ 
/*     */     }
/* 219 */     else if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/* 220 */       tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.PersistenceRecord_8");
/*     */     }
/*     */ 
/* 223 */     return result;
/*     */   }
/*     */ 
/*     */   public String type()
/*     */   {
/* 228 */     return "/StateManager/AbstractRecord/RecoveryRecord/PersistenceRecord/TxLogPersistenceRecord";
/*     */   }
/*     */ 
/*     */   public static AbstractRecord create()
/*     */   {
/* 233 */     return new TxLogWritePersistenceRecord();
/*     */   }
/*     */ 
/*     */   protected TxLogWritePersistenceRecord()
/*     */   {
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.arjuna.TxLogWritePersistenceRecord
 * JD-Core Version:    0.6.0
 */