/*     */ package com.arjuna.ats.arjuna.utils;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.common.arjPropertyManager;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import com.arjuna.common.util.propertyservice.PropertyManager;
/*     */ import java.net.InetAddress;
/*     */ import java.net.UnknownHostException;
/*     */ 
/*     */ public class Utility
/*     */ {
/* 267 */   private static int myAddr = 0;
/* 268 */   private static Uid processUid = null;
/* 269 */   private static Process processHandle = null;
/*     */   private static final String hexStart = "0x";
/*     */   private static final String defaultProcessId = "com.arjuna.ats.internal.arjuna.utils.SocketProcessId";
/*     */ 
/*     */   public static String intToHexString(int number)
/*     */     throws NumberFormatException
/*     */   {
/*  68 */     return Integer.toString(number, 16);
/*     */   }
/*     */ 
/*     */   public static int hexStringToInt(String s)
/*     */     throws NumberFormatException
/*     */   {
/*  80 */     String toUse = s;
/*     */ 
/*  82 */     if (s.startsWith("0x")) {
/*  83 */       toUse = s.substring("0x".length());
/*     */     }
/*  85 */     String lastString = toUse.substring(toUse.length() - 1);
/*     */     boolean isNeg;
/*     */     boolean isNeg;
/*  87 */     if (toUse.substring(0, 1).equals("-")) {
/*  88 */       toUse = "-0" + toUse.substring(1, toUse.length() - 1);
/*  89 */       isNeg = true;
/*     */     } else {
/*  91 */       toUse = "0" + toUse.substring(0, toUse.length() - 1);
/*  92 */       isNeg = false;
/*     */     }
/*     */ 
/*  95 */     Integer i = Integer.valueOf(toUse, 16);
/*     */ 
/*  97 */     int val = i.intValue();
/*     */ 
/*  99 */     val <<= 4;
/*     */ 
/* 101 */     if (isNeg)
/* 102 */       val -= Integer.valueOf(lastString, 16).intValue();
/*     */     else {
/* 104 */       val += Integer.valueOf(lastString, 16).intValue();
/*     */     }
/*     */ 
/* 107 */     return val;
/*     */   }
/*     */ 
/*     */   public static String longToHexString(long number)
/*     */     throws NumberFormatException
/*     */   {
/* 116 */     return Long.toString(number, 16);
/*     */   }
/*     */ 
/*     */   public static long hexStringToLong(String s)
/*     */     throws NumberFormatException
/*     */   {
/* 126 */     String toUse = s;
/*     */ 
/* 128 */     if (s.startsWith("0x")) {
/* 129 */       toUse = s.substring("0x".length());
/*     */     }
/* 131 */     String lastString = toUse.substring(toUse.length() - 1);
/*     */     boolean isNeg;
/*     */     boolean isNeg;
/* 133 */     if (toUse.substring(0, 1).equals("-")) {
/* 134 */       toUse = "-0" + toUse.substring(1, toUse.length() - 1);
/* 135 */       isNeg = true;
/*     */     } else {
/* 137 */       toUse = "0" + toUse.substring(0, toUse.length() - 1);
/* 138 */       isNeg = false;
/*     */     }
/*     */ 
/* 141 */     Long i = Long.valueOf(toUse, 16);
/*     */ 
/* 143 */     long val = i.longValue();
/*     */ 
/* 145 */     val <<= 4;
/*     */ 
/* 147 */     if (isNeg)
/* 148 */       val -= Long.valueOf(lastString, 16).longValue();
/*     */     else {
/* 150 */       val += Long.valueOf(lastString, 16).longValue();
/*     */     }
/*     */ 
/* 153 */     return val;
/*     */   }
/*     */ 
/*     */   public static synchronized int hostInetAddr()
/*     */     throws UnknownHostException
/*     */   {
/* 173 */     if (myAddr == 0)
/*     */     {
/* 175 */       InetAddress addr = InetAddress.getLocalHost();
/* 176 */       byte[] b = addr.getAddress();
/*     */ 
/* 178 */       for (int i = 0; i < b.length; i++)
/*     */       {
/* 184 */         int l = 0x7F & b[i];
/*     */ 
/* 186 */         l += (0x80 & b[i]);
/*     */ 
/* 188 */         myAddr = myAddr << 8 | l;
/*     */       }
/*     */     }
/*     */ 
/* 192 */     return myAddr;
/*     */   }
/*     */ 
/*     */   public static final int getpid()
/*     */   {
/* 204 */     Process handle = getProcess();
/*     */ 
/* 206 */     return handle == null ? -1 : handle.getpid();
/*     */   }
/*     */ 
/*     */   public static final synchronized Uid getProcessUid()
/*     */   {
/* 217 */     if (processUid == null) {
/* 218 */       processUid = new Uid();
/*     */     }
/* 220 */     return processUid;
/*     */   }
/*     */ 
/*     */   public static final boolean isWindows()
/*     */   {
/* 225 */     String os = arjPropertyManager.propertyManager.getProperty("os.name");
/*     */ 
/* 228 */     return ("WIN32".equals(os)) || (os.indexOf("Windows") != -1);
/*     */   }
/*     */ 
/*     */   public static final void setProcess(Process p)
/*     */   {
/* 235 */     processHandle = p;
/*     */   }
/*     */ 
/*     */   public static final Process getDefaultProcess()
/*     */   {
/*     */     try
/*     */     {
/* 245 */       Class c = Thread.currentThread().getContextClassLoader().loadClass("com.arjuna.ats.internal.arjuna.utils.SocketProcessId");
/*     */ 
/* 247 */       return (Process)c.newInstance();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 251 */       tsLogger.arjLoggerI18N.warn("Utility_1", e);
/*     */     }
/* 253 */     return null;
/*     */   }
/*     */ 
/*     */   private static final Process getProcess()
/*     */   {
/* 259 */     if (processHandle == null)
/*     */     {
/* 261 */       processHandle = getDefaultProcess();
/*     */     }
/*     */ 
/* 264 */     return processHandle;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.arjuna.utils.Utility
 * JD-Core Version:    0.6.0
 */