/*     */ package com.arjuna.ats.arjuna.thread;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.coordinator.BasicAction;
/*     */ import com.arjuna.ats.arjuna.utils.ThreadUtil;
/*     */ import java.util.Hashtable;
/*     */ 
/*     */ public class TransactionalThread extends Thread
/*     */ {
/* 122 */   private BasicAction action = null;
/*     */ 
/* 124 */   private static Hashtable actions = new Hashtable();
/*     */ 
/*     */   public void finalize()
/*     */   {
/*  59 */     if (this.action != null)
/*     */     {
/*  61 */       this.action.removeChildThread(ThreadUtil.getThreadId(this));
/*  62 */       this.action = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void create(Thread thread)
/*     */     throws IllegalArgumentException
/*     */   {
/*  73 */     String threadId = ThreadUtil.getThreadId(thread);
/*  74 */     if (actions.get(threadId) == null)
/*     */     {
/*  76 */       BasicAction currentAction = BasicAction.Current();
/*     */ 
/*  78 */       if (currentAction != null)
/*     */       {
/*  80 */         currentAction.addChildThread(thread);
/*  81 */         actions.put(threadId, currentAction);
/*     */ 
/*  83 */         currentAction = null;
/*     */       }
/*     */     }
/*     */     else {
/*  87 */       throw new IllegalArgumentException();
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void destroy(Thread thread) throws IllegalArgumentException {
/*  92 */     String threadId = ThreadUtil.getThreadId(thread);
/*  93 */     BasicAction currentAction = (BasicAction)actions.remove(threadId);
/*     */ 
/*  95 */     if (currentAction != null)
/*     */     {
/*  97 */       if (currentAction != null)
/*     */       {
/*  99 */         currentAction.removeChildThread(threadId);
/* 100 */         currentAction = null;
/*     */       }
/*     */     }
/*     */     else
/* 104 */       throw new IllegalArgumentException();
/*     */   }
/*     */ 
/*     */   protected TransactionalThread()
/*     */   {
/* 114 */     this.action = BasicAction.Current();
/*     */ 
/* 116 */     if (this.action != null)
/*     */     {
/* 118 */       this.action.addChildThread(this);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.arjuna.thread.TransactionalThread
 * JD-Core Version:    0.6.0
 */