/*     */ package com.arjuna.ats.arjuna.state;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.PrintWriter;
/*     */ import java.util.ResourceBundle;
/*     */ 
/*     */ public class OutputBuffer
/*     */ {
/*     */   protected boolean _valid;
/*     */   protected static final int headerSize = 8;
/*     */   protected static final int ALIGNMENT = 4;
/*     */   private DataOutputStream _output;
/*     */   private DataInputStream _input;
/*     */   private ByteArrayOutputStream _outputStream;
/*     */   private ByteArrayInputStream _inputStream;
/* 520 */   private static final byte[] _byte = new byte[1];
/*     */ 
/*     */   public OutputBuffer()
/*     */   {
/*  73 */     this._valid = true;
/*     */     try
/*     */     {
/*  77 */       this._outputStream = new ByteArrayOutputStream();
/*  78 */       this._output = new DataOutputStream(this._outputStream);
/*     */ 
/*  80 */       initBuffer();
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/*  84 */       this._valid = false;
/*     */     }
/*     */   }
/*     */ 
/*     */   public OutputBuffer(int buffSize)
/*     */   {
/*  95 */     this._valid = true;
/*     */     try
/*     */     {
/*  99 */       this._outputStream = new ByteArrayOutputStream(buffSize);
/* 100 */       this._output = new DataOutputStream(this._outputStream);
/*     */ 
/* 102 */       initBuffer();
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 106 */       this._valid = false;
/*     */     }
/*     */   }
/*     */ 
/*     */   public OutputBuffer(byte[] b)
/*     */   {
/* 116 */     this._valid = true;
/*     */     try
/*     */     {
/* 120 */       this._outputStream = new ByteArrayOutputStream(0);
/* 121 */       this._output = new DataOutputStream(this._outputStream);
/*     */ 
/* 123 */       this._outputStream.write(b, 0, b.length);
/*     */ 
/* 125 */       initBuffer();
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 129 */       this._valid = false;
/*     */     }
/*     */   }
/*     */ 
/*     */   public OutputBuffer(OutputBuffer copyFrom)
/*     */   {
/* 140 */     this._valid = true;
/* 141 */     this._outputStream = null;
/* 142 */     this._output = null;
/*     */ 
/* 144 */     copy(copyFrom);
/*     */   }
/*     */ 
/*     */   public final synchronized boolean valid()
/*     */   {
/* 153 */     return this._valid;
/*     */   }
/*     */ 
/*     */   public final synchronized byte[] buffer()
/*     */   {
/* 162 */     return this._outputStream.toByteArray();
/*     */   }
/*     */ 
/*     */   public final synchronized int length()
/*     */   {
/* 172 */     return this._outputStream.size();
/*     */   }
/*     */ 
/*     */   public synchronized void copy(OutputBuffer b)
/*     */   {
/* 182 */     if (b._valid)
/*     */     {
/* 184 */       this._valid = true;
/*     */       try
/*     */       {
/* 188 */         this._outputStream = new ByteArrayOutputStream(b.length());
/* 189 */         this._output = new DataOutputStream(this._outputStream);
/*     */ 
/* 191 */         this._outputStream.write(b.buffer(), 0, b.length());
/*     */ 
/* 193 */         initBuffer();
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 197 */         this._valid = false;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public final synchronized void reset()
/*     */     throws IOException
/*     */   {
/* 208 */     this._outputStream.reset();
/* 209 */     initBuffer();
/*     */   }
/*     */ 
/*     */   public final synchronized void packByte(byte b)
/*     */     throws IOException
/*     */   {
/* 219 */     if (!this._valid) {
/* 220 */       throw new IOException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.state.OutputBuffer_1"));
/*     */     }
/* 222 */     packInt(b);
/*     */   }
/*     */ 
/*     */   public final synchronized void packBytes(byte[] b)
/*     */     throws IOException
/*     */   {
/* 232 */     if (!this._valid) {
/* 233 */       throw new IOException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.state.OutputBuffer_2"));
/*     */     }
/* 235 */     int index = -1;
/*     */ 
/* 237 */     packInt(index);
/* 238 */     packInt(b.length);
/*     */ 
/* 240 */     if (b.length > 0)
/*     */     {
/* 242 */       this._output.write(b, 0, b.length);
/* 243 */       realign(b.length);
/*     */     }
/*     */ 
/* 246 */     this._output.flush();
/*     */   }
/*     */ 
/*     */   public final synchronized void packBoolean(boolean b)
/*     */     throws IOException
/*     */   {
/* 256 */     if (!this._valid) {
/* 257 */       throw new IOException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.state.OutputBuffer_3"));
/*     */     }
/* 259 */     this._valid = false;
/*     */ 
/* 261 */     for (int i = 0; i < 3; i++) {
/* 262 */       this._output.write(_byte, 0, 1);
/*     */     }
/* 264 */     this._output.writeBoolean(b);
/* 265 */     this._output.flush();
/*     */ 
/* 267 */     this._valid = true;
/*     */   }
/*     */ 
/*     */   public final synchronized void packChar(char c)
/*     */     throws IOException
/*     */   {
/* 277 */     if (!this._valid) {
/* 278 */       throw new IOException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.state.OutputBuffer_4"));
/*     */     }
/* 280 */     packInt(c);
/*     */   }
/*     */ 
/*     */   public final synchronized void packShort(short s)
/*     */     throws IOException
/*     */   {
/* 290 */     if (!this._valid) {
/* 291 */       throw new IOException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.state.OutputBuffer_5"));
/*     */     }
/* 293 */     packInt(s);
/*     */   }
/*     */ 
/*     */   public final synchronized void packInt(int i)
/*     */     throws IOException
/*     */   {
/* 303 */     if (!this._valid) {
/* 304 */       throw new IOException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.state.OutputBuffer_6"));
/*     */     }
/* 306 */     this._valid = false;
/*     */ 
/* 308 */     this._output.writeInt(i);
/* 309 */     this._output.flush();
/*     */ 
/* 311 */     this._valid = true;
/*     */   }
/*     */ 
/*     */   public final synchronized void packLong(long l)
/*     */     throws IOException
/*     */   {
/* 321 */     if (!this._valid) {
/* 322 */       throw new IOException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.state.OutputBuffer_7"));
/*     */     }
/* 324 */     this._valid = false;
/*     */ 
/* 326 */     this._output.writeLong(l);
/* 327 */     this._output.flush();
/*     */ 
/* 329 */     this._valid = true;
/*     */   }
/*     */ 
/*     */   public final synchronized void packFloat(float f)
/*     */     throws IOException
/*     */   {
/* 339 */     if (!this._valid) {
/* 340 */       throw new IOException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.state.OutputBuffer_8"));
/*     */     }
/* 342 */     this._valid = false;
/*     */ 
/* 344 */     this._output.writeFloat(f);
/* 345 */     this._output.flush();
/*     */ 
/* 347 */     this._valid = true;
/*     */   }
/*     */ 
/*     */   public final synchronized void packDouble(double d)
/*     */     throws IOException
/*     */   {
/* 357 */     if (!this._valid) {
/* 358 */       throw new IOException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.state.OutputBuffer_9"));
/*     */     }
/* 360 */     this._valid = false;
/*     */ 
/* 362 */     this._output.writeDouble(d);
/* 363 */     this._output.flush();
/*     */ 
/* 365 */     this._valid = true;
/*     */   }
/*     */ 
/*     */   public final synchronized void packString(String s)
/*     */     throws IOException
/*     */   {
/* 380 */     if (!this._valid) {
/* 381 */       throw new IOException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.state.OutputBuffer_10"));
/*     */     }
/* 383 */     int index = -1;
/* 384 */     int sz = 0;
/* 385 */     String dummy = null;
/*     */ 
/* 387 */     packInt(index);
/*     */ 
/* 389 */     if (s != null)
/*     */     {
/* 391 */       sz = s.length() + 1;
/* 392 */       dummy = s + '\000';
/*     */ 
/* 394 */       packInt(sz);
/*     */     }
/*     */     else
/*     */     {
/* 398 */       packInt(0);
/*     */     }
/*     */ 
/* 401 */     this._valid = false;
/*     */ 
/* 403 */     if (sz > 0)
/*     */     {
/* 405 */       this._output.write(dummy.getBytes(), 0, dummy.getBytes().length);
/* 406 */       realign(dummy.getBytes().length);
/*     */     }
/*     */ 
/* 409 */     this._output.flush();
/*     */ 
/* 411 */     this._valid = true;
/*     */   }
/*     */ 
/*     */   public synchronized void packInto(OutputBuffer buff)
/*     */     throws IOException
/*     */   {
/* 421 */     if (buff == null) {
/* 422 */       throw new IOException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.state.OutputBuffer_11"));
/*     */     }
/* 424 */     if (this._valid)
/*     */     {
/* 430 */       byte[] b = buffer();
/* 431 */       buff.packInt(b.length);
/*     */ 
/* 433 */       for (int i = 0; i < b.length; i++)
/* 434 */         buff.packByte(b[i]);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void print(PrintWriter strm)
/*     */   {
/* 444 */     if (this._valid)
/*     */     {
/* 446 */       strm.println("OutputBuffer : \n");
/*     */ 
/* 448 */       byte[] b = buffer();
/*     */ 
/* 450 */       for (int i = 0; i < b.length; i++)
/* 451 */         strm.write((char)b[i]);
/*     */     }
/*     */     else {
/* 454 */       strm.println("OutputBuffer : invalid.");
/*     */     }
/*     */   }
/*     */ 
/*     */   public final boolean rewrite()
/*     */   {
/* 463 */     if (!this._valid) {
/* 464 */       return false;
/*     */     }
/*     */     try
/*     */     {
/* 468 */       this._outputStream = new ByteArrayOutputStream();
/* 469 */       this._output = new DataOutputStream(this._outputStream);
/*     */ 
/* 471 */       initBuffer();
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 475 */       this._valid = false;
/*     */     }
/*     */ 
/* 478 */     return this._valid;
/*     */   }
/*     */ 
/*     */   private final void realign(int amount)
/*     */     throws IOException
/*     */   {
/* 487 */     if (amount % 4 > 0)
/*     */     {
/* 489 */       int excess = 4 - amount % 4;
/*     */ 
/* 491 */       for (int i = 0; i < excess; i++) {
/* 492 */         this._output.write(_byte, 0, 1);
/*     */       }
/* 494 */       this._output.flush();
/*     */     }
/*     */   }
/*     */ 
/*     */   private final void initBuffer() throws IOException
/*     */   {
/* 500 */     String version = "#BE";
/*     */ 
/* 502 */     this._output.writeBytes(version);
/* 503 */     this._output.writeBoolean(true);
/* 504 */     this._output.writeByte(16);
/* 505 */     this._output.writeByte(32);
/* 506 */     this._output.writeByte(64);
/* 507 */     this._output.writeByte(0);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.arjuna.state.OutputBuffer
 * JD-Core Version:    0.6.0
 */