/*     */ package com.arjuna.ats.arjuna.state;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import java.io.IOException;
/*     */ import java.io.PrintWriter;
/*     */ 
/*     */ public class InputObjectState extends InputBuffer
/*     */ {
/*     */   private Uid bufferUid;
/*     */   private String imageType;
/*     */ 
/*     */   public InputObjectState()
/*     */   {
/*  58 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/*  60 */       tsLogger.arjLogger.debug(1L, 4L, 4L, "InputObjectState::InputObjectState()");
/*     */     }
/*     */ 
/*  64 */     this.bufferUid = new Uid(Uid.nullUid());
/*  65 */     this._valid = false;
/*  66 */     this.imageType = null;
/*     */   }
/*     */ 
/*     */   public InputObjectState(InputObjectState copyFrom)
/*     */   {
/*  71 */     super(copyFrom);
/*     */ 
/*  73 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/*  75 */       tsLogger.arjLogger.debug(1L, 4L, 4L, "InputObjectState::InputObjectState(" + copyFrom + ")");
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/*  81 */       this.bufferUid = new Uid(copyFrom.bufferUid);
/*  82 */       this._valid = this.bufferUid.valid();
/*     */ 
/*  84 */       this.imageType = new String(copyFrom.imageType);
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*  88 */       this._valid = false;
/*     */     }
/*     */   }
/*     */ 
/*     */   public InputObjectState(OutputObjectState copyFrom)
/*     */   {
/*  94 */     super(copyFrom.buffer());
/*     */ 
/*  96 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/*  98 */       tsLogger.arjLogger.debug(1L, 4L, 4L, "InputObjectState::InputObjectState(" + copyFrom + ")");
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 104 */       this.bufferUid = new Uid(copyFrom.stateUid());
/* 105 */       this._valid = this.bufferUid.valid();
/*     */ 
/* 107 */       this.imageType = new String(copyFrom.type());
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 111 */       this._valid = false;
/*     */     }
/*     */   }
/*     */ 
/*     */   public InputObjectState(Uid newUid, String tName, byte[] buff)
/*     */   {
/* 117 */     super(buff);
/*     */ 
/* 119 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 121 */       tsLogger.arjLogger.debug(1L, 4L, 4L, "InputObjectState::InputObjectState(" + newUid + ", " + tName + ")");
/*     */     }
/*     */ 
/* 126 */     this.bufferUid = new Uid(newUid);
/* 127 */     this._valid = this.bufferUid.valid();
/*     */ 
/* 129 */     this.imageType = new String(tName);
/*     */   }
/*     */ 
/*     */   public final boolean notempty()
/*     */   {
/* 134 */     return length() > 0;
/*     */   }
/*     */ 
/*     */   public final int size()
/*     */   {
/* 139 */     return length();
/*     */   }
/*     */ 
/*     */   public final Uid stateUid()
/*     */   {
/* 144 */     return this.bufferUid;
/*     */   }
/*     */ 
/*     */   public final String type()
/*     */   {
/* 149 */     return this.imageType;
/*     */   }
/*     */ 
/*     */   public void copyFrom(OutputObjectState copyFrom)
/*     */   {
/* 154 */     super.setBuffer(copyFrom.buffer());
/*     */ 
/* 156 */     this.bufferUid = new Uid(copyFrom.stateUid());
/* 157 */     this._valid = this.bufferUid.valid();
/*     */ 
/* 159 */     this.imageType = new String(copyFrom.type());
/*     */   }
/*     */ 
/*     */   public void print(PrintWriter strm)
/*     */   {
/* 164 */     strm.println("InputObjectState Uid   : " + this.bufferUid + "\n");
/*     */ 
/* 166 */     if (this.imageType != null)
/* 167 */       strm.println("InputObjectState Type  : " + this.imageType + "\n");
/*     */     else {
/* 169 */       strm.println("InputObjectState Type  : null\n");
/*     */     }
/* 171 */     strm.println("InputObjectState Size  : " + size() + "\n");
/* 172 */     strm.println("InputObjectState Buffer: ");
/*     */ 
/* 174 */     super.print(strm);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 179 */     String val = "InputObjectState Uid   : " + this.bufferUid + "\n";
/*     */ 
/* 181 */     if (this.imageType != null)
/* 182 */       val = val + "InputObjectState Type  : " + this.imageType + "\n";
/*     */     else {
/* 184 */       val = val + "InputObjectState Type  : null\n";
/*     */     }
/* 186 */     val = val + "InputObjectState Size  : " + size() + "\n";
/* 187 */     val = val + "InputObjectState Buffer: ";
/*     */ 
/* 189 */     return val;
/*     */   }
/*     */ 
/*     */   public synchronized void copy(InputObjectState objstate)
/*     */   {
/* 194 */     if (tsLogger.arjLogger.debugAllowed()) {
/* 195 */       tsLogger.arjLogger.debug(32L, 4L, 4L, "InputObjectState::copy for " + this.bufferUid);
/*     */     }
/*     */ 
/* 198 */     super.copy(objstate);
/*     */ 
/* 200 */     this.bufferUid = new Uid(objstate.bufferUid);
/* 201 */     this._valid = this.bufferUid.valid();
/*     */ 
/* 203 */     this.imageType = new String(objstate.imageType);
/*     */   }
/*     */ 
/*     */   public synchronized void unpackFrom(InputBuffer buff) throws IOException
/*     */   {
/* 208 */     this.imageType = buff.unpackString();
/* 209 */     this.bufferUid.unpack(buff);
/*     */ 
/* 211 */     super.unpackFrom(buff);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.arjuna.state.InputObjectState
 * JD-Core Version:    0.6.0
 */