/*     */ package com.arjuna.ats.arjuna.recovery;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.coordinator.ActionManager;
/*     */ import com.arjuna.ats.arjuna.coordinator.BasicAction;
/*     */ import com.arjuna.ats.arjuna.coordinator.TxControl;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.ats.arjuna.objectstore.ObjectStore;
/*     */ import com.arjuna.ats.arjuna.state.InputObjectState;
/*     */ import com.arjuna.ats.arjuna.utils.Utility;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import java.io.BufferedReader;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.InputStreamReader;
/*     */ import java.io.OutputStream;
/*     */ import java.io.OutputStreamWriter;
/*     */ import java.io.PrintWriter;
/*     */ import java.util.Vector;
/*     */ 
/*     */ public class ActionStatusService
/*     */   implements Service
/*     */ {
/* 449 */   private static ObjectStore _objectStore = null;
/*     */ 
/*     */   public ActionStatusService()
/*     */   {
/*  69 */     if (_objectStore == null)
/*     */     {
/*  71 */       _objectStore = TxControl.getStore();
/*     */     }
/*     */   }
/*     */ 
/*     */   public int getTransactionStatus(String transactionType, String strUid)
/*     */   {
/*  82 */     int action_status = 9;
/*     */ 
/*  84 */     if (strUid != null)
/*     */     {
/*  86 */       Uid tranUid = new Uid(strUid);
/*     */ 
/*  88 */       if ((transactionType == null) || (transactionType.equals("")))
/*     */       {
/*  90 */         action_status = getTranStatus(tranUid);
/*     */       }
/*     */       else
/*     */       {
/*  94 */         action_status = getActionStatus(tranUid, transactionType);
/*     */       }
/*     */     }
/*     */ 
/*  98 */     return action_status;
/*     */   }
/*     */ 
/*     */   public void doWork(InputStream is, OutputStream os)
/*     */     throws IOException
/*     */   {
/* 110 */     BufferedReader in = new BufferedReader(new InputStreamReader(is));
/* 111 */     PrintWriter out = new PrintWriter(new OutputStreamWriter(os));
/*     */     try
/*     */     {
/* 117 */       out.println(Utility.intToHexString(Utility.getpid()));
/* 118 */       out.flush();
/*     */ 
/* 121 */       String rmStatus = in.readLine();
/*     */ 
/* 123 */       if (rmStatus.equals("OK"))
/*     */       {
/*     */         while (true)
/*     */         {
/* 130 */           String transactionType = null;
/* 131 */           String strUid = null;
/*     */           try
/*     */           {
/* 135 */             transactionType = in.readLine();
/* 136 */             strUid = in.readLine();
/*     */           }
/*     */           catch (IOException ex)
/*     */           {
/*     */           }
/*     */ 
/* 148 */           if ((transactionType == null) && (strUid == null)) {
/* 149 */             return;
/*     */           }
/* 151 */           int status = getTransactionStatus(transactionType, strUid);
/* 152 */           String strStatus = Integer.toString(status);
/*     */ 
/* 154 */           out.println(strStatus);
/* 155 */           out.flush();
/*     */ 
/* 157 */           if (tsLogger.arjLoggerI18N.isInfoEnabled())
/*     */           {
/* 159 */             tsLogger.arjLoggerI18N.info("com.arjuna.ats.arjuna.recovery.ActionStatusService_1", new Object[] { transactionType, strUid, strStatus });
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (IOException ex)
/*     */     {
/* 167 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/* 168 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.recovery.ActionStatusService_7");
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 172 */       if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/* 173 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.recovery.ActionStatusService_2", new Object[] { ex });
/*     */       }
/*     */ 
/* 177 */       ex.printStackTrace();
/*     */     }
/*     */   }
/*     */ 
/*     */   private int getActionStatus(Uid tranUid, String transactionType)
/*     */   {
/* 188 */     int action_status = 9;
/*     */     try
/*     */     {
/* 193 */       BasicAction basic_action = null;
/*     */ 
/* 195 */       synchronized (ActionManager.manager())
/*     */       {
/* 197 */         basic_action = ActionManager.manager().get(tranUid);
/*     */       }
/*     */ 
/* 200 */       if (basic_action != null)
/*     */       {
/* 202 */         action_status = basic_action.status();
/*     */       }
/*     */       else
/*     */       {
/* 210 */         action_status = getObjectStoreStatus(tranUid, transactionType);
/*     */       }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 215 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */       {
/* 217 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.recovery.ActionStatusService_3", new Object[] { ex });
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 222 */     return action_status;
/*     */   }
/*     */ 
/*     */   private int getTranStatus(Uid tranUid)
/*     */   {
/* 232 */     int action_status = 9;
/*     */     try
/*     */     {
/* 236 */       BasicAction basic_action = null;
/*     */ 
/* 238 */       synchronized (ActionManager.manager())
/*     */       {
/* 240 */         basic_action = ActionManager.manager().get(tranUid);
/*     */       }
/*     */ 
/* 243 */       if (basic_action != null)
/*     */       {
/* 245 */         action_status = basic_action.status();
/*     */       }
/*     */       else
/*     */       {
/* 252 */         action_status = getOsStatus(tranUid);
/*     */       }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 257 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */       {
/* 259 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.recovery.ActionStatusService_3", new Object[] { ex });
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 264 */     return action_status;
/*     */   }
/*     */ 
/*     */   private int getOsStatus(Uid tranUid)
/*     */   {
/* 274 */     int action_status = 9;
/*     */ 
/* 276 */     Vector matchingUidVector = new Vector();
/* 277 */     Vector matchingUidTypeVector = new Vector();
/*     */     try
/*     */     {
/* 281 */       InputObjectState types = new InputObjectState();
/*     */ 
/* 284 */       if (_objectStore.allTypes(types))
/*     */       {
/* 286 */         String theTypeName = null;
/*     */         try
/*     */         {
/* 290 */           boolean endOfList = false;
/*     */ 
/* 292 */           while (!endOfList)
/*     */           {
/* 295 */             theTypeName = types.unpackString();
/*     */ 
/* 297 */             if (theTypeName.compareTo("") == 0)
/*     */             {
/* 299 */               endOfList = true; continue;
/*     */             }
/*     */ 
/* 303 */             InputObjectState uids = new InputObjectState();
/*     */             try
/*     */             {
/* 307 */               boolean endOfUids = false;
/*     */ 
/* 309 */               if (_objectStore.allObjUids(theTypeName, uids))
/*     */               {
/* 311 */                 Uid theUid = new Uid(Uid.nullUid());
/*     */ 
/* 313 */                 while (!endOfUids)
/*     */                 {
/* 316 */                   theUid.unpack(uids);
/*     */ 
/* 318 */                   if (theUid.equals(Uid.nullUid()))
/*     */                   {
/* 320 */                     endOfUids = true; continue;
/*     */                   }
/* 322 */                   if (!theUid.equals(tranUid)) {
/*     */                     continue;
/*     */                   }
/* 325 */                   matchingUidVector.addElement(tranUid);
/* 326 */                   matchingUidTypeVector.addElement(theTypeName);
/* 327 */                   if (!tsLogger.arjLoggerI18N.isInfoEnabled())
/*     */                     continue;
/* 329 */                   tsLogger.arjLoggerI18N.info("com.arjuna.ats.arjuna.recovery.ActionStatusService_4", new Object[] { tranUid });
/*     */                 }
/*     */ 
/*     */               }
/*     */ 
/*     */             }
/*     */             catch (Exception ex)
/*     */             {
/* 337 */               if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */               {
/* 339 */                 tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.recovery.ActionStatusService_5", new Object[] { ex });
/*     */               }
/*     */             }
/*     */           }
/*     */ 
/*     */         }
/*     */         catch (IOException ex)
/*     */         {
/* 347 */           if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */           {
/* 349 */             tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.recovery.ActionStatusService_5", new Object[] { ex });
/*     */           }
/*     */         }
/*     */         catch (Exception ex)
/*     */         {
/* 354 */           if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */           {
/* 356 */             tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.recovery.ActionStatusService_5", new Object[] { ex });
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 363 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */       {
/* 365 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.recovery.ActionStatusService_5", new Object[] { ex });
/*     */       }
/*     */     }
/*     */ 
/* 369 */     int uidVectorSize = matchingUidVector.size();
/* 370 */     int first_index = 0;
/*     */ 
/* 372 */     if (uidVectorSize == 0)
/*     */     {
/* 375 */       action_status = 4;
/*     */     }
/* 377 */     else if (uidVectorSize == 1)
/*     */     {
/* 379 */       Uid uid = (Uid)matchingUidVector.get(first_index);
/* 380 */       String typeName = (String)matchingUidTypeVector.get(first_index);
/*     */ 
/* 382 */       action_status = getObjectStoreStatus(uid, typeName);
/*     */     }
/* 385 */     else if (uidVectorSize > 1)
/*     */     {
/* 388 */       Uid rootUid = (Uid)matchingUidVector.get(first_index);
/* 389 */       String rootTypeName = (String)matchingUidTypeVector.get(first_index);
/*     */ 
/* 391 */       for (int index = first_index + 1; index < uidVectorSize; index++)
/*     */       {
/* 393 */         String typeName = (String)matchingUidTypeVector.get(index);
/* 394 */         if (typeName.length() >= rootTypeName.length())
/*     */           continue;
/* 396 */         rootTypeName = typeName;
/* 397 */         rootUid = (Uid)matchingUidVector.get(index);
/*     */       }
/*     */ 
/* 401 */       action_status = getObjectStoreStatus(rootUid, rootTypeName);
/*     */     }
/*     */ 
/* 404 */     return action_status;
/*     */   }
/*     */ 
/*     */   private int getObjectStoreStatus(Uid tranUid, String transactionType)
/*     */   {
/* 412 */     int action_status = 9;
/*     */     try
/*     */     {
/* 416 */       int osState = _objectStore.currentState(tranUid, transactionType);
/*     */ 
/* 418 */       switch (osState)
/*     */       {
/*     */       case 1:
/* 421 */         action_status = 7;
/* 422 */         break;
/*     */       case 0:
/* 424 */         action_status = 4;
/* 425 */         break;
/*     */       case 2:
/*     */       case 4:
/*     */       case 5:
/*     */       case 6:
/* 430 */         action_status = 5;
/*     */       case 3:
/*     */       }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 436 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */       {
/* 438 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.recovery.ActionStatusService_6", new Object[] { ex });
/*     */       }
/*     */     }
/*     */ 
/* 442 */     return action_status;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.arjuna.recovery.ActionStatusService
 * JD-Core Version:    0.6.0
 */